/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.marker.IMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageMarkerViewer
implements IMessageMarkerViewer {
    private final HashSet<Class<? extends IMessageMarker>> markerTypes = new LinkedHashSet<Class<? extends IMessageMarker>>();
    private final ListenerList<IBasicMarkableRidget> ridgets = new ListenerList(IBasicMarkableRidget.class);
    private boolean visible = true;

    public static String constructMessage(Collection<IMessageMarker> messageMarker, String separator) {
        Assert.isNotNull((Object)separator);
        StringWriter sw = new StringWriter();
        if (messageMarker != null) {
            for (IMessageMarker nextMarker : messageMarker) {
                if (sw.toString().trim().length() > 0) {
                    sw.write(separator);
                }
                if (nextMarker.getMessage() == null) continue;
                sw.write(nextMarker.getMessage());
            }
        }
        return sw.toString().trim();
    }

    public AbstractMessageMarkerViewer() {
        this.markerTypes.add(ValidationMessageMarker.class);
        this.markerTypes.add(ErrorMessageMarker.class);
    }

    @Override
    public void addRidget(IBasicMarkableRidget markableRidget) {
        this.ridgets.add((Object)markableRidget);
        this.showMessages(markableRidget);
    }

    @Override
    public void removeRidget(IBasicMarkableRidget markableRidget) {
        this.ridgets.remove((Object)markableRidget);
        this.hideMessages(markableRidget);
    }

    @Override
    public void addMarkerType(Class<? extends IMessageMarker> markerClass) {
        this.markerTypes.add(markerClass);
        this.showMessages();
    }

    @Override
    public void removeMarkerType(Class<? extends IMessageMarker> markerClass) {
        this.markerTypes.remove(markerClass);
        this.showMessages();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.showMessages();
    }

    private void showMessages() {
        for (IBasicMarkableRidget ridget : this.getRidgets()) {
            this.showMessages(ridget);
        }
    }

    protected abstract String getMessageSeparator();

    protected abstract void showMessages(IBasicMarkableRidget var1);

    protected abstract void hideMessages(IBasicMarkableRidget var1);

    protected Collection<IMessageMarker> getMessageMarker(IBasicMarkableRidget markableRidget) {
        return this.getMessageMarker(markableRidget, false);
    }

    protected Collection<IMessageMarker> getMessageMarker(IBasicMarkableRidget markableRidget, boolean pRemove) {
        ArrayList<IMessageMarker> result = new ArrayList<IMessageMarker>();
        for (Class<? extends IMessageMarker> nextMessageMarkerType : this.markerTypes) {
            Collection nextMessageMarkers = markableRidget.getMarkersOfType(nextMessageMarkerType);
            if (nextMessageMarkers == null || nextMessageMarkers.size() <= 0) continue;
            result.addAll(nextMessageMarkers);
        }
        if (pRemove) {
            for (IMessageMarker iMessageMarker : result) {
                markableRidget.removeMarker((IMarker)iMessageMarker);
            }
        }
        Collections.sort(result, new MessageMarkerComparator());
        return result;
    }

    protected Collection<IBasicMarkableRidget> getRidgets() {
        return Arrays.asList((IBasicMarkableRidget[])this.ridgets.getListeners());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class MessageMarkerComparator
    implements Comparator<IMessageMarker>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected MessageMarkerComparator() {
        }

        @Override
        public int compare(IMessageMarker o1, IMessageMarker o2) {
            String message1 = o1.getMessage();
            String message2 = o2.getMessage();
            return message1.compareTo(message2);
        }
    }
}

