/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.swt.CompletionCombo;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.riena.ui.swt.IDecorationActivationStrategy;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class BorderDrawer
implements Listener {
    public static final int DEFAULT_BORDER_WIDTH = 1;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), BorderDrawer.class);
    private final IDecorationActivationStrategy activationStrategy;
    private final Control control;
    private Color borderColor;
    private int borderWidth;
    private final List<Runnable> toUnregister = new ArrayList<Runnable>();
    private Rectangle visibleControlAreaOnDisplay = new Rectangle(0, 0, 0, 0);
    private Rectangle updateArea;
    private int specialWidgetWidthAdjustment;
    private boolean computeBorderArea = true;
    private Event lastMoveEvent;
    private final Listener updateListener = new Listener(){

        public void handleEvent(Event event) {
            BorderDrawer.this.update(false);
        }
    };
    private boolean isMasterDetails;
    private Control controlToDecorate;

    public BorderDrawer(Control control) {
        this(control, 1, null, null);
    }

    public BorderDrawer(Control control, int borderWidth, Color borderColor, IDecorationActivationStrategy activationStrategy) {
        Assert.isNotNull((Object)control);
        this.control = control;
        this.borderWidth = borderWidth;
        this.borderColor = borderColor;
        this.activationStrategy = activationStrategy;
    }

    public void register() {
        if (this.control instanceof DatePickerComposite || this.control instanceof CompletionCombo) {
            Control[] children;
            this.specialWidgetWidthAdjustment = 16;
            Control[] controlArray = children = ((Composite)this.control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Text) {
                    this.registerToControl(child, 9);
                }
                ++n2;
            }
        } else if (this.control instanceof CCombo) {
            this.registerToControl((Control)this.control.getParent(), 9);
        } else {
            this.registerToControl(this.control, 9);
        }
        this.controlToDecorate = this.control;
        if ("mdTable".equals(SWTBindingPropertyLocator.getInstance().locateBindingProperty(this.getControlToDecorate()))) {
            this.controlToDecorate = this.getControlToDecorate().getParent().getParent();
            this.isMasterDetails = true;
        }
        Composite parent = this.getControlToDecorate().getParent();
        do {
            this.registerToControl((Control)parent, 11, 10);
            this.registerToControl((Control)parent, this.updateListener, 9);
        } while ((parent = parent.getParent()) != null);
        this.registerMnemonicsListener();
        this.registerToControl(this.getControlToDecorate(), new Listener(){

            public void handleEvent(Event event) {
                BorderDrawer.this.dispose();
            }
        }, 12);
    }

    public void dispose() {
        for (Runnable r : this.toUnregister) {
            r.run();
        }
        this.toUnregister.clear();
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void paintControl(Event event) {
        if (this.computeBorderArea) {
            Rectangle visibleControlArea = this.getControlToDecorate() instanceof CCombo || this.isMasterDetails ? ((Composite)this.getControlToDecorate()).getClientArea() : this.getVisibleControlArea(event);
            this.visibleControlAreaOnDisplay = this.includeBorder(this.toVisibleControlAreaOnDisplay(visibleControlArea));
            this.computeBorderArea = false;
        }
        if (this.shouldShowDecoration()) {
            Composite someParent = this.getControlToDecorate() instanceof Composite ? (Composite)this.getControlToDecorate() : this.getControlToDecorate().getParent();
            boolean fullyPainted = false;
            while (someParent != null && !fullyPainted) {
                fullyPainted = this.includeAndDrawBorder(someParent);
                someParent = someParent.getParent();
            }
        }
    }

    public void update(boolean redraw) {
        boolean redrawLater;
        if (SwtUtilities.isDisposed((Widget)this.getControlToDecorate())) {
            LOGGER.log(1, "Control with border is disposed", (Throwable)new Exception());
            return;
        }
        Shell shell = this.getControlToDecorate().getShell();
        boolean bl = redrawLater = this.updateArea == null;
        if (redraw && !redrawLater) {
            shell.redraw(this.updateArea.x, this.updateArea.y, this.updateArea.width, this.updateArea.height, true);
        }
        Rectangle bounds = this.getControlToDecorate().getBounds();
        bounds.y = 0;
        bounds.x = 0;
        bounds = this.getVisibleControlAreaStartingWith(bounds, null);
        Rectangle onDisplay = this.toVisibleControlAreaOnDisplay(bounds);
        this.updateArea = this.includeBorder(this.toAreaOnControl(onDisplay, (Control)shell));
        --this.updateArea.x;
        --this.updateArea.y;
        this.updateArea.width += 2;
        this.updateArea.height += 2;
        if (redraw && redrawLater) {
            shell.redraw(this.updateArea.x, this.updateArea.y, this.updateArea.width, this.updateArea.height, true);
        }
    }

    private void registerMnemonicsListener() {
        final Listener altListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 65536) {
                    BorderDrawer.this.update(true);
                    BorderDrawer.this.getControlToDecorate().getDisplay().removeFilter(1, (Listener)this);
                }
            }
        };
        final Display display = this.getControlToDecorate().getDisplay();
        display.addFilter(1, altListener);
        this.toUnregister.add(new Runnable(){

            public void run() {
                display.removeFilter(1, altListener);
            }
        });
    }

    private void registerToControl(Control control, int ... eventTypes) {
        this.registerToControl(control, this, eventTypes);
    }

    private void registerToControl(final Control control, final Listener listener, final int ... eventTypes) {
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int eventType = nArray[n2];
            control.addListener(eventType, listener);
            ++n2;
        }
        this.toUnregister.add(new Runnable(){

            public void run() {
                if (!control.isDisposed()) {
                    int[] nArray = eventTypes;
                    int n = eventTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int eventType = nArray[n2];
                        control.removeListener(eventType, listener);
                        ++n2;
                    }
                }
            }
        });
    }

    private boolean shouldShowDecoration() {
        if (SwtUtilities.isDisposed((Widget)this.getControlToDecorate())) {
            return false;
        }
        if (!this.getControlToDecorate().isVisible()) {
            return false;
        }
        if (this.borderWidth <= 0) {
            return false;
        }
        return this.activationStrategy == null || this.activationStrategy.isActive();
    }

    private boolean includeAndDrawBorder(Composite someParent) {
        Rectangle areaOnControl = this.toAreaOnControl(this.visibleControlAreaOnDisplay, (Control)someParent);
        Rectangle clientArea = someParent.getClientArea();
        GC gc = new GC((Drawable)someParent);
        this.drawBorder(areaOnControl, gc);
        gc.dispose();
        return areaOnControl.x + areaOnControl.width < clientArea.width && areaOnControl.y + areaOnControl.width < clientArea.height;
    }

    private void drawBorder(Rectangle rect, GC gc) {
        if (rect.width == 0 && rect.height == 0) {
            return;
        }
        Color previousForeground = gc.getForeground();
        if (this.borderColor != null) {
            gc.setForeground(this.borderColor);
        } else {
            LOGGER.log(2, "BorderColor is null!");
        }
        int i = 0;
        while (i < this.borderWidth) {
            gc.drawRectangle(rect.x + i, rect.y + i, rect.width - 2 * i, rect.height - 2 * i);
            ++i;
        }
        gc.setForeground(previousForeground);
    }

    private Rectangle getVisibleControlArea(Event event) {
        Rectangle visibleControlArea = new Rectangle(0, 0, 0, 0);
        visibleControlArea.width = event.x > 0 ? event.x + event.width : event.width;
        visibleControlArea.height = event.y > 0 ? event.y + event.height : event.height;
        return this.getVisibleControlAreaStartingWith(visibleControlArea, event);
    }

    private Rectangle getVisibleControlAreaStartingWith(Rectangle visibleControlArea, Event event) {
        if (this.getControlToDecorate() instanceof Scrollable) {
            ScrollBar verticalBar;
            ScrollBar horizontalBar = ((Scrollable)this.getControlToDecorate()).getHorizontalBar();
            if (horizontalBar != null && horizontalBar.isVisible()) {
                visibleControlArea.height += horizontalBar.getSize().y;
            }
            if ((verticalBar = ((Scrollable)this.getControlToDecorate()).getVerticalBar()) != null && verticalBar.isVisible()) {
                visibleControlArea.width += verticalBar.getSize().x;
            }
        }
        if (this.getControlToDecorate() instanceof Tree) {
            Tree t = (Tree)this.getControlToDecorate();
            if (t.getColumnCount() > 0 && event != null) {
                visibleControlArea.x = event.x;
                visibleControlArea.width -= event.x;
            }
            if (t.getHeaderVisible()) {
                visibleControlArea.y -= t.getHeaderHeight();
                visibleControlArea.height += t.getHeaderHeight();
            }
        } else if (this.getControlToDecorate() instanceof DatePickerComposite && visibleControlArea.width + this.specialWidgetWidthAdjustment + 2 * this.getControlToDecorate().getBorderWidth() == this.getControlToDecorate().getBounds().width) {
            visibleControlArea.width += this.specialWidgetWidthAdjustment;
        } else if (this.getControlToDecorate() instanceof CompletionCombo) {
            if (((Composite)this.getControlToDecorate()).getChildren().length == 3) {
                visibleControlArea.x -= 16;
                visibleControlArea.width += 16;
            } else if (visibleControlArea.width + this.specialWidgetWidthAdjustment + 2 * this.getControlToDecorate().getBorderWidth() + 1 == this.getControlToDecorate().getBounds().width) {
                visibleControlArea.width += this.specialWidgetWidthAdjustment + 1;
            }
        }
        return visibleControlArea;
    }

    private Rectangle toAreaOnControl(Rectangle onDisplay, Control target) {
        Point onControl = target.toControl(onDisplay.x, onDisplay.y);
        return new Rectangle(onControl.x, onControl.y, onDisplay.width, onDisplay.height);
    }

    private Rectangle includeBorder(Rectangle visibleControlArea) {
        int controlBorder = this.getControlToDecorate().getBorderWidth();
        int border = controlBorder + this.borderWidth;
        int x = visibleControlArea.x - border;
        int y = visibleControlArea.y - border;
        int width = visibleControlArea.width + 2 * border - 1;
        int height = visibleControlArea.height + 2 * border - 1;
        return new Rectangle(x, y, width, height);
    }

    private Rectangle toVisibleControlAreaOnDisplay(Rectangle visibleControlArea) {
        Point onDisplay = this.getControlToDecorate().toDisplay(visibleControlArea.x, visibleControlArea.y);
        return new Rectangle(onDisplay.x, onDisplay.y, visibleControlArea.width, visibleControlArea.height);
    }

    public void handleEvent(final Event event) {
        switch (event.type) {
            case 10: {
                this.computeBorderArea = true;
                this.lastMoveEvent = event;
                if (SwtUtilities.isDisposed((Widget)this.getControlToDecorate())) break;
                this.update(false);
                this.getControlToDecorate().getDisplay().timerExec(200, new Runnable(){

                    public void run() {
                        if (event == BorderDrawer.this.lastMoveEvent && !SwtUtilities.isDisposed((Widget)BorderDrawer.this.getControlToDecorate())) {
                            BorderDrawer.this.getControlToDecorate().redraw();
                        }
                    }
                });
                break;
            }
            case 11: {
                this.computeBorderArea = true;
                this.update(true);
                break;
            }
            case 9: {
                this.paintControl(event);
                break;
            }
        }
    }

    private Control getControlToDecorate() {
        return this.controlToDecorate;
    }
}

