/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.Collection;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.swt.IEmbeddedTitleBarListener;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.EmbeddedTitlebarRenderer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedTitleBar
extends Canvas {
    private boolean windowActive;
    private boolean pressed;
    private boolean hover;
    private boolean closeButtonPressed;
    private boolean closeButtonHover;
    private boolean closeable;
    private Image image;
    private String title;
    private String toolTipText;
    private Collection<? extends IMarker> markers;
    protected ListenerList<IEmbeddedTitleBarListener> titleBarListeners;
    private PaintListener paintListener;
    private TitlebarMouseListener mouseListener;

    public EmbeddedTitleBar(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListeners();
        this.titleBarListeners = new ListenerList(IEmbeddedTitleBarListener.class);
    }

    protected void addListeners() {
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                EmbeddedTitleBar.this.onPaint(e);
            }
        };
        this.addPaintListener(this.paintListener);
        this.mouseListener = new TitlebarMouseListener();
        this.addMouseListener(this.mouseListener);
        SWTFacade swtFacade = SWTFacade.getDefault();
        swtFacade.addMouseMoveListener((Control)this, this.mouseListener);
        swtFacade.addMouseTrackListener((Control)this, this.mouseListener);
    }

    protected void removeListeners() {
        if (this.mouseListener != null) {
            this.removeMouseListener(this.mouseListener);
            SWTFacade swtFacade = SWTFacade.getDefault();
            swtFacade.removeMouseMoveListener((Control)this, this.mouseListener);
            swtFacade.removeMouseTrackListener((Control)this, this.mouseListener);
            this.mouseListener = null;
        }
        if (this.paintListener != null) {
            this.removePaintListener(this.paintListener);
            this.paintListener = null;
        }
    }

    private void onPaint(PaintEvent e) {
        GC gc = e.gc;
        this.getLnfTitlebarRenderer().setActive(this.isWindowActive());
        this.getLnfTitlebarRenderer().setCloseable(this.isCloseable());
        this.getLnfTitlebarRenderer().setPressed(this.isPressed());
        this.getLnfTitlebarRenderer().setHover(this.isHover());
        this.getLnfTitlebarRenderer().setCloseButtonPressed(this.isCloseButtonPressed());
        this.getLnfTitlebarRenderer().setCloseButtonHover(this.isCloseButtonHover());
        this.getLnfTitlebarRenderer().setImage(this.getImage());
        this.getLnfTitlebarRenderer().setTitle(this.getTitle());
        this.getLnfTitlebarRenderer().setMarkers(this.getMarkers());
        Point titlebarSize = this.getLnfTitlebarRenderer().computeSize(gc, this.getBounds().width, 0);
        Rectangle titlebarBounds = new Rectangle(0, 0, titlebarSize.x, titlebarSize.y);
        this.getLnfTitlebarRenderer().setBounds(titlebarBounds);
        this.getLnfTitlebarRenderer().paint(gc, (Object)this);
    }

    protected EmbeddedTitlebarRenderer getLnfTitlebarRenderer() {
        EmbeddedTitlebarRenderer renderer = (EmbeddedTitlebarRenderer)LnfManager.getLnf().getRenderer("SubModuleView.titlebarRenderer");
        if (renderer == null) {
            renderer = new EmbeddedTitlebarRenderer();
        }
        return renderer;
    }

    public void addEmbeddedTitleBarListener(IEmbeddedTitleBarListener listener) {
        this.titleBarListeners.add((Object)listener);
    }

    public void removeEmbeddedTitleBarListener(IEmbeddedTitleBarListener listener) {
        this.titleBarListeners.remove((Object)listener);
    }

    public Point getSize() {
        Point size = super.getSize();
        GC gc = new GC((Drawable)this);
        size = this.getLnfTitlebarRenderer().computeSize(gc, size.x, size.y);
        gc.dispose();
        return size;
    }

    public boolean isFocusControl() {
        return false;
    }

    public boolean isWindowActive() {
        return this.windowActive;
    }

    public void setWindowActive(boolean active) {
        if (this.hasChanged(this.windowActive, active)) {
            this.windowActive = active;
            this.redraw();
        }
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        if (this.isDisposed()) {
            return;
        }
        if (this.hasChanged(this.pressed, pressed)) {
            this.pressed = pressed;
            this.redraw();
        }
    }

    public boolean isHover() {
        return this.hover;
    }

    public void setHover(boolean hover) {
        if (this.isDisposed()) {
            return;
        }
        if (this.hasChanged(this.hover, hover)) {
            this.hover = hover;
            this.redraw();
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        if (this.hasChanged(this.closeable, closeable)) {
            this.closeable = closeable;
            this.redraw();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (this.hasChanged(this.title, title)) {
            this.title = title;
            this.redraw();
        }
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setImage(Image image) {
        if (this.hasChanged(this.image, image)) {
            this.image = image;
            this.redraw();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setMarkers(Collection<? extends IMarker> markers) {
        this.markers = markers;
    }

    public Collection<? extends IMarker> getMarkers() {
        return this.markers;
    }

    public <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        return Markable.getMarkersOfType(this.getMarkers(), type);
    }

    protected boolean isOverClose(Point point) {
        if (!this.isCloseable()) {
            return false;
        }
        boolean inside = this.getLnfTitlebarRenderer().isInsideCloseButton(point);
        return inside;
    }

    public boolean isTextClipped() {
        EmbeddedTitlebarRenderer titlebarRenderer = this.getLnfTitlebarRenderer();
        titlebarRenderer.setBounds(this.getBounds());
        GC gc = new GC((Drawable)this);
        String clippedText = titlebarRenderer.getClippedText(gc, this.title);
        gc.dispose();
        if (StringUtils.isEmpty((CharSequence)this.title)) {
            return false;
        }
        return !this.title.equals(clippedText);
    }

    private boolean hasChanged(Object oldValue, Object newValue) {
        return oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
    }

    public void setCloseButtonPressed(boolean closeButtonPressed) {
        if (this.isDisposed()) {
            return;
        }
        if (this.hasChanged(this.closeButtonPressed, closeButtonPressed)) {
            this.closeButtonPressed = closeButtonPressed;
            this.redraw();
        }
    }

    public boolean isCloseButtonPressed() {
        return this.closeButtonPressed;
    }

    public void setCloseButtonHover(boolean closeButtonHover) {
        if (this.isDisposed()) {
            return;
        }
        if (this.hasChanged(this.closeButtonHover, closeButtonHover) && !this.isDisposed()) {
            this.closeButtonHover = closeButtonHover;
            this.redraw();
        }
    }

    public boolean isCloseButtonHover() {
        return this.closeButtonHover;
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    private class TitlebarMouseListener
    implements MouseListener,
    MouseTrackListener,
    MouseMoveListener {
        private TitlebarMouseListener() {
        }

        public void mouseUp(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (!this.shouldIgnore(e)) {
                Point point = new Point(e.x, e.y);
                if (EmbeddedTitleBar.this.isOverClose(point)) {
                    this.fireClosed(e);
                } else {
                    this.fireActivated(e);
                }
                EmbeddedTitleBar.this.setPressed(false);
            }
            this.updateCloseButtonState(e);
        }

        public void mouseDown(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (!this.shouldIgnore(e)) {
                EmbeddedTitleBar.this.setPressed(true);
            }
            this.updateCloseButtonState(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            EmbeddedTitleBar.this.setHover(true);
            this.updateCloseButtonState(e);
        }

        public void mouseExit(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            EmbeddedTitleBar.this.setHover(false);
            this.updateCloseButtonState(e);
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseMove(MouseEvent e) {
            this.updateCloseButtonState(e);
        }

        private void updateCloseButtonState(MouseEvent e) {
            Point point = new Point(e.x, e.y);
            if (EmbeddedTitleBar.this.isOverClose(point)) {
                EmbeddedTitleBar.this.setCloseButtonHover(EmbeddedTitleBar.this.isHover());
                EmbeddedTitleBar.this.setCloseButtonPressed(EmbeddedTitleBar.this.isPressed());
            } else {
                EmbeddedTitleBar.this.setCloseButtonHover(false);
                EmbeddedTitleBar.this.setCloseButtonPressed(false);
            }
        }

        protected boolean shouldIgnore(MouseEvent e) {
            return e.button != 1;
        }

        protected boolean isEnabled() {
            return EmbeddedTitleBar.this.getMarkersOfType(DisabledMarker.class).isEmpty();
        }

        private void fireActivated(MouseEvent event) {
            IEmbeddedTitleBarListener[] iEmbeddedTitleBarListenerArray = (IEmbeddedTitleBarListener[])EmbeddedTitleBar.this.titleBarListeners.getListeners();
            int n = iEmbeddedTitleBarListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEmbeddedTitleBarListener listener = iEmbeddedTitleBarListenerArray[n2];
                listener.windowActivated(event);
                ++n2;
            }
        }

        private void fireClosed(MouseEvent event) {
            IEmbeddedTitleBarListener[] iEmbeddedTitleBarListenerArray = (IEmbeddedTitleBarListener[])EmbeddedTitleBar.this.titleBarListeners.getListeners();
            int n = iEmbeddedTitleBarListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEmbeddedTitleBarListener listener = iEmbeddedTitleBarListenerArray[n2];
                listener.windowClosed(event);
                ++n2;
            }
        }
    }
}

