/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacadeFactory {
    private FacadeFactory() {
    }

    static <T> T newFacade(Class<T> type) {
        String suffix = "rap".equals(SWT.getPlatform()) ? "RAP" : "RCP";
        String name = String.valueOf(type.getName()) + suffix;
        try {
            return type.cast(type.getClassLoader().loadClass(name).newInstance());
        }
        catch (ClassCastException e) {
            String msg = NLS.bind((String)"Could not create an instance of {0} because it is not a {1}", (Object)name, (Object)type.getName());
            throw new RuntimeException(msg, e);
        }
        catch (Throwable throwable) {
            String msg = NLS.bind((String)"Could not load {0}", (Object)name);
            throw new RuntimeException(msg, throwable);
        }
    }
}

