/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;

public class Markable
implements IMarkable {
    private final List<IMarker> markers = new ArrayList<IMarker>();

    @Override
    public void addMarker(IMarker marker) {
        Assert.isNotNull((Object)marker);
        if (this.markers.contains(marker)) {
            return;
        }
        if (marker.isUnique()) {
            Collection<?> markersOfType = this.getMarkersOfType(marker.getClass());
            boolean unique = false;
            for (IMarker m : markersOfType) {
                if (!m.isUnique()) continue;
                unique = true;
                break;
            }
            if (!unique) {
                this.markers.add(marker);
            }
        } else {
            this.markers.add(marker);
        }
    }

    @Override
    public Collection<? extends IMarker> getMarkers() {
        return this.markers;
    }

    @Override
    public <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        return Markable.getMarkersOfType(this.getMarkers(), type);
    }

    @Override
    public void removeAllMarkers() {
        this.markers.clear();
    }

    @Override
    public boolean removeMarker(IMarker marker) {
        return this.markers.remove(marker);
    }

    public static <T extends IMarker> Collection<T> getMarkersOfType(Collection<? extends IMarker> markerSet, Class<T> type) {
        if (type == null || markerSet == null) {
            return Collections.emptyList();
        }
        ArrayList<IMarker> typedMarkerList = null;
        for (IMarker iMarker : markerSet) {
            if (!type.isAssignableFrom(iMarker.getClass())) continue;
            if (typedMarkerList == null) {
                typedMarkerList = new ArrayList<IMarker>();
            }
            typedMarkerList.add(iMarker);
        }
        if (typedMarkerList == null) {
            return Collections.emptyList();
        }
        return typedMarkerList;
    }
}

