/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.exception.Failure;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.wire.Wire;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.SynchronousBundleListener;

public final class Companion {
    private static final Map<Class<Object>, Object> CLASS_TO_COMPANION;
    private static final Map<Bundle, List<Class<Object>>> BUNDLE_TO_CLASSES;
    private static final Bundle THIS_BUNDLE;
    private static final SynchronousBundleListener FREE_ME;
    private static final Object LOCK;

    static {
        BundleContext bundleContext;
        CLASS_TO_COMPANION = new HashMap<Class<Object>, Object>();
        BUNDLE_TO_CLASSES = new HashMap<Bundle, List<Class<Object>>>();
        THIS_BUNDLE = FrameworkUtil.getBundle(Companion.class);
        FREE_ME = new FreeMe();
        LOCK = new Object();
        if (THIS_BUNDLE != null && (bundleContext = THIS_BUNDLE.getBundleContext()) != null) {
            bundleContext.addBundleListener((BundleListener)FREE_ME);
        }
    }

    private Companion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T> T per(Class<T> companionClass) {
        Object object = LOCK;
        synchronized (object) {
            Object companion = CLASS_TO_COMPANION.get(companionClass);
            if (companion == null) {
                companion = Companion.createCompanion(companionClass);
                Wire.instance(companion).andStart();
                Companion.register(companionClass, companion);
            }
            return (T)companion;
        }
    }

    private static <T> void register(Class<T> companionClass, T companion) {
        CLASS_TO_COMPANION.put(companionClass, companion);
        Bundle bundle = FrameworkUtil.getBundle(companionClass);
        if (bundle == null) {
            return;
        }
        List<Class<Object>> classes = BUNDLE_TO_CLASSES.get(bundle);
        if (classes == null) {
            classes = new ArrayList<Class<Object>>();
            BUNDLE_TO_CLASSES.put(bundle, classes);
        }
        classes.add(companionClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T createCompanion(Class<T> companionClass) {
        try {
            Constructor<T> constructor = companionClass.getDeclaredConstructor(new Class[0]);
            boolean isAccessible = constructor.isAccessible();
            try {
                if (!isAccessible) {
                    constructor.setAccessible(true);
                }
                T t = constructor.newInstance(new Object[0]);
                return t;
            }
            finally {
                if (!isAccessible) {
                    constructor.setAccessible(false);
                }
            }
        }
        catch (SecurityException e) {
            throw new CompanionCreationFailure("Could not create an instance for " + companionClass.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new CompanionCreationFailure("Could not create an instance for " + companionClass.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new CompanionCreationFailure("Could not create an instance for " + companionClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new CompanionCreationFailure("Could not create an instance for " + companionClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new CompanionCreationFailure("Could not create an instance for " + companionClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new CompanionCreationFailure("Could not create an instance for " + companionClass.getName(), e);
        }
    }

    private static final class CompanionCreationFailure
    extends Failure {
        private static final long serialVersionUID = 1L;

        public CompanionCreationFailure(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static final class FreeMe
    implements SynchronousBundleListener {
        private FreeMe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            BundleContext bundleContext;
            if (event.getType() != 256) {
                return;
            }
            Object object = LOCK;
            synchronized (object) {
                List remove = (List)BUNDLE_TO_CLASSES.remove(event.getBundle());
                for (Class clazz : Iter.able(remove)) {
                    CLASS_TO_COMPANION.remove(clazz);
                }
            }
            if (event.getBundle().equals(THIS_BUNDLE) && (bundleContext = THIS_BUNDLE.getBundleContext()) != null) {
                bundleContext.removeBundleListener((BundleListener)FREE_ME);
            }
        }
    }
}

