/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ListenerList<L>
implements Iterable<L> {
    private final boolean identity;
    private volatile L[] listeners;
    private final Object emptyArray;
    private final Class<?> listenerClass;

    private ListenerList() {
        this(null);
    }

    public ListenerList(Class<?> listenerClass) {
        this(Mode.EQUALITY, listenerClass);
    }

    public ListenerList(Mode mode, Class<?> listenerClass) {
        this.identity = mode == Mode.IDENTITY;
        this.listenerClass = listenerClass;
        this.emptyArray = Array.newInstance(listenerClass, 0);
        this.listeners = (Object[])this.emptyArray;
    }

    public synchronized void add(L listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        L[] LArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            L each = LArray[n2];
            if (this.identity ? listener == each : listener.equals(each)) {
                return;
            }
            ++n2;
        }
        int oldSize = this.listeners.length;
        Object[] newListeners = (Object[])Array.newInstance(this.listenerClass, oldSize + 1);
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = listener;
        this.listeners = newListeners;
    }

    public L[] getListeners() {
        return this.listeners;
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(L listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        int i = 0;
        while (i < oldSize) {
            L each = this.listeners[i];
            if (this.identity ? listener == each : listener.equals(each)) {
                if (oldSize == 1) {
                    this.listeners = (Object[])this.emptyArray;
                } else {
                    Object[] newListeners = (Object[])Array.newInstance(this.listenerClass, oldSize - 1);
                    System.arraycopy(this.listeners, 0, newListeners, 0, i);
                    System.arraycopy(this.listeners, i + 1, newListeners, i, oldSize - i - 1);
                    this.listeners = newListeners;
                }
                return;
            }
            ++i;
        }
    }

    public int size() {
        return this.listeners.length;
    }

    public synchronized void clear() {
        this.listeners = (Object[])this.emptyArray;
    }

    @Override
    public Iterator<L> iterator() {
        return new ArrayIterator(this.listeners);
    }

    private final class ArrayIterator
    implements Iterator<L> {
        private final L[] listeners;
        private int cursor = 0;
        private int lastReturned = -1;

        private ArrayIterator(L[] listeners) {
            this.listeners = listeners;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.listeners.length;
        }

        @Override
        public L next() {
            try {
                Object next = this.listeners[this.cursor];
                this.lastReturned = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            ListenerList.this.remove(this.listeners[this.lastReturned]);
            this.lastReturned = -1;
        }
    }

    public static enum Mode {
        EQUALITY,
        IDENTITY;

    }
}

