/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.test.collect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.JUnit4TestAdapter;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.internal.core.test.collect.NonGatherableTestCase;
import org.junit.Test;
import org.osgi.framework.Bundle;

public final class TestCollector {
    private static final String PLUS = " + ";

    private TestCollector() {
    }

    public static TestSuite createTestSuiteWith(Bundle bundle, Package withinPackage, Class<? extends Annotation> ... annotationClasses) {
        return TestCollector.createTestSuiteWith(bundle, withinPackage, false, annotationClasses);
    }

    public static TestSuite createTestSuiteWithJUnit3And4(Bundle bundle, Package withinPackage, Class<? extends Annotation> ... annotationClasses) {
        return TestCollector.createTestSuiteWithJUnit3And4(bundle, withinPackage, false, annotationClasses);
    }

    public static TestSuite createTestSuiteWith(Bundle bundle, Package withinPackage, boolean subPackages, Class<? extends Annotation> ... annotationClasses) {
        return TestCollector.createTestSuiteWith(bundle, withinPackage, subPackages, true, annotationClasses);
    }

    private static TestSuite createTestSuiteWith(Bundle bundle, Package withinPackage, boolean subPackages, boolean excludeJUnit4Tests, Class<? extends Annotation> ... annotationClasses) {
        StringBuilder bob = new StringBuilder("Tests within bundle '").append(bundle.getSymbolicName()).append("' and package '");
        bob.append(withinPackage == null ? "all" : withinPackage.getName()).append("'").append(" recursive '").append(subPackages).append("'");
        bob.append(" and restricted to '");
        Class<? extends Annotation>[] classArray = annotationClasses;
        int n = annotationClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> annotationClass = classArray[n2];
            bob.append(annotationClass.getSimpleName()).append(PLUS);
            ++n2;
        }
        if (annotationClasses.length > 0) {
            bob.setLength(bob.length() - PLUS.length());
        } else {
            bob.append("none");
        }
        bob.append("'.");
        TestSuite suite = new TestSuite(bob.toString());
        for (Class<?> clazz : TestCollector.collectWith(bundle, withinPackage, subPackages, excludeJUnit4Tests, annotationClasses)) {
            if (TestCase.class.isAssignableFrom(clazz)) {
                suite.addTestSuite(clazz);
                continue;
            }
            suite.addTest((junit.framework.Test)new JUnit4TestAdapter(clazz));
        }
        return suite;
    }

    public static TestSuite createTestSuiteWithJUnit3And4(Bundle bundle, Package withinPackage, boolean subPackages, Class<? extends Annotation> ... annotationClasses) {
        return TestCollector.createTestSuiteWith(bundle, withinPackage, subPackages, false, annotationClasses);
    }

    public static List<Class<? extends TestCase>> collectWith(Bundle bundle, Package withinPackage, boolean subPackages, Class<? extends Annotation> ... annotationClasses) {
        return TestCollector.convertToTestCaseList(TestCollector.collectWith(bundle, withinPackage, subPackages, true, annotationClasses));
    }

    private static List<Class<?>> collectWith(Bundle bundle, Package withinPackage, boolean subPackages, boolean excludeJUnit4Tests, Class<? extends Annotation> ... annotationClasses) {
        ArrayList testClasses = new ArrayList();
        for (Class<?> testClass : TestCollector.collect(bundle, withinPackage, subPackages, excludeJUnit4Tests)) {
            boolean collect = annotationClasses.length == 0;
            Class<? extends Annotation>[] classArray = annotationClasses;
            int n = annotationClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Annotation> annotationClass = classArray[n2];
                collect = collect || testClass.isAnnotationPresent(annotationClass);
                ++n2;
            }
            if (!collect) continue;
            testClasses.add(testClass);
        }
        return testClasses;
    }

    public static List<Class<?>> collectWithJUnit3And4(Bundle bundle, Package withinPackage, boolean subPackages, Class<? extends Annotation> ... annotationClasses) {
        return TestCollector.collectWith(bundle, withinPackage, subPackages, false, annotationClasses);
    }

    public static List<Class<? extends TestCase>> collectUnmarked(Bundle bundle, Package withinPackage) {
        return TestCollector.convertToTestCaseList(TestCollector.collectUnmarked(bundle, withinPackage, true));
    }

    private static List<Class<?>> collectUnmarked(Bundle bundle, Package withinPackage, boolean excludeJUnit4Tests) {
        ArrayList testClasses = new ArrayList();
        for (Class<?> testClass : TestCollector.collect(bundle, withinPackage, true, excludeJUnit4Tests)) {
            if (testClass.getAnnotations().length != 0) continue;
            testClasses.add(testClass);
        }
        return testClasses;
    }

    public static List<Class<?>> collectUnmarkedJUnit3And4(Bundle bundle, Package withinPackage) {
        return TestCollector.collectUnmarked(bundle, withinPackage, false);
    }

    public static List<Class<?>> collectBadlyNamedJUnit3And4(Bundle bundle, Package withinPackage) {
        return TestCollector.collectBadlyNamed(bundle, withinPackage, false);
    }

    public static List<Class<? extends TestCase>> collectBadlyNamed(Bundle bundle, Package withinPackage) {
        return TestCollector.convertToTestCaseList(TestCollector.collectBadlyNamed(bundle, withinPackage, true));
    }

    private static List<Class<?>> collectBadlyNamed(Bundle bundle, Package withinPackage, boolean excludeJUnit4Tests) {
        ArrayList testClasses = new ArrayList();
        Pattern testClassPattern = Pattern.compile(".*Test\\d*$");
        for (Class<?> testClass : TestCollector.collect(bundle, withinPackage, true, excludeJUnit4Tests)) {
            if (testClassPattern.matcher(testClass.getName()).matches()) continue;
            testClasses.add(testClass);
        }
        return testClasses;
    }

    public static List<Class<? extends TestCase>> collect(Bundle bundle, Package withinPackage, boolean subPackages) {
        return TestCollector.convertToTestCaseList(TestCollector.collect(bundle, withinPackage, subPackages, true));
    }

    private static List<Class<? extends TestCase>> convertToTestCaseList(List<Class<?>> classes) {
        ArrayList<Class<? extends TestCase>> result = new ArrayList<Class<? extends TestCase>>();
        for (Class<?> c : classes) {
            result.add(c);
        }
        return result;
    }

    public static List<Class<?>> collectJUnit3And4(Bundle bundle, Package withinPackage, boolean subPackages) {
        return TestCollector.collect(bundle, withinPackage, subPackages, false);
    }

    private static List<Class<?>> collect(Bundle bundle, Package withinPackage, boolean subPackages, boolean excludeJUnit4Tests) {
        ArrayList result = new ArrayList();
        Enumeration allClasses = bundle.findEntries("", "*.class", true);
        for (URL entryURL : Iter.able(allClasses)) {
            String url = entryURL.toExternalForm();
            if (url.contains("$")) continue;
            Class<?> clazz = TestCollector.getClass(bundle, entryURL);
            if (clazz == null) {
                TestCollector.trace("Could not get class from ", url);
                continue;
            }
            if (excludeJUnit4Tests && !TestCase.class.isAssignableFrom(clazz)) {
                TestCollector.trace("Not a JUnit3 TestCase: ", clazz.getName());
                continue;
            }
            String className = clazz.getName();
            if (withinPackage != null && (!subPackages ? !className.equals(String.valueOf(withinPackage.getName()) + "." + clazz.getSimpleName()) : !className.startsWith(withinPackage.getName()) || !className.endsWith(clazz.getSimpleName()))) continue;
            if (clazz.isAnnotationPresent(NonGatherableTestCase.class) || Modifier.isAbstract(clazz.getModifiers())) continue;
            TestCollector.addToListIfApplicable(clazz, result);
        }
        return result;
    }

    private static void addToListIfApplicable(Class<?> clazz, List<Class<?>> testClasses) {
        if (TestCase.class.isAssignableFrom(clazz)) {
            testClasses.add(clazz);
        } else if (TestCollector.isJUnit4TestCase(clazz)) {
            testClasses.add(clazz);
        }
    }

    private static boolean isJUnit4TestCase(Class<?> clazz) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Test.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Class<?> getClass(Bundle bundle, URL entryURL) {
        String entry;
        String name = entry = entryURL.toExternalForm().replace(".class", "").replace('/', '.');
        int dot = 0;
        while ((dot = name.indexOf(46, dot)) != -1) {
            String className = name.substring(dot + 1);
            try {
                return bundle.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++dot;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                ++dot;
            }
        }
        return null;
    }

    private static void trace(Object ... objects) {
        StringBuilder bob = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            bob.append(object);
            ++n2;
        }
        System.err.println(bob.toString());
    }
}

