/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class RestoreFocusOnEscListener
extends KeyAdapter
implements Listener {
    private final Set<CoolBar> controlSet;
    private final Shell shell;
    private Control savedFocusControl;

    public static CoolBar findCoolBar(Composite composite) {
        CoolBar result = null;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CoolBar) {
                result = (CoolBar)child;
                break;
            }
            ++n2;
        }
        return result;
    }

    public RestoreFocusOnEscListener(Shell shell) {
        Assert.isNotNull((Object)shell);
        this.controlSet = new HashSet<CoolBar>();
        this.shell = shell;
        this.shell.getDisplay().addFilter(15, (Listener)this);
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                event.display.removeFilter(15, (Listener)this);
            }
        });
    }

    public void addControl(CoolBar coolbar) {
        Assert.isNotNull((Object)coolbar);
        Assert.isTrue((coolbar.getShell() == this.shell ? 1 : 0) != 0, (String)"coolbar must be on same shell as this listener");
        if (this.controlSet.add(coolbar)) {
            Control[] controlArray = coolbar.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control coolbarChild = controlArray[n2];
                coolbarChild.addKeyListener((KeyListener)this);
                coolbarChild.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        ((Control)e.widget).removeKeyListener((KeyListener)RestoreFocusOnEscListener.this);
                    }
                });
                ++n2;
            }
        }
    }

    public void removeControl(CoolBar coolbar) {
        Assert.isNotNull((Object)coolbar);
        if (this.controlSet.remove(coolbar)) {
            Control[] controlArray = coolbar.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control coolbarChild = controlArray[n2];
                coolbarChild.removeKeyListener((KeyListener)this);
                ++n2;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.keyCode == 27 && !SwtUtilities.isDisposed((Widget)this.savedFocusControl)) {
            this.savedFocusControl.setFocus();
        }
    }

    public void handleEvent(Event event) {
        Control control;
        if (event.widget instanceof Control && this.contains((Composite)this.shell, control = (Control)event.widget) && !this.contains(this.controlSet, control)) {
            this.savedFocusControl = control;
        }
    }

    private boolean contains(Composite container, Control control) {
        boolean result = container == control;
        Composite parent = control.getParent();
        while (!result && parent != null) {
            result = container == parent;
            parent = parent.getParent();
        }
        return result;
    }

    private boolean contains(Collection<CoolBar> containers, Control control) {
        boolean result = false;
        for (Composite composite : containers) {
            boolean bl = result = result || this.contains(composite, control);
            if (result) break;
        }
        return result;
    }
}

