/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class SwitchToWorkarea
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String viewId = this.getViewId(this.getActiveNode());
        if (viewId != null) {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            IWorkbenchPage page = window.getActivePage();
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewRef = iViewReferenceArray[n2];
                if (viewId.equals(this.getFullId(viewRef))) {
                    IViewPart view = viewRef.getView(false);
                    if (view == null) break;
                    view.setFocus();
                    break;
                }
                ++n2;
            }
        }
        return null;
    }

    private INavigationNode<?> getActiveNode() {
        IApplicationNode appNode = ApplicationNodeManager.getApplicationNode();
        return appNode.getNavigationProcessor().getSelectedNode();
    }

    private String getFullId(IViewReference viewRef) {
        String result = viewRef.getId();
        if (viewRef.getSecondaryId() != null) {
            result = String.valueOf(result) + ":" + viewRef.getSecondaryId();
        }
        return result;
    }

    private String getViewId(INavigationNode<?> node) {
        SwtViewId viewId;
        String result = null;
        if (node != null && (viewId = SwtViewProvider.getInstance().getSwtViewId(node)) != null) {
            result = viewId.getCompoundId();
        }
        return result;
    }
}

