/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.AbstractScrollingSupport;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ScrollButtonsSupport
extends AbstractScrollingSupport {
    private final ScrollControlComposite scrollControlComposite;
    private int scrolledCompositeOffset = 0;

    public ScrollButtonsSupport(Composite parent, IModuleNavigationComponentProvider navigationComponentProvider) {
        super(navigationComponentProvider);
        this.scrollControlComposite = new ScrollControlComposite(parent, 0);
        this.setBodyCompositeOffset(0);
    }

    @Override
    public void scroll() {
        this.scrollControlComposite.setVisible(this.mayScroll());
        this.scrollToActive();
    }

    public Composite getScrollComposite() {
        return this.scrollControlComposite;
    }

    public int getButtonHeight() {
        return LnfManager.getLnf().getIntegerSetting("navigation.scroll.button.height", Integer.valueOf(15));
    }

    @Override
    protected void scrollUp(int pixels) {
        int offset = Math.min(this.scrolledCompositeOffset + pixels, 0);
        this.setBodyCompositeOffset(offset);
    }

    @Override
    protected void scrollDown(int pixels) {
        int offset = Math.max(this.getNavigationComponentHeight() - this.getScrolledComponentHeight(), this.scrolledCompositeOffset - pixels);
        this.setBodyCompositeOffset(offset);
    }

    private void scroll(ScrollDirection direction) {
        if (direction == ScrollDirection.UP) {
            this.scrollUp(20);
        } else {
            this.scrollDown(20);
        }
    }

    @Override
    protected boolean scrollTo(Composite topComp, Composite bottomComp) {
        int compBottomEdge = bottomComp.toDisplay((int)0, (int)bottomComp.getSize().y).y;
        boolean result = this.scrollToBottom(compBottomEdge);
        int compTopEdge = topComp.toDisplay((int)0, (int)0).y;
        result = result || this.scrollToTop(compTopEdge);
        return result;
    }

    @Override
    protected boolean scrollTo(Tree tree) {
        boolean result = false;
        if (tree.getSelectionCount() > 0) {
            TreeItem item = tree.getSelection()[0];
            Rectangle itemBounds = item.getBounds();
            int treeBottomEdge = tree.toDisplay((int)itemBounds.x, (int)(itemBounds.y + tree.getItemHeight())).y;
            result = this.scrollToBottom(treeBottomEdge);
            int treeTopEdge = tree.toDisplay((int)itemBounds.x, (int)itemBounds.y).y;
            result = result || this.scrollToTop(treeTopEdge);
        }
        return result;
    }

    private void scrollToActive() {
        if (!this.mayScroll()) {
            this.resetScrolling();
            return;
        }
        INavigationNode<?> activeNode = this.getActiveNode();
        if (!this.scrollTo(activeNode)) {
            this.ensureFilledToBottom();
        }
    }

    private boolean scrollTo(INavigationNode<?> activeNode) {
        boolean result = false;
        if (activeNode instanceof IModuleGroupNode) {
            ModuleGroupView view = this.navigationComponentProvider.getModuleGroupViewForNode((IModuleGroupNode)activeNode);
            result = this.scrollTo(view, view);
        } else if (activeNode instanceof IModuleNode) {
            result = this.scrollTo((IModuleNode)activeNode);
        } else if (activeNode instanceof ISubModuleNode) {
            IModuleNode module = (IModuleNode)activeNode.getParent();
            result = this.scrollTo(module);
        }
        return result;
    }

    private boolean scrollToBottom(int bottomEdgeToDisplay) {
        boolean scroll;
        int bottomEdge = this.getNavigationComponent().toDisplay((int)0, (int)this.getNavigationComponentHeight()).y;
        boolean bl = scroll = bottomEdgeToDisplay > bottomEdge;
        if (scroll) {
            this.scrollDown(bottomEdgeToDisplay - bottomEdge);
        }
        return scroll;
    }

    private boolean scrollToTop(int topEdgeToDisplay) {
        boolean scroll;
        int topEdge = this.getNavigationComponent().toDisplay((int)0, (int)0).y;
        boolean bl = scroll = topEdgeToDisplay < topEdge;
        if (scroll) {
            this.scrollUp(topEdge - topEdgeToDisplay);
        }
        return scroll;
    }

    private void ensureFilledToBottom() {
        int bodyBottomY = this.scrolledCompositeOffset + this.getScrolledComponentHeight();
        if (bodyBottomY < this.getNavigationComponentHeight()) {
            this.setBodyCompositeOffset(this.scrolledCompositeOffset + (this.getNavigationComponentHeight() - bodyBottomY));
        }
    }

    private void resetScrolling() {
        this.setBodyCompositeOffset(0);
        this.scrollControlComposite.setVisible(false);
    }

    private void setBodyCompositeOffset(int yScrolledOffset) {
        if (yScrolledOffset != this.scrolledCompositeOffset) {
            this.scrolledCompositeOffset = yScrolledOffset;
            this.updateUI();
        }
    }

    private void updateUI() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, this.scrolledCompositeOffset);
        this.getScrolledComponent().setLayoutData((Object)formData);
        this.getScrolledComponent().getParent().layout();
    }

    private final class ScrollControlComposite
    extends Composite {
        private Button upButton;
        private Button downButton;

        public ScrollControlComposite(Composite parent, int style) {
            super(parent, style);
            ScrollButtonsSupport.this.getNavigationComponent().addControlListener((ControlListener)new NavigationResizeListener());
            this.setBackground(LnfManager.getLnf().getColor("Navigation.background"));
            this.initControlButtons();
        }

        private void initControlButtons() {
            this.setLayout((Layout)new FormLayout());
            ScrollDelegate scrollingButtons = new ScrollDelegate();
            this.upButton = new Button((Composite)this, 0);
            this.upButton.setBackground(this.getBackground());
            this.upButton.setImage(LnfManager.getLnf().getImage("navigation.scrollup"));
            this.upButton.addMouseListener((MouseListener)scrollingButtons);
            this.layoutUpButton();
            this.downButton = new Button((Composite)this, 0);
            this.downButton.setBackground(this.getBackground());
            this.downButton.setImage(LnfManager.getLnf().getImage("navigation.scrollDown"));
            this.downButton.addMouseListener((MouseListener)scrollingButtons);
            this.layoutDownButton();
        }

        private void layoutDownButton() {
            FormData fd = new FormData();
            fd.left = new FormAttachment((Control)this.upButton, 1);
            fd.right = new FormAttachment(100, -2);
            fd.height = ScrollButtonsSupport.this.getButtonHeight();
            this.downButton.setLayoutData((Object)fd);
        }

        private void layoutUpButton() {
            FormData fd = new FormData();
            fd.left = new FormAttachment(0, 2);
            fd.right = new FormAttachment(50, 0);
            fd.height = ScrollButtonsSupport.this.getButtonHeight();
            this.upButton.setLayoutData((Object)fd);
        }

        private final class NavigationResizeListener
        extends ControlAdapter {
            private NavigationResizeListener() {
            }

            public void controlResized(ControlEvent e) {
                ScrollControlComposite.this.setVisible(ScrollButtonsSupport.this.mayScroll());
            }
        }

        private final class ScrollDelegate
        implements MouseListener {
            private final ScrollRunnable scrollRunnable = new ScrollRunnable();

            private ScrollDelegate() {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.getSource() == ScrollControlComposite.this.upButton) {
                    this.scrollRunnable.setDirection(ScrollDirection.UP);
                } else {
                    this.scrollRunnable.setDirection(ScrollDirection.DOWN);
                }
                ScrollControlComposite.this.getDisplay().timerExec(0, (Runnable)this.scrollRunnable);
            }

            public void mouseUp(MouseEvent e) {
                ScrollControlComposite.this.getDisplay().timerExec(-1, (Runnable)this.scrollRunnable);
                this.scrollRunnable.reset();
            }

            private class ScrollRunnable
            implements Runnable {
                private static final int MAX_SCROLL_INTERVAL = 150;
                private static final int MIN_SCROLL_INTERVAL = 30;
                public static final double SCROLL_INTERVAL_SPEEDUP = 1.05;
                private volatile ScrollDirection scrollDirection;
                private int currentScrollInterval;

                public ScrollRunnable() {
                    this.reset();
                }

                void setDirection(ScrollDirection scrollDirection) {
                    this.scrollDirection = scrollDirection;
                }

                @Override
                public void run() {
                    if (ScrollButtonsSupport.this.getNavigationComponent().isDisposed() || ScrollButtonsSupport.this.getScrolledComponent().isDisposed()) {
                        return;
                    }
                    ScrollButtonsSupport.this.scroll(this.scrollDirection);
                    if ((double)this.currentScrollInterval / 1.05 > 30.0) {
                        this.currentScrollInterval = (int)((double)this.currentScrollInterval / 1.05);
                    }
                    ScrollControlComposite.this.getDisplay().timerExec(this.currentScrollInterval, (Runnable)this);
                }

                public void reset() {
                    this.currentScrollInterval = 150;
                }
            }
        }
    }

    private static enum ScrollDirection {
        UP,
        DOWN;

    }
}

