/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.annotation.processor.NavigationNodeControllerAnnotationProcessor;
import org.eclipse.riena.navigation.common.TypecastingObject;
import org.eclipse.riena.navigation.listener.INavigationNodeListenerable;
import org.eclipse.riena.navigation.ui.controllers.NavigationUIFilterApplier;
import org.eclipse.riena.ui.core.context.IContext;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.ClassRidgetMapper;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.RidgetToStatuslineSubscriber;
import org.eclipse.riena.ui.ridgets.SubModuleUtils;
import org.eclipse.riena.ui.ridgets.controller.IController;

public abstract class NavigationNodeController<N extends INavigationNode<?>>
extends TypecastingObject
implements INavigationNodeController,
IController,
IContext {
    private N navigationNode;
    private Map<String, IRidget> ridgets;
    private NavigationUIFilterApplier<N> nodeListener;
    private PropertyChangeListener propertyChangeListener;
    private boolean configured = false;
    private final RidgetToStatuslineSubscriber ridgetToStatuslineSubscriber = new RidgetToStatuslineSubscriber();

    public NavigationNodeController() {
        this(null);
    }

    public NavigationNodeController(N navigationNode) {
        this.ridgets = new HashMap<String, IRidget>();
        this.propertyChangeListener = new PropertyChangeHandler();
        this.nodeListener = new NavigationUIFilterApplier();
        if (navigationNode != null) {
            this.setNavigationNode(navigationNode);
        }
    }

    public N getNavigationNode() {
        return this.navigationNode;
    }

    public void setNavigationNode(N navigationNode) {
        if (this.getNavigationNode() instanceof INavigationNodeListenerable) {
            ((INavigationNodeListenerable)this.getNavigationNode()).removeListener(this.nodeListener);
        }
        this.navigationNode = navigationNode;
        navigationNode.setNavigationNodeController((INavigationNodeController)this);
        this.updateNavigationNodeMarkers();
        if (this.getNavigationNode() instanceof INavigationNodeListenerable) {
            ((INavigationNodeListenerable)this.getNavigationNode()).addListener(this.nodeListener);
        }
    }

    public boolean allowsActivate(INavigationNode<?> pNode, INavigationContext context) {
        return true;
    }

    public boolean allowsDeactivate(INavigationNode<?> pNode, INavigationContext context) {
        return true;
    }

    public void afterBind() {
        NavigationNodeControllerAnnotationProcessor.getInstance().processAnnotations((INavigationNodeController)this);
        this.updateNavigationNodeMarkers();
    }

    public boolean isActivated() {
        return this.getNavigationNode() != null && this.getNavigationNode().isActivated();
    }

    public boolean isEnabled() {
        return this.getNavigationNode() != null && this.getNavigationNode().isEnabled();
    }

    public boolean isVisible() {
        return this.getNavigationNode() != null && this.getNavigationNode().isVisible();
    }

    public boolean isDeactivated() {
        return this.getNavigationNode() == null || this.getNavigationNode().isDeactivated();
    }

    public boolean isCreated() {
        return this.getNavigationNode() == null || this.getNavigationNode().isCreated();
    }

    public boolean allowsDispose(INavigationNode<?> node, INavigationContext context) {
        return true;
    }

    public void addRidget(String id, IRidget ridget) {
        ridget.addPropertyChangeListener("marker", this.propertyChangeListener);
        ridget.addPropertyChangeListener("markerHiding", this.propertyChangeListener);
        ridget.addPropertyChangeListener("showing", this.propertyChangeListener);
        ridget.addPropertyChangeListener("update", this.propertyChangeListener);
        this.ridgets.put(id, ridget);
        this.ridgetToStatuslineSubscriber.addRidget(ridget);
    }

    public boolean removeRidget(String id) {
        this.ridgetToStatuslineSubscriber.removeRidget(this.getRidget(id));
        return this.ridgets.remove(id) != null;
    }

    public void setStatuslineToShowMarkerMessages(IStatuslineRidget statuslineToShowMarkerMessages) {
        this.ridgetToStatuslineSubscriber.setStatuslineToShowMarkerMessages(statuslineToShowMarkerMessages, this.getRidgets());
    }

    public <R extends IRidget> R getRidget(String id) {
        IRidgetContainer parent;
        IRidget result = this.ridgets.get(id);
        if (result == null && id.indexOf(46) != -1 && (parent = this.getContainer(id)) != null) {
            String childId = this.getChildId(id);
            result = parent.getRidget(childId);
        }
        return (R)result;
    }

    public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
        Object ridget = this.getRidget(id);
        if (ridget != null) {
            return ridget;
        }
        if (!SubModuleUtils.isPrepareView() || RienaStatus.isTest()) {
            try {
                if (ridgetClazz.isInterface() || Modifier.isAbstract(ridgetClazz.getModifiers())) {
                    Class mappedRidgetClazz = ClassRidgetMapper.getInstance().getRidgetClass(ridgetClazz);
                    if (mappedRidgetClazz != null) {
                        ridget = (IRidget)mappedRidgetClazz.newInstance();
                    }
                    Assert.isNotNull(ridget, (String)("Could not find a corresponding implementation for " + ridgetClazz.getName() + " in " + ClassRidgetMapper.class.getName()));
                } else {
                    ridget = (IRidget)ridgetClazz.newInstance();
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            String childId = this.getChildId(id);
            if (childId.equals(id)) {
                this.addRidget(id, (IRidget)ridget);
            } else {
                IRidgetContainer container = this.getContainer(id);
                if (container != null) {
                    container.addRidget(childId, ridget);
                } else {
                    this.addRidget(id, (IRidget)ridget);
                }
            }
        }
        return ridget;
    }

    private String getChildId(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return id;
        }
        if (id.indexOf(46) != -1) {
            return id.substring(id.lastIndexOf(46) + 1);
        }
        return id;
    }

    private IRidgetContainer getContainer(String id) {
        String parentId;
        IRidget parent;
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        if (id.indexOf(46) != -1 && (parent = this.ridgets.get(parentId = id.substring(0, id.lastIndexOf(46)))) instanceof IRidgetContainer) {
            return (IRidgetContainer)parent;
        }
        return null;
    }

    public Collection<? extends IRidget> getRidgets() {
        return this.ridgets.values();
    }

    private void addRidgetMarkers(IRidget ridget, List<IMarker> combinedMarkers) {
        if (ridget instanceof IBasicMarkableRidget && ((IBasicMarkableRidget)ridget).isVisible() && ((IBasicMarkableRidget)ridget).isEnabled()) {
            this.addRidgetMarkers((IBasicMarkableRidget)ridget, combinedMarkers);
        } else if (ridget instanceof IRidgetContainer) {
            this.addRidgetMarkers((IRidgetContainer)ridget, combinedMarkers);
        }
    }

    private void addRidgetMarkers(IBasicMarkableRidget ridget, List<IMarker> combinedMarkers) {
        combinedMarkers.addAll(this.getNotHiddenMarkers(ridget));
    }

    private List<? extends IMarker> getNotHiddenMarkers(IBasicMarkableRidget ridget) {
        Collection markers = ridget.getMarkers();
        ArrayList notHiddenMarkers = new ArrayList(markers);
        Set hiddenTypes = ridget.getHiddenMarkerTypes();
        for (Class hiddenType : hiddenTypes) {
            for (IMarker marker : markers) {
                if (!hiddenType.isAssignableFrom(marker.getClass())) continue;
                notHiddenMarkers.remove(marker);
            }
        }
        return notHiddenMarkers;
    }

    private void addRidgetMarkers(IRidgetContainer ridgetContainer, List<IMarker> combinedMarkers) {
        for (IRidget ridget : ridgetContainer.getRidgets()) {
            this.addRidgetMarkers(ridget, combinedMarkers);
        }
    }

    protected void updateNavigationNodeMarkers() {
        Collection mandatoryInNode;
        ArrayList<ErrorMarker> errorInRidgets = new ArrayList<ErrorMarker>();
        ArrayList<MandatoryMarker> mandatoryInRidgets = new ArrayList<MandatoryMarker>();
        for (IMarker marker : this.getRidgetMarkers()) {
            MandatoryMarker mandatoryMarker;
            if (marker instanceof ErrorMarker) {
                errorInRidgets.add((ErrorMarker)marker);
                continue;
            }
            if (!(marker instanceof MandatoryMarker) || (mandatoryMarker = (MandatoryMarker)marker).isDisabled()) continue;
            mandatoryInRidgets.add(mandatoryMarker);
        }
        Collection errorInNode = this.getNavigationNode().getMarkersOfType(ErrorMarker.class);
        if (errorInNode.isEmpty() && !errorInRidgets.isEmpty()) {
            this.getNavigationNode().addMarker((IMarker)errorInRidgets.iterator().next());
        }
        if (!errorInNode.isEmpty() && errorInRidgets.isEmpty()) {
            this.getNavigationNode().removeMarker((IMarker)errorInNode.iterator().next());
        }
        if ((mandatoryInNode = this.getNavigationNode().getMarkersOfType(MandatoryMarker.class)).isEmpty() && !mandatoryInRidgets.isEmpty()) {
            this.getNavigationNode().addMarker((IMarker)mandatoryInRidgets.iterator().next());
        }
        if (!mandatoryInNode.isEmpty() && mandatoryInRidgets.isEmpty()) {
            this.getNavigationNode().removeMarker((IMarker)mandatoryInNode.iterator().next());
        }
        ArrayList<MandatoryMarker> enabledMandatoryInNode = new ArrayList<MandatoryMarker>();
        ArrayList<MandatoryMarker> disabledMandatoryInNode = new ArrayList<MandatoryMarker>();
        for (MandatoryMarker m : new ArrayList(mandatoryInNode)) {
            if (m.isDisabled()) {
                disabledMandatoryInNode.add(m);
                continue;
            }
            enabledMandatoryInNode.add(m);
        }
        if (enabledMandatoryInNode.isEmpty() && !disabledMandatoryInNode.isEmpty() && !mandatoryInRidgets.isEmpty()) {
            this.getNavigationNode().removeMarker((IMarker)disabledMandatoryInNode.iterator().next());
            this.getNavigationNode().addMarker((IMarker)mandatoryInRidgets.iterator().next());
        }
    }

    private List<IMarker> getRidgetMarkers() {
        ArrayList<IMarker> combinedMarkers = new ArrayList<IMarker>();
        this.addRidgetMarkers((IRidgetContainer)this, combinedMarkers);
        return combinedMarkers;
    }

    protected void updateIcon(IWindowRidget windowRidget) {
        if (windowRidget == null) {
            return;
        }
        String nodeIcon = this.getNavigationNode().getIcon();
        windowRidget.setIcon(nodeIcon);
    }

    public void setBlocked(boolean blocked) {
        if (this.getNavigationNode() != null) {
            this.getNavigationNode().setBlocked(blocked);
        }
    }

    public boolean isBlocked() {
        return this.getNavigationNode() != null && this.getNavigationNode().isBlocked();
    }

    public NavigationNodeController<?> getParentController() {
        if (this.getNavigationNode() != null && this.getNavigationNode().getParent() == null) {
            return null;
        }
        return (NavigationNodeController)this.navigationNode.getParent().getNavigationNodeController();
    }

    public void setContext(String key, Object value) {
        Assert.isNotNull(this.getNavigationNode(), (String)"NavigationNode may not be null");
        this.getNavigationNode().setContext(key, value);
    }

    public Object getContext(String key) {
        Assert.isNotNull(this.getNavigationNode(), (String)"NavigationNode may not be null");
        return this.getNavigationNode().getContext(key);
    }

    public void navigationArgumentChanged(NavigationArgument argument) {
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NavigationNodeController.this.updateNavigationNodeMarkers();
        }
    }
}

