/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.internal.ui.ridgets.swt.optional.CompositeTableRidget;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IRowRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.ridgets.swt.optional.ICompositeTableRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.nebula.widgets.compositetable.AbstractNativeHeader;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.nebula.widgets.compositetable.ResizableGridRowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SnippetCompositeTableRidget002 {
    static {
        SwtControlRidgetMapper.getInstance().addMapping(CompositeTable.class, CompositeTableRidget.class);
    }

    private SnippetCompositeTableRidget002() {
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        CompositeTable table = new CompositeTable((Composite)shell, 0);
        new Header((Composite)table, 0);
        new Row((Composite)table, 0);
        table.setRunTime(true);
        ICompositeTableRidget ridget = (ICompositeTableRidget)SwtRidgetFactory.createRidget((Object)table);
        WritableList input = new WritableList(PersonFactory.createPersonList(), Person.class);
        ridget.bindToModel((IObservableList)input, Person.class, RowRidget.class);
        ridget.updateFromModel();
        ridget.setComparator(0, (Comparator)new FirstNameComparator());
        ridget.setComparator(1, (Comparator)new LastNameComparator());
        ridget.setSortedColumn(0);
        ridget.setSortedAscending(true);
        shell.setSize(400, 160);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static final class FirstNameComparator
    implements Comparator<Object> {
        private FirstNameComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Person p1 = (Person)o1;
            Person p2 = (Person)o2;
            return p1.getFirstname().compareTo(p2.getFirstname());
        }
    }

    private static final class Header
    extends AbstractNativeHeader {
        public Header(Composite parent, int style) {
            super(parent, style);
            this.setWeights(new int[]{100, 100});
            this.setColumnText(new String[]{"First Name", "Last Name"});
        }
    }

    private static final class LastNameComparator
    implements Comparator<Object> {
        private LastNameComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Person p1 = (Person)o1;
            Person p2 = (Person)o2;
            return p1.getLastname().compareTo(p2.getLastname());
        }
    }

    private static final class Row
    extends Composite
    implements IComplexComponent {
        private final List<Object> controls = new ArrayList<Object>();

        public Row(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new ResizableGridRowLayout());
            Text txtFirst = new Text((Composite)this, 2048);
            this.addUIControl(txtFirst, "first");
            Text txtLast = new Text((Composite)this, 2048);
            this.addUIControl(txtLast, "last");
        }

        public List<Object> getUIControls() {
            return Collections.unmodifiableList(this.controls);
        }

        private void addUIControl(Object uiControl, String bindingId) {
            this.controls.add(uiControl);
            SWTBindingPropertyLocator.getInstance().setBindingProperty(uiControl, bindingId);
        }
    }

    public static final class RowRidget
    extends AbstractCompositeRidget
    implements IRowRidget {
        private Person rowData;

        public void setData(Object rowData) {
            this.rowData = (Person)rowData;
        }

        public void configureRidgets() {
            ITextRidget txtFirst = (ITextRidget)this.getRidget("first");
            txtFirst.bindToModel((Object)this.rowData, "firstname");
            txtFirst.updateFromModel();
            ITextRidget txtLast = (ITextRidget)this.getRidget("last");
            txtLast.bindToModel((Object)this.rowData, "lastname");
            txtLast.updateFromModel();
        }
    }
}

