/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.ui.filter;

import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.IModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;

public class NodeStructureObserver {
    private final ISimpleNavigationNodeListener simpleListener;
    private NavigationTreeObserver treeObserver;
    private final IApplicationNode applicationNode;

    public NodeStructureObserver(IApplicationNode applicationNode, ISimpleNavigationNodeListener simpleListener) {
        this.applicationNode = applicationNode;
        this.simpleListener = simpleListener;
    }

    public void start() {
        this.treeObserver = new NavigationTreeObserver();
        this.treeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        this.treeObserver.addListener((IModuleNodeListener)new ModuleListener());
        this.treeObserver.addListener((IModuleGroupNodeListener)new ModuleGroupListener());
        this.treeObserver.addListener((ISubApplicationNodeListener)new SubApplicationListener());
        this.treeObserver.addListenerTo(this.applicationNode);
    }

    public void stop() {
        this.treeObserver.removeListenerFrom(this.applicationNode);
    }

    private void notifyAdded(INavigationNode<?> source, INavigationNode<?> node) {
        this.simpleListener.childAdded(source, node);
    }

    private void notifyRemoved(INavigationNode<?> source, INavigationNode<?> node) {
        this.simpleListener.childRemoved(source, node);
    }

    private class ModuleGroupListener
    extends ModuleGroupNodeListener {
        private ModuleGroupListener() {
        }

        public void childAdded(IModuleGroupNode source, IModuleNode childAdded) {
            NodeStructureObserver.this.notifyAdded((INavigationNode)source, (INavigationNode)childAdded);
        }

        public void childRemoved(IModuleGroupNode source, IModuleNode childRemoved) {
            NodeStructureObserver.this.notifyRemoved((INavigationNode)source, (INavigationNode)childRemoved);
        }
    }

    private class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void childAdded(IModuleNode source, ISubModuleNode childAdded) {
            NodeStructureObserver.this.notifyAdded((INavigationNode)source, (INavigationNode)childAdded);
        }

        public void childRemoved(IModuleNode source, ISubModuleNode childRemoved) {
            NodeStructureObserver.this.notifyRemoved((INavigationNode)source, (INavigationNode)childRemoved);
        }
    }

    private class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void childAdded(ISubApplicationNode source, IModuleGroupNode childAdded) {
            NodeStructureObserver.this.notifyAdded((INavigationNode)source, (INavigationNode)childAdded);
        }

        public void childRemoved(ISubApplicationNode source, IModuleGroupNode childRemoved) {
            NodeStructureObserver.this.notifyRemoved((INavigationNode)source, (INavigationNode)childRemoved);
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void childAdded(ISubModuleNode source, ISubModuleNode childAdded) {
            NodeStructureObserver.this.notifyAdded((INavigationNode)source, (INavigationNode)childAdded);
        }

        public void childRemoved(ISubModuleNode source, ISubModuleNode childRemoved) {
            NodeStructureObserver.this.notifyRemoved((INavigationNode)source, (INavigationNode)childRemoved);
        }
    }
}

