/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.client.controller.test;

import java.util.List;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.client.controller.test.ComboSubModuleController;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.controllers.AbstractSubModuleControllerTest;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

@NonUITestCase
public class ComboSubModuleControllerTest
extends AbstractSubModuleControllerTest<ComboSubModuleController> {
    protected ComboSubModuleController createController(ISubModuleNode node) {
        return new ComboSubModuleController(node);
    }

    public void testComboSelection() {
        this.basicTestComboSelection(0);
        this.basicTestComboSelection(4);
    }

    public void testNoSelection() {
        IComboRidget combo = (IComboRidget)((ComboSubModuleController)this.getController()).getRidget(IComboRidget.class, "comboOne");
        combo.setSelection(null);
        ComboSubModuleControllerTest.assertEquals((int)-1, (int)combo.getSelectionIndex());
        ComboSubModuleControllerTest.assertEquals(null, (Object)combo.getSelection());
    }

    public void testSaveName() {
        ITextRidget textFirst = (ITextRidget)((ComboSubModuleController)this.getController()).getRidget(ITextRidget.class, "textFirst");
        ITextRidget textLast = (ITextRidget)((ComboSubModuleController)this.getController()).getRidget(ITextRidget.class, "textLast");
        IComboRidget combo = (IComboRidget)((ComboSubModuleController)this.getController()).getRidget(IComboRidget.class, "comboOne");
        IActionRidget saveButton = (IActionRidget)((ComboSubModuleController)this.getController()).getRidget(IActionRidget.class, "buttonSave");
        Person newPerson = (Person)combo.getSelection();
        textFirst.setText("Jane");
        textLast.setText("Fonda");
        saveButton.fireAction();
        ComboSubModuleControllerTest.assertEquals((Object)newPerson, (Object)combo.getSelection());
    }

    private void basicTestComboSelection(int index) {
        ITextRidget textFirst = (ITextRidget)((ComboSubModuleController)this.getController()).getRidget(ITextRidget.class, "textFirst");
        ITextRidget textLast = (ITextRidget)((ComboSubModuleController)this.getController()).getRidget(ITextRidget.class, "textLast");
        IComboRidget combo = (IComboRidget)((ComboSubModuleController)this.getController()).getRidget(IComboRidget.class, "comboOne");
        List expected = PersonFactory.createPersonList();
        combo.setSelection(index);
        ComboSubModuleControllerTest.assertEquals((String)((Person)combo.getSelection()).getFirstname(), (String)((Person)expected.get(index)).getFirstname());
        ComboSubModuleControllerTest.assertEquals((String)((Person)combo.getSelection()).getLastname(), (String)((Person)expected.get(index)).getLastname());
        ComboSubModuleControllerTest.assertEquals((String)textFirst.getText(), (String)((Person)expected.get(index)).getFirstname());
        ComboSubModuleControllerTest.assertEquals((String)textLast.getText(), (String)((Person)expected.get(index)).getLastname());
    }
}

