/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.hooks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.communication.core.hooks.CallContext;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.internal.communication.core.factory.ICallHookExtension;
import org.eclipse.riena.internal.communication.core.factory.OrderedCallHooksExecuter;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class OrderedCallHooksExecutorTest
extends RienaTestCase {
    public void testUpdate() {
        ArrayList<DummyCallHook> before = new ArrayList<DummyCallHook>();
        ArrayList<DummyCallHook> after = new ArrayList<DummyCallHook>();
        DummyCallHook ch1 = new DummyCallHook(before, after);
        ExtensionBean b1 = new ExtensionBean("a", "", "b", ch1);
        DummyCallHook ch2 = new DummyCallHook(before, after);
        ExtensionBean b2 = new ExtensionBean("b", "", "", ch2);
        OrderedCallHooksExecuter exec = new OrderedCallHooksExecuter();
        exec.update(new ICallHookExtension[]{b1, b2});
        exec.beforeCall(null);
        OrderedCallHooksExecutorTest.assertEquals((Object)ch1, before.get(0));
        OrderedCallHooksExecutorTest.assertEquals((Object)ch2, before.get(1));
        exec.afterCall(null);
        OrderedCallHooksExecutorTest.assertEquals((Object)ch1, after.get(1));
        OrderedCallHooksExecutorTest.assertEquals((Object)ch2, after.get(0));
        before = new ArrayList();
        after = new ArrayList();
        ch1 = new DummyCallHook(before, after);
        ch2 = new DummyCallHook(before, after);
        b1 = new ExtensionBean("a", "b", "", ch1);
        b2 = new ExtensionBean("b", "", "", ch2);
        exec.update(new ICallHookExtension[]{b1, b2});
        exec.beforeCall(null);
        OrderedCallHooksExecutorTest.assertEquals((Object)ch1, before.get(1));
        OrderedCallHooksExecutorTest.assertEquals((Object)ch2, before.get(0));
        exec.afterCall(null);
        OrderedCallHooksExecutorTest.assertEquals((Object)ch1, after.get(0));
        OrderedCallHooksExecutorTest.assertEquals((Object)ch2, after.get(1));
        before = new ArrayList();
        after = new ArrayList();
        ch1 = new DummyCallHook(before, after);
        ch2 = new DummyCallHook(before, after);
        b1 = new ExtensionBean("a", "", "", ch1);
        b2 = new ExtensionBean("b", "", "a", ch2);
        exec.update(new ICallHookExtension[]{b1, b2});
        exec.beforeCall(null);
        OrderedCallHooksExecutorTest.assertEquals((Object)ch1, before.get(1));
        OrderedCallHooksExecutorTest.assertEquals((Object)ch2, before.get(0));
        exec.afterCall(null);
        OrderedCallHooksExecutorTest.assertEquals((Object)ch1, after.get(0));
        OrderedCallHooksExecutorTest.assertEquals((Object)ch2, after.get(1));
    }

    private static final class DummyCallHook
    implements ICallHook {
        private final List<DummyCallHook> before;
        private final List<DummyCallHook> after;

        public DummyCallHook(List<DummyCallHook> before, List<DummyCallHook> after) {
            this.before = before;
            this.after = after;
        }

        public void beforeCall(CallContext context) {
            this.before.add(this);
        }

        public void afterCall(CallContext context) {
            this.after.add(this);
        }
    }

    private static final class ExtensionBean
    implements ICallHookExtension {
        private final String name;
        private final String preHooks;
        private final String postHooks;
        private final ICallHook callHook;

        public ExtensionBean(String name, String preHooks, String postHooks, ICallHook callHook) {
            this.name = name;
            this.preHooks = preHooks;
            this.postHooks = postHooks;
            this.callHook = callHook;
        }

        public String getName() {
            return this.name;
        }

        public String getPreHooks() {
            return this.preHooks;
        }

        public String getPostHooks() {
            return this.postHooks;
        }

        public ICallHook getCallHook() {
            return this.callHook;
        }
    }
}

