/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.annotationprocessor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.annotationprocessor.AnnotatedOverriddenMethodsGuard;
import org.eclipse.riena.core.annotationprocessor.AnnotationProcessor;
import org.eclipse.riena.core.annotationprocessor.AnnotationProcessorFailure;
import org.eclipse.riena.core.annotationprocessor.DisposerList;
import org.eclipse.riena.core.annotationprocessor.IAnnotatedMethodHandler;
import org.eclipse.riena.core.annotationprocessor.IDisposer;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.annotationprocessor.IAnnotatedMethodHandlerExtension;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.annotation.OnActionCallback;
import org.eclipse.riena.ui.ridgets.annotation.OnClick;

@NonUITestCase
public class AnnotationProcessorTest
extends RienaTestCase {
    private AnnotationProcessor processor;

    protected void setUp() throws Exception {
        super.setUp();
        this.processor = (AnnotationProcessor)ReflectionUtils.newInstanceHidden(AnnotationProcessor.class, (Object[])new Object[0]);
    }

    public void testFailWithDoubledHandlers() {
        this.processor.update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, new Handler()), this.create(OnClick.class, new Handler())});
        try {
            this.processor.processMethods((Object)new String());
            AnnotationProcessorTest.fail();
        }
        catch (AnnotationProcessorFailure annotationProcessorFailure) {
            this.ok();
        }
    }

    public void testAlreadyProcessed() {
        this.processor.update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, new Handler())});
        String watch = new String();
        IDisposer disposer1 = this.processor.processMethods((Object)watch);
        IDisposer disposer2 = this.processor.processMethods((Object)watch);
        AnnotationProcessorTest.assertTrue((disposer1 != disposer2 ? 1 : 0) != 0);
        AnnotationProcessorTest.assertTrue((disposer2 == ReflectionUtils.getHidden((Object)this.processor, (String)"EMPTY_DISPOSER") ? 1 : 0) != 0);
        IDisposer disposer3 = this.processor.processMethods((Object)watch);
        AnnotationProcessorTest.assertTrue((disposer2 == disposer3 ? 1 : 0) != 0);
    }

    public void testFlatAnnotatedObject() {
        Handler onClick = new Handler(OnClick.class);
        Handler onActionCallback = new Handler(OnActionCallback.class);
        this.processor.update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, onClick), this.create(OnActionCallback.class, onActionCallback)});
        this.processor.processMethods((Object)new A(null, null));
        AnnotationProcessorTest.assertTrue((onClick.getHandled().size() == 1 ? 1 : 0) != 0);
        AnnotationProcessorTest.assertTrue((onActionCallback.getHandled().size() == 1 ? 1 : 0) != 0);
        AnnotationProcessorTest.assertTrue((boolean)(onClick.getHandled().get(0) instanceof OnClick));
        AnnotationProcessorTest.assertTrue((boolean)(onActionCallback.getHandled().get(0) instanceof OnActionCallback));
        AnnotationProcessorTest.assertEquals((String)"RidgetA1", (String)((OnClick)onClick.getHandled().get(0)).ridgetId());
        AnnotationProcessorTest.assertEquals((String)"RidgetA2", (String)((OnActionCallback)onActionCallback.getHandled().get(0)).ridgetId());
    }

    public void testHillyAnnotatedObject() {
        Handler onClick = new Handler(OnClick.class);
        Handler onActionCallback = new Handler(OnActionCallback.class);
        this.processor.update(new IAnnotatedMethodHandlerExtension[]{this.create(OnClick.class, onClick), this.create(OnActionCallback.class, onActionCallback)});
        this.processor.processMethods((Object)new B());
        AnnotationProcessorTest.assertTrue((onClick.getHandled().size() == 1 ? 1 : 0) != 0);
        AnnotationProcessorTest.assertTrue((onActionCallback.getHandled().size() == 2 ? 1 : 0) != 0);
        AnnotationProcessorTest.assertTrue((boolean)(onClick.getHandled().get(0) instanceof OnClick));
        AnnotationProcessorTest.assertTrue((boolean)(onActionCallback.getHandled().get(0) instanceof OnActionCallback));
        AnnotationProcessorTest.assertTrue((boolean)(onActionCallback.getHandled().get(1) instanceof OnActionCallback));
        AnnotationProcessorTest.assertEquals((String)"RidgetA1", (String)((OnClick)onClick.getHandled().get(0)).ridgetId());
        AnnotationProcessorTest.assertEquals((String)"RidgetA2", (String)((OnActionCallback)onActionCallback.getHandled().get(0)).ridgetId());
        AnnotationProcessorTest.assertEquals((String)"RidgetA3", (String)((OnActionCallback)onActionCallback.getHandled().get(1)).ridgetId());
    }

    private IAnnotatedMethodHandlerExtension create(final Class<? extends Annotation> annotationClass, final IAnnotatedMethodHandler handler) {
        return new IAnnotatedMethodHandlerExtension(){

            public Class<? extends Annotation> getAnnotation() {
                return annotationClass;
            }

            public IAnnotatedMethodHandler createHandler() {
                return handler;
            }
        };
    }

    private static class A {
        private A() {
        }

        @OnClick(ridgetId="RidgetA1")
        public void onClick() {
        }

        @OnActionCallback(ridgetId="RidgetA2")
        public void onAcctionCallback() {
        }

        /* synthetic */ A(A a, A a2) {
            this();
        }
    }

    private static class B
    extends A {
        private B() {
        }

        @Override
        @OnClick(ridgetId="RidgetA1")
        public void onClick() {
        }

        @Override
        @OnActionCallback(ridgetId="RidgetA3")
        public void onAcctionCallback() {
        }
    }

    private static class Handler
    implements IAnnotatedMethodHandler {
        private Class<? extends Annotation> annotationClass;
        private final List<Annotation> handled = new ArrayList<Annotation>();

        public Handler() {
        }

        public Handler(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
        }

        public void handleAnnotation(Annotation annotation, Object object, Method method, Map<?, ?> optionalArgs, AnnotatedOverriddenMethodsGuard guard, DisposerList disposers) {
            AnnotationProcessorTest.assertTrue((boolean)this.annotationClass.isInstance(annotation));
            this.handled.add(annotation);
            disposers.add((Object)new IDisposer(){

                public void dispose() {
                }
            });
        }

        public List<Annotation> getHandled() {
            return this.handled;
        }
    }
}

