/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Iterator;
import org.eclipse.riena.core.util.GenerationalListenerList;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class GenerationalListenerListTest
extends RienaTestCase {
    private final GenerationalListenerList<String> list = new GenerationalListenerList();
    private static final String[] NOTHING = new String[0];

    public void testIsEmpty() {
        GenerationalListenerListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testIsEmptyAfterAddAndRemove() {
        this.list.add((Object)"one");
        GenerationalListenerListTest.assertEquals((int)1, (int)this.list.size());
        this.list.remove((Object)"one");
        GenerationalListenerListTest.assertTrue((boolean)this.list.isEmpty());
        GenerationalListenerListTest.assertFalse((boolean)this.list.contains((Object)"one"));
        this.expect(this.list.iterator(), NOTHING);
    }

    public void testAddIterateRemoveIterateAdd() {
        this.list.add((Object)"one");
        Iterator iteratorAfterAdd = this.list.iterator();
        this.list.remove((Object)"one");
        this.list.printDebugList("t0");
        this.list.printList("t0");
        Iterator iteratorAfterRemove = this.list.iterator();
        this.list.add((Object)"one");
        this.list.printDebugList("t1");
        this.list.printList("t1");
        this.expect(iteratorAfterAdd, "one");
        this.expect(iteratorAfterRemove, NOTHING);
        this.list.printDebugList("t2");
        this.list.printList("t2");
    }

    public void testAddAddAddIterateRemoveWhileIteratingIterate() {
        this.list.add((Object)"one");
        this.list.add((Object)"two");
        this.list.add((Object)"three");
        Iterator iteratorAfterAdd = this.list.iterator();
        boolean once = true;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            String cfr_ignored_0 = (String)iterator.next();
            if (!once) continue;
            once = false;
            this.list.remove((Object)"two");
        }
        this.expect(iteratorAfterAdd, "one", "two", "three");
        Iterator iteratorAfterRemove = this.list.iterator();
        this.expect(iteratorAfterRemove, "one", "three");
    }

    public void testGCedList() {
        GenerationalListenerList gcList = new GenerationalListenerList(1, 0.0f, 1);
        gcList.add((Object)"one");
        Iterator iteratorAfterAdd = gcList.iterator();
        gcList.remove((Object)"one");
        gcList.printDebugList("t0");
        gcList.printList("t0");
        Iterator iteratorAfterRemove = gcList.iterator();
        gcList.add((Object)"one");
        gcList.printDebugList("t1");
        gcList.printList("t1");
        this.expect(iteratorAfterAdd, "one");
        this.expect(iteratorAfterRemove, NOTHING);
        gcList.printDebugList("t2");
        gcList.printList("t2");
    }

    private void expect(Iterator<String> iterator, String ... expectations) {
        int i = 0;
        for (String s : Iter.able(iterator)) {
            GenerationalListenerListTest.assertEquals((String)expectations[i], (String)s);
            ++i;
        }
        GenerationalListenerListTest.assertEquals((int)expectations.length, (int)i);
    }
}

