/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.beans.common.StringPojo;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableListRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.FTActionListener;
import org.eclipse.riena.internal.ui.ridgets.swt.FTClickListener;
import org.eclipse.riena.internal.ui.ridgets.swt.TestSelectionListener;
import org.eclipse.riena.internal.ui.ridgets.swt.optional.GridRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.internal.ui.swt.utils.TestUtils;
import org.eclipse.riena.ui.core.marker.RowErrorMessageMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;
import org.eclipse.riena.ui.ridgets.listener.IClickListener;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class GridRidgetTest
extends AbstractTableListRidgetTest {
    protected Grid createWidget(Composite parent) {
        Grid grid = new Grid(parent, 2050);
        grid.setHeaderVisible(true);
        new GridColumn(grid, 0);
        new GridColumn(grid, 0);
        return grid;
    }

    protected ITableRidget createRidget() {
        return new GridRidget();
    }

    protected Grid getWidget() {
        return (Grid)super.getWidget();
    }

    protected GridRidget getRidget() {
        return (GridRidget)super.getRidget();
    }

    @Override
    protected void bindRidgetToModel() {
        this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, new String[]{"firstname", "lastname"}, new String[]{"First Name", "Last Name"});
    }

    @Override
    protected void clearUIControlRowSelection() {
        this.getWidget().deselectAll();
        this.fireSelectionEvent();
    }

    @Override
    protected int getUIControlSelectedRowCount() {
        return this.getWidget().getSelectionCount();
    }

    @Override
    protected int getUIControlSelectedRow() {
        return this.getWidget().getSelectionIndex();
    }

    @Override
    protected Object getRowValue(int i) {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        return rowObservables.get(i);
    }

    @Override
    protected int[] getSelectedRows() {
        IObservableList rowObservables = (IObservableList)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        Object[] elements = this.getRidget().getMultiSelectionObservable().toArray();
        int[] result = new int[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            result[i] = rowObservables.indexOf(element);
            ++i;
        }
        return result;
    }

    @Override
    protected int[] getUIControlSelectedRows() {
        return this.getWidget().getSelectionIndices();
    }

    @Override
    protected void setUIControlRowSelection(int[] indices) {
        this.getWidget().setSelection(indices);
        this.fireSelectionEvent();
    }

    @Override
    protected void setUIControlRowSelectionInterval(int start, int end) {
        this.getWidget().setSelection(start, end);
        this.fireSelectionEvent();
    }

    @Override
    protected boolean supportsMulti() {
        return true;
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        GridRidgetTest.assertSame(GridRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testBindToModel() {
        Grid control = this.getWidget();
        GridRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)control.getItemCount());
        GridRidgetTest.assertEquals((String)this.person1.getFirstname(), (String)control.getItem(0).getText(0));
        GridRidgetTest.assertEquals((String)this.person2.getFirstname(), (String)control.getItem(1).getText(0));
        GridRidgetTest.assertEquals((String)this.person3.getFirstname(), (String)control.getItem(2).getText(0));
        GridRidgetTest.assertEquals((String)this.person1.getLastname(), (String)control.getItem(0).getText(1));
        GridRidgetTest.assertEquals((String)this.person2.getLastname(), (String)control.getItem(1).getText(1));
        GridRidgetTest.assertEquals((String)this.person3.getLastname(), (String)control.getItem(2).getText(1));
    }

    public void testTableColumnsNumAndHeader() {
        Grid control = this.getWidget();
        GridColumn[] columns = control.getColumns();
        GridRidgetTest.assertEquals((int)2, (int)columns.length);
        GridRidgetTest.assertEquals((String)"First Name", (String)columns[0].getText());
        GridRidgetTest.assertEquals((String)"Last Name", (String)columns[1].getText());
        GridRidgetTest.assertTrue((boolean)control.getHeaderVisible());
    }

    public void testTableColumnsNumAndHeaderWithMismatch() {
        String[] properties1 = new String[]{"firstname", "lastname"};
        String[] headers1 = new String[]{"First Name"};
        try {
            this.getRidget().bindToModel((Object)this.manager, "persons", Person.class, properties1, headers1);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testTableColumnsWithNullHeader() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        control.setHeaderVisible(true);
        control.getColumn(0).setText("foo");
        control.getColumn(1).setText("bar");
        String[] properties1 = new String[]{"firstname", "lastname"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, properties1, null);
        GridRidgetTest.assertFalse((boolean)control.getHeaderVisible());
    }

    public void testTableColumnsWithNullHeaderEntry() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        control.getColumn(0).setText("foo");
        control.getColumn(1).setText("bar");
        String[] properties1 = new String[]{"firstname", "lastname"};
        String[] stringArray = new String[2];
        stringArray[0] = "First Name";
        String[] headers = stringArray;
        ridget.bindToModel((Object)this.manager, "persons", Person.class, properties1, headers);
        GridRidgetTest.assertEquals((String)"First Name", (String)control.getColumn(0).getText());
        GridRidgetTest.assertEquals((String)"", (String)control.getColumn(1).getText());
    }

    public void testUpdateFromModel() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        final ArrayList changeEvents = new ArrayList();
        IChangeListener listener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                changeEvents.add(event);
            }
        };
        ridget.getObservableList().addChangeListener(listener);
        int oldCount = this.manager.getPersons().size();
        GridRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        GridRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        this.manager.getPersons().remove(this.person1);
        int newCount = oldCount - 1;
        GridRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        GridRidgetTest.assertEquals((int)oldCount, (int)ridget.getObservableList().size());
        GridRidgetTest.assertEquals((int)oldCount, (int)control.getItemCount());
        GridRidgetTest.assertEquals((int)0, (int)changeEvents.size());
        ridget.updateFromModel();
        GridRidgetTest.assertEquals((int)newCount, (int)this.manager.getPersons().size());
        GridRidgetTest.assertEquals((int)newCount, (int)ridget.getObservableList().size());
        GridRidgetTest.assertEquals((int)newCount, (int)control.getItemCount());
        GridRidgetTest.assertEquals((int)0, (int)changeEvents.size());
    }

    public void testUpdateFromModelPreservesSelection() {
        GridRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        GridRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person1);
        ridget.updateFromModel();
        GridRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
    }

    public void testUpdateFromModelRemovesSelection() {
        GridRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        GridRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        GridRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testContainsOption() {
        GridRidget ridget = this.getRidget();
        GridRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person1));
        GridRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person2));
        GridRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
        GridRidgetTest.assertFalse((boolean)ridget.containsOption(null));
        GridRidgetTest.assertFalse((boolean)ridget.containsOption((Object)new Person("", "")));
        List<Person> persons = Arrays.asList(this.person3);
        PersonManager manager = new PersonManager(persons);
        ridget.bindToModel((Object)manager, "persons", Person.class, new String[]{"firstname", "lastname"}, null);
        ridget.updateFromModel();
        GridRidgetTest.assertFalse((boolean)ridget.containsOption((Object)this.person1));
        GridRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
    }

    public void testSetSelectionType() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        GridRidgetTest.assertEquals((Object)ISelectableRidget.SelectionType.SINGLE, (Object)ridget.getSelectionType());
        GridRidgetTest.assertTrue(((control.getStyle() & 2) != 0 ? 1 : 0) != 0);
        int[] nArray = new int[2];
        nArray[1] = 1;
        ridget.setSelection(nArray);
        GridRidgetTest.assertEquals((int)1, (int)ridget.getSelectionIndices().length);
        GridRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        ridget.setSelection(nArray2);
        GridRidgetTest.assertEquals((int)2, (int)ridget.getSelectionIndices().length);
        GridRidgetTest.assertEquals((int)2, (int)control.getSelectionCount());
    }

    @Override
    public void testAddClickListener() {
        GridRidget ridget = this.getRidget();
        ridget.updateFromModel();
        Grid control = this.getWidget();
        RowData rowData = new RowData();
        rowData.width = 300;
        rowData.height = 300;
        control.setLayoutData((Object)rowData);
        control.getColumn(0).setWidth(100);
        control.getColumn(1).setWidth(100);
        control.getShell().pack();
        control.getParent().update();
        try {
            ridget.addClickListener(null);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTClickListener listener1 = new FTClickListener();
        ridget.addClickListener((IClickListener)listener1);
        FTClickListener listener2 = new FTClickListener();
        ridget.addClickListener((IClickListener)listener2);
        ridget.addClickListener((IClickListener)listener2);
        Event mdEvent = new Event();
        mdEvent.widget = control;
        mdEvent.type = 3;
        mdEvent.button = 2;
        GridItem row2 = control.getItem(2);
        mdEvent.item = row2;
        mdEvent.x = row2.getBounds((int)0).x + 1;
        mdEvent.y = row2.getBounds((int)0).y + 1;
        control.notifyListeners(3, mdEvent);
        GridRidgetTest.assertEquals((int)0, (int)listener1.getCount());
        GridRidgetTest.assertEquals((int)0, (int)listener2.getCount());
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        GridRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        GridRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ClickEvent event = listener2.getEvent();
        GridRidgetTest.assertEquals((Object)ridget, (Object)event.getSource());
        GridRidgetTest.assertEquals((int)2, (int)event.getButton());
        GridRidgetTest.assertEquals((int)0, (int)event.getColumnIndex());
        GridRidgetTest.assertEquals((Object)row2.getData(), (Object)event.getRow());
        ridget.removeClickListener((IClickListener)listener1);
        mdEvent.type = 3;
        control.notifyListeners(3, mdEvent);
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        GridRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testAddDoubleClickListener() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        try {
            ridget.addDoubleClickListener(null);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTActionListener listener1 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener1);
        FTActionListener listener2 = new FTActionListener();
        ridget.addDoubleClickListener((IActionListener)listener2);
        ridget.addDoubleClickListener((IActionListener)listener2);
        Event doubleClick = new Event();
        doubleClick.widget = control;
        doubleClick.type = 8;
        control.notifyListeners(8, doubleClick);
        GridRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        GridRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ridget.removeDoubleClickListener((IActionListener)listener1);
        control.notifyListeners(8, doubleClick);
        GridRidgetTest.assertEquals((int)1, (int)listener1.getCount());
    }

    public void testSetComparator() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        TypedComparator comparator = new TypedComparator();
        try {
            ridget.setComparator(-1, (Comparator)comparator);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setComparator(2, (Comparator)comparator);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ridget.setSortedAscending(true);
        int lastItemIndex = control.getItemCount() - 1;
        GridRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        GridRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, (Comparator)comparator);
        GridRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        GridRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedColumn(0);
        GridRidgetTest.assertEquals((String)"Frank", (String)control.getItem(0).getText(0));
        GridRidgetTest.assertEquals((String)"John", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, null);
        GridRidgetTest.assertEquals((String)"John", (String)control.getItem(0).getText(0));
        GridRidgetTest.assertEquals((String)"Frank", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(1, (Comparator)comparator);
        ridget.setSortedColumn(1);
        GridRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(1));
        GridRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(1));
        ridget.setSortedAscending(false);
        GridRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0).getText(1));
        GridRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex).getText(1));
    }

    public void testGetSortedColumn() {
        GridRidget ridget = this.getRidget();
        try {
            ridget.setSortedColumn(2);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        ridget.setComparator(0, null);
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(1, (Comparator)new TypedComparator());
        ridget.setSortedColumn(1);
        GridRidgetTest.assertEquals((int)1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(-1);
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
    }

    public void testIsColumnSortable() {
        GridRidget ridget = this.getRidget();
        try {
            GridRidgetTest.assertFalse((boolean)ridget.isColumnSortable(-1));
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            GridRidgetTest.assertFalse((boolean)ridget.isColumnSortable(2));
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        int i = 0;
        while (i < 2) {
            GridRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, (Comparator)new TypedComparator());
            GridRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, false);
            GridRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, true);
            GridRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, null);
            GridRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ++i;
        }
    }

    public void testSetSortedAscending() {
        Grid control = this.getWidget();
        GridRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"lastname", "firstname"}, null);
        ridget.updateFromModel();
        int lastItemIndex = control.getItemCount() - 1;
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        GridRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setSortedColumn(0);
        GridRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        GridRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(0));
        GridRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedAscending(false);
        GridRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        GridRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(0).getText(0));
        GridRidgetTest.assertEquals((String)"Doe", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setSortedAscending(true);
        GridRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        GridRidgetTest.assertEquals((String)"Doe", (String)control.getItem(0).getText(0));
        GridRidgetTest.assertEquals((String)"Zappa", (String)control.getItem(lastItemIndex).getText(0));
        ridget.setComparator(0, null);
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        GridRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
    }

    public void testSetSortedAscendingFiresEvents() {
        GridRidget ridget = this.getRidget();
        ridget.setSortedAscending(true);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.TRUE, Boolean.FALSE));
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.FALSE, Boolean.TRUE));
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
    }

    public void testSetSortedColumnFiresEvents() {
        GridRidget ridget = this.getRidget();
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", -1, 0));
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", 0, 1));
        ridget.setSortedColumn(1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetColumnSortabilityFiresEvents() {
        GridRidget ridget = this.getRidget();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
    }

    public void testColumnHeaderChangesSortability() {
        GridRidget ridget = this.getRidget();
        Grid table = this.getWidget();
        ridget.setColumnSortable(0, true);
        ridget.setComparator(0, (Comparator)new TypedComparator());
        ridget.setColumnSortable(1, true);
        ridget.setComparator(1, (Comparator)new TypedComparator());
        ridget.setSortedColumn(-1);
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        GridRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        Event e = new Event();
        e.type = 13;
        e.widget = table.getColumn(0);
        e.widget.notifyListeners(13, e);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        GridRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        GridRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        GridRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        GridRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
    }

    public void testSetMoveableColumns() {
        GridRidget ridget = this.getRidget();
        Grid table = this.getWidget();
        GridRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        GridRidgetTest.assertFalse((boolean)table.getColumn(0).getMoveable());
        GridRidgetTest.assertFalse((boolean)table.getColumn(1).getMoveable());
        ridget.setMoveableColumns(true);
        GridRidgetTest.assertTrue((boolean)ridget.hasMoveableColumns());
        GridRidgetTest.assertTrue((boolean)table.getColumn(0).getMoveable());
        GridRidgetTest.assertTrue((boolean)table.getColumn(1).getMoveable());
        ridget.setMoveableColumns(false);
        GridRidgetTest.assertFalse((boolean)ridget.hasMoveableColumns());
        GridRidgetTest.assertFalse((boolean)table.getColumn(0).getMoveable());
        GridRidgetTest.assertFalse((boolean)table.getColumn(1).getMoveable());
    }

    public void testOutputSingleSelectionCannotBeChangedFromUI() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        GridRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testOutputMultipleSelectionCannotBeChangedFromUI() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(true);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        ridget.setOutputOnly(false);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000001);
        GridRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
    }

    public void testTogglingOutputDoesNotChangeSelection() {
        GridRidget ridget = this.getRidget();
        ridget.setSelection(0);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(true);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        ridget.setSelection(null);
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        ridget.setOutputOnly(false);
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
    }

    public void testSetColumnFormatter() {
        GridRidget ridget = this.getRidget();
        Grid table = this.getWidget();
        ColumnFormatter formatter = new ColumnFormatter(){

            public String getText(Object element) {
                Person person = (Person)element;
                return person.getLastname().toUpperCase();
            }
        };
        String lastName = this.person1.getLastname();
        String lastNameUpperCase = lastName.toUpperCase();
        try {
            ridget.setColumnFormatter(-1, (IColumnFormatter)formatter);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setColumnFormatter(99, (IColumnFormatter)formatter);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ridget.setColumnFormatter(1, (IColumnFormatter)formatter);
        GridRidgetTest.assertEquals((String)lastName, (String)table.getItem(0).getText(1));
        ridget.updateFromModel();
        GridRidgetTest.assertEquals((String)lastNameUpperCase, (String)table.getItem(0).getText(1));
        ridget.setColumnFormatter(1, null);
        GridRidgetTest.assertEquals((String)lastNameUpperCase, (String)table.getItem(0).getText(1));
        ridget.updateFromModel();
        GridRidgetTest.assertEquals((String)lastName, (String)table.getItem(0).getText(1));
    }

    public void testAddSelectionListener() {
        GridRidget ridget = this.getRidget();
        Grid control = this.getWidget();
        try {
            ridget.addSelectionListener(null);
            GridRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.person1);
        GridRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection((Object)this.person2);
        GridRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.clearSelection();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)0, (int)control.getSelectionCount());
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        GridRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        GridRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
        SelectionEvent selectionEvent = selectionListener.getSelectionEvent();
        GridRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        GridRidgetTest.assertTrue((boolean)selectionEvent.getOldSelection().isEmpty());
        GridRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent.getNewSelection());
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        GridRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        GridRidgetTest.assertEquals((int)1, (int)control.getSelectionCount());
        GridRidgetTest.assertEquals((int)3, (int)selectionListener.getCount());
        SelectionEvent selectionEvent2 = selectionListener.getSelectionEvent();
        GridRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        GridRidgetTest.assertEquals((Object)selectionEvent.getNewSelection(), (Object)selectionEvent2.getOldSelection());
        GridRidgetTest.assertEquals((Object)ridget.getSelection(), (Object)selectionEvent2.getNewSelection());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
    }

    public void testAutoCreateTableColumns() {
        ITableRidget ridget = this.createRidget();
        Grid control = new Grid((Composite)this.getShell(), 65540);
        ridget.setUIControl((Object)control);
        GridRidgetTest.assertEquals((int)0, (int)control.getColumnCount());
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        GridRidgetTest.assertEquals((int)3, (int)control.getColumnCount());
        String[] columns1 = new String[]{"firstname"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns1, null);
        GridRidgetTest.assertEquals((int)1, (int)control.getColumnCount());
    }

    public void testAutoCreateColumnsWithNoLayout() {
        ITableRidget ridget = this.createRidget();
        Grid control = new Grid((Composite)this.getShell(), 65540);
        ridget.setUIControl((Object)control);
        this.getShell().setLayout(null);
        control.setSize(300, 100);
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        GridRidgetTest.assertEquals(null, (Object)control.getParent().getLayout());
        GridRidgetTest.assertEquals(null, (Object)control.getLayout());
        TestUtils.assertColumnWidths((Control)control, 3);
    }

    public void testSetColumnWidths() {
        ITableRidget ridget = this.createRidget();
        Grid control = new Grid((Composite)this.getShell(), 65540);
        ridget.setUIControl((Object)control);
        try {
            ridget.setColumnWidths(new Object[1]);
            GridRidgetTest.fail();
        }
        catch (RuntimeException rex) {
            GridRidgetTest.assertTrue((boolean)rex.getMessage().contains("null"));
        }
        try {
            ridget.setColumnWidths(new Object[]{new Object()});
            GridRidgetTest.fail();
        }
        catch (RuntimeException rex) {
            GridRidgetTest.assertTrue((boolean)rex.getMessage().contains("Object"));
        }
        ridget.setColumnWidths(new Object[]{new ColumnPixelData(20), new ColumnPixelData(40), new ColumnPixelData(60)});
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        int[] expected = new int[]{20, 40, 60};
        int i = 0;
        while (i < 3) {
            int actual = control.getColumn(i).getWidth();
            String msg = String.format("col #%d, exp:%d, act:%d", i, expected[i], actual);
            GridRidgetTest.assertEquals((String)msg, (int)expected[i], (int)actual);
            ++i;
        }
    }

    public void testPreserveColumnWidths() {
        int[] widths = new int[]{50, 100, 150};
        ITableRidget ridget = this.createRidget();
        Grid control = new Grid((Composite)this.getShell(), 65540);
        int[] nArray = widths;
        int n = widths.length;
        int n2 = 0;
        while (n2 < n) {
            int width = nArray[n2];
            GridColumn column = new GridColumn(control, 0);
            column.setWidth(width);
            ++n2;
        }
        ridget.setUIControl((Object)control);
        String[] columns3 = new String[]{"firstname", "lastname", "birthday"};
        ridget.bindToModel((Object)this.manager, "persons", Person.class, columns3, null);
        ridget.updateFromModel();
        int i = 0;
        while (i < 3) {
            int actual = control.getColumn(i).getWidth();
            String msg = String.format("col #%d, exp:%d, act:%d", i, widths[i], actual);
            GridRidgetTest.assertEquals((String)msg, (int)widths[i], (int)actual);
            ++i;
        }
    }

    public void testRefreshNull() {
        ITableRidget ridget = this.createRidget();
        Grid control = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)control);
        StringPojo word1 = new StringPojo("eclipse");
        StringPojo word2 = new StringPojo("riena");
        WritableList values = new WritableList(Arrays.asList(word1, word2), StringPojo.class);
        String[] columns = new String[]{"value"};
        ridget.bindToModel((IObservableList)values, StringPojo.class, columns, null);
        ridget.updateFromModel();
        GridRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0).getText());
        GridRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
        word1.setValue("alpha");
        word2.setValue("beta");
        GridRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0).getText());
        GridRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
        ridget.refresh(null);
        GridRidgetTest.assertEquals((String)"alpha", (String)control.getItem(0).getText());
        GridRidgetTest.assertEquals((String)"beta", (String)control.getItem(1).getText());
    }

    public void testRefresh() {
        ITableRidget ridget = this.createRidget();
        Grid control = this.createWidget((Composite)this.getShell());
        ridget.setUIControl((Object)control);
        StringPojo word1 = new StringPojo("eclipse");
        StringPojo word2 = new StringPojo("riena");
        WritableList values = new WritableList(Arrays.asList(word1, word2), StringPojo.class);
        String[] columns = new String[]{"value"};
        ridget.bindToModel((IObservableList)values, StringPojo.class, columns, null);
        ridget.updateFromModel();
        GridRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0).getText());
        GridRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
        word1.setValue("alpha");
        word2.setValue("beta");
        GridRidgetTest.assertEquals((String)"eclipse", (String)control.getItem(0).getText());
        GridRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
        ridget.refresh((Object)word1);
        GridRidgetTest.assertEquals((String)"alpha", (String)control.getItem(0).getText());
        GridRidgetTest.assertEquals((String)"riena", (String)control.getItem(1).getText());
    }

    public void testRowErrorMessageMarker() {
        GridRidget ridget = this.getRidget();
        RowErrorMessageMarker marker1 = new RowErrorMessageMarker(null, (Object)this.person1);
        RowErrorMessageMarker marker2 = new RowErrorMessageMarker(null, (Object)this.person2);
        GridRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addMarker((IMarker)marker1);
        ridget.addMarker((IMarker)marker1);
        GridRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeMarker((IMarker)marker1);
        GridRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.addMarker((IMarker)marker1);
        ridget.addMarker((IMarker)marker2);
        ridget.removeMarker((IMarker)marker1);
        GridRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.removeMarker((IMarker)marker2);
        GridRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testGetOptionWithSorting() {
        GridRidget ridget = this.getRidget();
        GridRidgetTest.assertEquals((int)0, (int)ridget.indexOfOption((Object)this.person1));
        GridRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(0));
        ridget.setComparator(1, (Comparator)new StringComparator());
        ridget.setSortedColumn(1);
        ridget.setSortedAscending(false);
        int last = ridget.getOptionCount() - 1;
        GridRidgetTest.assertEquals((int)last, (int)ridget.indexOfOption((Object)this.person1));
        GridRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(last));
        ridget.setSortedAscending(true);
        GridRidgetTest.assertEquals((int)0, (int)ridget.indexOfOption((Object)this.person1));
        GridRidgetTest.assertEquals((Object)this.person1, (Object)ridget.getOption(0));
    }

    public void testSetSelectionWithSorting() {
        GridRidget ridget = this.getRidget();
        GridRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        GridRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
        ridget.setSelection(0);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        GridRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setComparator(1, (Comparator)new StringComparator());
        ridget.setSortedColumn(1);
        ridget.setSortedAscending(false);
        int last = ridget.getOptionCount() - 1;
        GridRidgetTest.assertEquals((int)last, (int)ridget.getSelectionIndex());
        GridRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
        ridget.setSortedAscending(true);
        GridRidgetTest.assertEquals((int)0, (int)ridget.getSelectionIndex());
        GridRidgetTest.assertEquals((Object)this.person1, ridget.getSelection().get(0));
    }

    private static final class StringComparator
    implements Comparator<Object> {
        private StringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }
}

