/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.ShellRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ShellRidgetTest
extends AbstractSWTRidgetTest {
    @Override
    protected IRidget createRidget() {
        return new MockShellRidget();
    }

    @Override
    protected Widget createWidget(Composite parent) {
        return this.getShell();
    }

    protected MockShellRidget getRidget() {
        return (MockShellRidget)super.getRidget();
    }

    protected Shell getWidget() {
        return (Shell)super.getWidget();
    }

    @Override
    public void testGetFocusable() {
        ShellRidgetTest.assertFalse((boolean)this.getRidget().isFocusable());
        this.getRidget().setFocusable(true);
        ShellRidgetTest.assertFalse((boolean)this.getRidget().isFocusable());
    }

    public void testHasChanged() {
        ShellRidgetTest.assertTrue((boolean)this.getRidget().hasChanged("a", "b"));
        ShellRidgetTest.assertFalse((boolean)this.getRidget().hasChanged("a", "a"));
        ShellRidgetTest.assertTrue((boolean)this.getRidget().hasChanged(null, "b"));
        ShellRidgetTest.assertTrue((boolean)this.getRidget().hasChanged("a", null));
        ShellRidgetTest.assertFalse((boolean)this.getRidget().hasChanged(null, null));
    }

    public void testSetActive() throws Exception {
        this.getRidget().setActive(false);
        ShellRidgetTest.assertFalse((boolean)this.getRidget().isEnabled());
        ShellRidgetTest.assertFalse((boolean)this.getWidget().isEnabled());
        this.getRidget().setActive(true);
        ShellRidgetTest.assertTrue((boolean)this.getRidget().isEnabled());
        ShellRidgetTest.assertTrue((boolean)this.getWidget().isEnabled());
    }

    @Override
    public void testGetMenuItemCount() {
        MockShellRidget ridget = this.getRidget();
        try {
            ridget.getMenuItemCount();
            ShellRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testGetMenuItem() {
        MockShellRidget ridget = this.getRidget();
        try {
            ridget.getMenuItem(0);
            ShellRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testAddMenuItem() {
        MockShellRidget ridget = this.getRidget();
        try {
            ridget.addMenuItem("MenuItemWithoutIcon");
            ShellRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testRemoveMenuItem() {
        MockShellRidget ridget = this.getRidget();
        try {
            ridget.removeMenuItem("MenuItemWithIcon");
            ShellRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testGetMenuItemEmptyContextMenu() {
        try {
            MockShellRidget ridget = this.getRidget();
            ridget.getMenuItem(0);
            ShellRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testGetMenuItemNotExistingItem() {
        MockShellRidget ridget = this.getRidget();
        try {
            ridget.getMenuItem(0);
            ShellRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    private static class MockShellRidget
    extends ShellRidget {
        private MockShellRidget() {
        }

        public boolean hasChanged(Object oldValue, Object newValue) {
            return super.hasChanged(oldValue, newValue);
        }
    }
}

