/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationModelFailure;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeAdapter;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.impl.UIFilter;

@NonUITestCase
public class NavigationNodeTest
extends RienaTestCase {
    public void testSetBlockedCalledOnce() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SetBlockCalledDetector setBlockedCalledDetector = new SetBlockCalledDetector();
        node.addSimpleListener((ISimpleNavigationNodeListener)setBlockedCalledDetector);
        NavigationNodeTest.assertFalse((boolean)node.isBlocked());
        node.setBlocked(true);
        NavigationNodeTest.assertTrue((boolean)setBlockedCalledDetector.blockedCalled);
    }

    public void testSetBlockedCalledTwice() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        NavigationNodeTest.assertFalse((boolean)node.isBlocked());
        node.setBlocked(true);
        SetBlockCalledDetector setBlockedCalledDetector = new SetBlockCalledDetector();
        node.addSimpleListener((ISimpleNavigationNodeListener)setBlockedCalledDetector);
        NavigationNodeTest.assertTrue((boolean)node.isBlocked());
        node.setBlocked(true);
        NavigationNodeTest.assertFalse((boolean)setBlockedCalledDetector.blockedCalled);
    }

    public void testNavigationNode() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        NavigationNodeTest.assertSame((Object)id, (Object)node.getNodeId());
        List listeners = (List)ReflectionUtils.invokeHidden((Object)((Object)node), (String)"getListeners", (Object[])new Object[0]);
        NavigationNodeTest.assertNotNull((Object)listeners);
        NavigationNodeTest.assertTrue((boolean)listeners.isEmpty());
        NavigationNodeTest.assertNotNull((Object)node.getActions());
        NavigationNodeTest.assertTrue((boolean)node.getActions().isEmpty());
        NavigationNodeTest.assertNotNull((Object)node.getChildren());
        NavigationNodeTest.assertTrue((boolean)node.getChildren().isEmpty());
        NavigationNodeTest.assertNotNull((Object)node.getMarkable());
        NavigationNodeTest.assertTrue((boolean)node.isVisible());
        NavigationNodeTest.assertTrue((boolean)node.isCreated());
        NavigationNodeTest.assertFalse((boolean)node.isActivated());
        NavigationNodeTest.assertFalse((boolean)node.isDeactivated());
        NavigationNodeTest.assertFalse((boolean)node.isDisposed());
    }

    public void testIsEnabled() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        NavigationNodeTest.assertTrue((boolean)node.isEnabled());
        DisabledMarker disabledMarker = new DisabledMarker();
        node.addMarker((IMarker)disabledMarker);
        NavigationNodeTest.assertFalse((boolean)node.isEnabled());
        node.removeMarker((IMarker)disabledMarker);
        node.addMarker((IMarker)new HiddenMarker());
        NavigationNodeTest.assertTrue((boolean)node.isEnabled());
        NavigationNodeId id2 = new NavigationNodeId("0815");
        NaviNode node2 = new NaviNode(id2);
        node2.setParent((INavigationNode)node);
        NavigationNodeTest.assertTrue((boolean)node.isEnabled());
        node.addMarker((IMarker)disabledMarker);
        NavigationNodeTest.assertFalse((boolean)node.isEnabled());
    }

    public void testIsVisible() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        NavigationNodeTest.assertTrue((boolean)node.isVisible());
        HiddenMarker hiddenMarker = new HiddenMarker();
        node.addMarker((IMarker)hiddenMarker);
        NavigationNodeTest.assertFalse((boolean)node.isVisible());
        node.removeMarker((IMarker)hiddenMarker);
        node.addMarker((IMarker)new DisabledMarker());
        NavigationNodeTest.assertTrue((boolean)node.isVisible());
        NavigationNodeId id2 = new NavigationNodeId("0815");
        NaviNode node2 = new NaviNode(id2);
        node2.setParent((INavigationNode)node);
        NavigationNodeTest.assertTrue((boolean)node.isVisible());
        node.addMarker((IMarker)hiddenMarker);
        NavigationNodeTest.assertFalse((boolean)node.isVisible());
    }

    public void testSetEnabled() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        NavigationNodeTest.assertTrue((boolean)node.isEnabled());
        node.setEnabled(false);
        NavigationNodeTest.assertFalse((boolean)node.isEnabled());
        Collection markers = node.getMarkersOfType(DisabledMarker.class);
        NavigationNodeTest.assertNotNull((Object)markers);
        NavigationNodeTest.assertTrue((markers.size() == 1 ? 1 : 0) != 0);
        IMarker marker1 = (IMarker)markers.iterator().next();
        node.setEnabled(false);
        NavigationNodeTest.assertFalse((boolean)node.isEnabled());
        markers = node.getMarkersOfType(DisabledMarker.class);
        NavigationNodeTest.assertNotNull((Object)markers);
        NavigationNodeTest.assertTrue((markers.size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)marker1, markers.iterator().next());
        node.setEnabled(true);
        NavigationNodeTest.assertTrue((boolean)node.isEnabled());
        markers = node.getMarkersOfType(DisabledMarker.class);
        NavigationNodeTest.assertNotNull((Object)markers);
        NavigationNodeTest.assertTrue((boolean)markers.isEmpty());
        node.setEnabled(false);
        NavigationNodeTest.assertFalse((boolean)node.isEnabled());
        markers = node.getMarkersOfType(DisabledMarker.class);
        NavigationNodeTest.assertNotNull((Object)markers);
        NavigationNodeTest.assertTrue((markers.size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)marker1, markers.iterator().next());
    }

    public void testSetVisible() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        NavigationNodeTest.assertTrue((boolean)node.isVisible());
        node.setVisible(false);
        NavigationNodeTest.assertFalse((boolean)node.isVisible());
        Collection markers = node.getMarkersOfType(HiddenMarker.class);
        NavigationNodeTest.assertNotNull((Object)markers);
        NavigationNodeTest.assertTrue((markers.size() == 1 ? 1 : 0) != 0);
        IMarker marker1 = (IMarker)markers.iterator().next();
        node.setVisible(false);
        NavigationNodeTest.assertFalse((boolean)node.isVisible());
        markers = node.getMarkersOfType(HiddenMarker.class);
        NavigationNodeTest.assertNotNull((Object)markers);
        NavigationNodeTest.assertTrue((markers.size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)marker1, markers.iterator().next());
        node.setVisible(true);
        NavigationNodeTest.assertTrue((boolean)node.isVisible());
        markers = node.getMarkersOfType(HiddenMarker.class);
        NavigationNodeTest.assertNotNull((Object)markers);
        NavigationNodeTest.assertTrue((boolean)markers.isEmpty());
        node.setVisible(false);
        NavigationNodeTest.assertFalse((boolean)node.isVisible());
        markers = node.getMarkersOfType(HiddenMarker.class);
        NavigationNodeTest.assertNotNull((Object)markers);
        NavigationNodeTest.assertTrue((markers.size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)marker1, markers.iterator().next());
    }

    public void testAddMarker() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        NavigationNodeId id2 = new NavigationNodeId("0815");
        NaviNode node2 = new NaviNode(id2);
        node2.setParent((INavigationNode)node);
        node.addChild((INavigationNode)node2);
        node.reset();
        node2.reset();
        HiddenMarker hiddenMarker = new HiddenMarker();
        node.addMarker(null, (IMarker)hiddenMarker);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(HiddenMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((node2.getMarkersOfType(HiddenMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertTrue((boolean)node2.isMarkersChangedCalled());
        node.reset();
        node2.reset();
        DisabledMarker disabledMarker = new DisabledMarker();
        node.addMarker(null, (IMarker)disabledMarker);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(DisabledMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((node2.getMarkersOfType(DisabledMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertTrue((boolean)node2.isMarkersChangedCalled());
        node.reset();
        node2.reset();
        OutputMarker outputMarker = new OutputMarker();
        node.addMarker(null, (IMarker)outputMarker);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(OutputMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node2.getMarkersOfType(OutputMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isMarkersChangedCalled());
        node.reset();
        node2.reset();
        ErrorMarker errorMarker = new ErrorMarker();
        node.addMarker(null, (IMarker)errorMarker);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(ErrorMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node2.getMarkersOfType(ErrorMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isMarkersChangedCalled());
    }

    public void testRemoveMarker() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        NavigationNodeId id2 = new NavigationNodeId("0815");
        NaviNode node2 = new NaviNode(id2);
        node2.setParent((INavigationNode)node);
        node.addChild((INavigationNode)node2);
        HiddenMarker hiddenMarker = new HiddenMarker();
        node.addMarker(null, (IMarker)hiddenMarker);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(HiddenMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((node2.getMarkersOfType(HiddenMarker.class).size() == 1 ? 1 : 0) != 0);
        DisabledMarker disabledMarker = new DisabledMarker();
        node.addMarker(null, (IMarker)disabledMarker);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(DisabledMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((node2.getMarkersOfType(DisabledMarker.class).size() == 1 ? 1 : 0) != 0);
        OutputMarker outputMarker = new OutputMarker();
        node.addMarker(null, (IMarker)outputMarker);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(OutputMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node2.getMarkersOfType(OutputMarker.class).isEmpty());
        ErrorMarker errorMarker = new ErrorMarker();
        node.addMarker(null, (IMarker)errorMarker);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(ErrorMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node2.getMarkersOfType(ErrorMarker.class).isEmpty());
        node.reset();
        node2.reset();
        node.removeMarker((IMarker)hiddenMarker);
        NavigationNodeTest.assertTrue((boolean)node.getMarkersOfType(HiddenMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((boolean)node2.getMarkersOfType(HiddenMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((node.getMarkersOfType(DisabledMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((node2.getMarkersOfType(DisabledMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(OutputMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(ErrorMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertTrue((boolean)node2.isMarkersChangedCalled());
        node.reset();
        node2.reset();
        node.removeMarker((IMarker)disabledMarker);
        NavigationNodeTest.assertTrue((boolean)node.getMarkersOfType(DisabledMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((boolean)node2.getMarkersOfType(DisabledMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((node.getMarkersOfType(OutputMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((node.getMarkersOfType(ErrorMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertTrue((boolean)node2.isMarkersChangedCalled());
        node.reset();
        node2.reset();
        node.removeMarker((IMarker)outputMarker);
        NavigationNodeTest.assertTrue((boolean)node.getMarkersOfType(OutputMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((node.getMarkersOfType(ErrorMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isMarkersChangedCalled());
        node.reset();
        node2.reset();
        node.removeMarker((IMarker)errorMarker);
        NavigationNodeTest.assertTrue((boolean)node.getMarkersOfType(ErrorMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isMarkersChangedCalled());
        node.addMarker((IMarker)errorMarker);
        node2.addMarker((IMarker)errorMarker);
        node.reset();
        node2.reset();
        node.removeMarker((IMarker)errorMarker);
        NavigationNodeTest.assertTrue((boolean)node.getMarkersOfType(ErrorMarker.class).isEmpty());
        NavigationNodeTest.assertTrue((node2.getMarkersOfType(ErrorMarker.class).size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertTrue((boolean)node.isMarkersChangedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isMarkersChangedCalled());
    }

    public void testFindNode() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        NavigationNodeTest.assertSame((Object)((Object)node), (Object)node.findNode(id));
        NavigationNodeTest.assertNull((Object)node.findNode(null));
        NavigationNodeTest.assertNull((Object)node.findNode(new NavigationNodeId("someId")));
        NavigationNodeId id2 = new NavigationNodeId("0815");
        NaviNode node2 = new NaviNode(id2);
        node2.setParent((INavigationNode)node);
        node.addChild((INavigationNode)node2);
        NavigationNodeTest.assertSame((Object)((Object)node2), (Object)node.findNode(id2));
    }

    public void testSetNodeId() throws InstantiationException, IllegalAccessException {
        NavigationNodeId id = new NavigationNodeId("4711", "0815");
        NaviNode node = new NaviNode(id);
        node.reset();
        NavigationNodeTest.assertFalse((boolean)node.isNodeIdChangeCalled());
        NavigationNodeTest.assertEquals((Object)id, (Object)node.getNodeId());
        NavigationNodeId newId = new NavigationNodeId("1174", "5180");
        node.setNodeId(newId);
        NavigationNodeTest.assertTrue((boolean)node.isNodeIdChangeCalled());
        NavigationNodeTest.assertEquals((Object)newId, (Object)node.getNodeId());
    }

    public void testAddChild() throws InstantiationException, IllegalAccessException {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        node.reset();
        try {
            node.addChild(null);
            NavigationNodeTest.fail((String)"NavigationModelFailure expected");
        }
        catch (NavigationModelFailure navigationModelFailure) {
            this.ok("NavigationModelFailure expected");
        }
        NavigationNodeTest.assertTrue((boolean)node.getChildren().isEmpty());
        NavigationNodeTest.assertFalse((boolean)node.isChildAddedCalled());
        NavigationNodeId id2 = new NavigationNodeId("2");
        NaviNode node2 = new NaviNode(id2);
        node.reset();
        node.addChild((INavigationNode)node2);
        NavigationNodeTest.assertTrue((node.getChildren().size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)((Object)node2), node.getChildren().get(0));
        NavigationNodeTest.assertSame((Object)((Object)node), (Object)node2.getParent());
        NavigationNodeTest.assertTrue((boolean)node.isChildAddedCalled());
        NavigationNodeTest.assertTrue((boolean)node2.isParentChangedCalled());
        NavigationNodeTest.assertTrue((boolean)node.isParentChangedCalledAfterChildAddedCalled());
        node.reset();
        node2.reset();
        try {
            node.addChild((INavigationNode)node2);
            NavigationNodeTest.fail((String)"NavigationModelFailure expected");
        }
        catch (NavigationModelFailure navigationModelFailure) {
            this.ok("NavigationModelFailure expected");
        }
        NavigationNodeTest.assertTrue((node.getChildren().size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)((Object)node2), node.getChildren().get(0));
        NavigationNodeTest.assertSame((Object)((Object)node), (Object)node2.getParent());
        NavigationNodeTest.assertFalse((boolean)node.isChildAddedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isParentChangedCalled());
        NavigationNodeId id3 = new NavigationNodeId("3");
        NaviNode node3 = new NaviNode(id3);
        node3.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        node3.dispose();
        node.reset();
        try {
            node.addChild((INavigationNode)node3);
            NavigationNodeTest.fail((String)"NavigationModelFailure expected");
        }
        catch (NavigationModelFailure navigationModelFailure) {
            this.ok("NavigationModelFailure expected");
        }
        NavigationNodeTest.assertTrue((node.getChildren().size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)((Object)node2), node.getChildren().get(0));
        NavigationNodeTest.assertNull((Object)node3.getParent());
        NavigationNodeTest.assertFalse((boolean)node.isChildAddedCalled());
        NavigationNodeTest.assertFalse((boolean)node3.isParentChangedCalled());
        try {
            node.addChild((INavigationNode)node);
            NavigationNodeTest.fail((String)"NavigationModelFailure expected");
        }
        catch (NavigationModelFailure navigationModelFailure) {
            this.ok("NavigationModelFailure expected");
        }
        try {
            this.getParentNode(ApplicationNode.class).addChild((INavigationNode)node);
            NavigationNodeTest.fail((String)"NavigationModelFailure expected");
        }
        catch (NavigationModelFailure navigationModelFailure) {
            this.ok("NavigationModelFailure expected");
        }
        IModuleNode module = (IModuleNode)this.getParentNode(ModuleNode.class);
        module.addChild((INavigationNode)node);
        NavigationNodeTest.assertSame((Object)((Object)node), (Object)module.getChild(module.getChildren().size() - 1));
    }

    private INavigationNode getParentNode(Class<? extends INavigationNode> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public void testRemoveChild() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        NavigationNodeId id2 = new NavigationNodeId("2");
        NaviNode node2 = new NaviNode(id2);
        node.addChild((INavigationNode)node2);
        NavigationNodeId id3 = new NavigationNodeId("3");
        NaviNode node3 = new NaviNode(id3);
        node.addChild((INavigationNode)node3);
        node.reset();
        node2.reset();
        node3.reset();
        try {
            node.removeChild(null);
            NavigationNodeTest.fail((String)"NavigationModelFailure expected");
        }
        catch (NavigationModelFailure navigationModelFailure) {
            this.ok("NavigationModelFailure expected");
        }
        NavigationNodeTest.assertTrue((node.getChildren().size() == 2 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)((Object)node), (Object)node2.getParent());
        NavigationNodeTest.assertSame((Object)((Object)node), (Object)node3.getParent());
        NavigationNodeTest.assertFalse((boolean)node.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node3.isChildRemovedCalled());
        node.reset();
        node2.reset();
        node3.reset();
        node.removeChild((INavigationNode)node3);
        NavigationNodeTest.assertTrue((node.getChildren().size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)((Object)node), (Object)node2.getParent());
        NavigationNodeTest.assertNull((Object)node3.getParent());
        NavigationNodeTest.assertTrue((boolean)node.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node3.isChildRemovedCalled());
        node.reset();
        node2.reset();
        node3.reset();
        node2.activate(null);
        try {
            node.removeChild((INavigationNode)node2);
            NavigationNodeTest.fail((String)"NavigationModelFailure expected");
        }
        catch (NavigationModelFailure navigationModelFailure) {
            this.ok("NavigationModelFailure expected");
        }
        NavigationNodeTest.assertTrue((node.getChildren().size() == 1 ? 1 : 0) != 0);
        NavigationNodeTest.assertSame((Object)((Object)node), (Object)node2.getParent());
        NavigationNodeTest.assertNull((Object)node3.getParent());
        NavigationNodeTest.assertFalse((boolean)node.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node3.isChildRemovedCalled());
        node.reset();
        node2.reset();
        node3.reset();
        node2.deactivate(null);
        node.removeChild((INavigationNode)node2);
        NavigationNodeTest.assertTrue((boolean)node.getChildren().isEmpty());
        NavigationNodeTest.assertNull((Object)node2.getParent());
        NavigationNodeTest.assertNull((Object)node3.getParent());
        NavigationNodeTest.assertTrue((boolean)node.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node3.isChildRemovedCalled());
        node.reset();
        node2.reset();
        node3.reset();
        try {
            node.removeChild((INavigationNode)node2);
            NavigationNodeTest.fail((String)"NavigationModelFailure expected");
        }
        catch (NavigationModelFailure navigationModelFailure) {
            this.ok("NavigationModelFailure expected");
        }
        NavigationNodeTest.assertTrue((boolean)node.getChildren().isEmpty());
        NavigationNodeTest.assertNull((Object)node2.getParent());
        NavigationNodeTest.assertNull((Object)node3.getParent());
        NavigationNodeTest.assertFalse((boolean)node.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node2.isChildRemovedCalled());
        NavigationNodeTest.assertFalse((boolean)node3.isChildRemovedCalled());
    }

    public void testGetNavigationProcessor() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        NavigationNodeTest.assertSame((Object)ApplicationNodeManager.getDefaultNavigationProcessor(), (Object)node.getNavigationProcessor());
        NavigationNodeId id2 = new NavigationNodeId("2");
        NaviNode node2 = new NaviNode(id2);
        node.addChild((INavigationNode)node2);
        NavigationNodeTest.assertSame((Object)ApplicationNodeManager.getDefaultNavigationProcessor(), (Object)node2.getNavigationProcessor());
        NavigationProcessor naviProcessor = new NavigationProcessor();
        node.setNavigationProcessor((INavigationProcessor)naviProcessor);
        NavigationNodeTest.assertSame((Object)naviProcessor, (Object)node2.getNavigationProcessor());
        NavigationProcessor naviProcessor2 = new NavigationProcessor();
        node2.setNavigationProcessor((INavigationProcessor)naviProcessor2);
        NavigationNodeTest.assertSame((Object)naviProcessor2, (Object)node2.getNavigationProcessor());
        NavigationNodeTest.assertSame((Object)naviProcessor, (Object)node.getNavigationProcessor());
    }

    public void testCheckChildClass() {
        NavigationNodeId id = new NavigationNodeId("4711");
        NaviNode node = new NaviNode(id);
        NavigationNodeTest.assertTrue((boolean)node.checkChildClass(NaviNode.class));
        NavigationNodeTest.assertTrue((boolean)node.checkChildClass(SubModuleNode.class));
        NavigationNodeTest.assertFalse((boolean)node.checkChildClass(ModuleNode.class));
        NavigationNodeTest.assertFalse((boolean)node.checkChildClass(Object.class));
        try {
            node.checkChildClass(null);
            NavigationNodeTest.fail((String)"Exception expected");
        }
        catch (AssertionFailedException assertionFailedException) {
            this.ok("Exception expected");
        }
    }

    public void testCheckChild() throws Exception {
        NavigationNodeId id = new NavigationNodeId("4711", "0815");
        NaviNode node = new NaviNode(id);
        try {
            ReflectionUtils.invokeHidden((Object)((Object)node), (String)"checkChild", (Object[])new Object[]{node});
            NavigationNodeTest.fail((String)"Exception expected");
        }
        catch (Exception e) {
            if (e.getCause() instanceof NavigationModelFailure) {
                this.ok("Exception expected");
            }
            NavigationNodeTest.fail((String)"Unexpcted exception");
        }
        NavigationNodeId id1 = new NavigationNodeId("child1", "1");
        NaviNode child1 = new NaviNode(id1);
        ReflectionUtils.invokeHidden((Object)((Object)node), (String)"checkChild", (Object[])new Object[]{child1});
        node.addChild((INavigationNode)child1);
        try {
            ReflectionUtils.invokeHidden((Object)((Object)node), (String)"checkChild", (Object[])new Object[]{child1});
            NavigationNodeTest.fail((String)"Exception expected");
        }
        catch (Exception e) {
            if (e.getCause() instanceof NavigationModelFailure) {
                this.ok("Exception expected");
            }
            NavigationNodeTest.fail((String)"Unexpcted exception");
        }
        NavigationNodeId id2 = new NavigationNodeId("child2", "2");
        NaviNode child2 = new NaviNode(id2);
        ReflectionUtils.invokeHidden((Object)((Object)node), (String)"checkChild", (Object[])new Object[]{child2});
        child2.dispose();
        try {
            ReflectionUtils.invokeHidden((Object)((Object)node), (String)"checkChild", (Object[])new Object[]{child2});
            NavigationNodeTest.fail((String)"Exception expected");
        }
        catch (Exception e) {
            if (e.getCause() instanceof NavigationModelFailure) {
                this.ok("Exception expected");
            }
            NavigationNodeTest.fail((String)"Unexpcted exception");
        }
        NavigationNodeId id3 = new NavigationNodeId("child3", "3");
        ModuleNode child3 = new ModuleNode(id3);
        try {
            ReflectionUtils.invokeHidden((Object)((Object)node), (String)"checkChild", (Object[])new Object[]{child3});
            NavigationNodeTest.fail((String)"Exception expected");
        }
        catch (Exception e) {
            if (e.getCause() instanceof NavigationModelFailure) {
                this.ok("Exception expected");
            }
            NavigationNodeTest.fail((String)"Unexpcted exception");
        }
        NavigationNodeId id4 = new NavigationNodeId("4711", "0815");
        NaviNode child4 = new NaviNode(id4);
        try {
            ReflectionUtils.invokeHidden((Object)((Object)node), (String)"checkChild", (Object[])new Object[]{child4});
            NavigationNodeTest.fail((String)"Exception expected");
        }
        catch (Exception e) {
            if (e.getCause() instanceof NavigationModelFailure) {
                this.ok("Exception expected");
            }
            NavigationNodeTest.fail((String)"Unexpcted exception");
        }
        NavigationNodeId id5 = new NavigationNodeId("child1", "1");
        NaviNode child5 = new NaviNode(id5);
        try {
            ReflectionUtils.invokeHidden((Object)((Object)node), (String)"checkChild", (Object[])new Object[]{child5});
            NavigationNodeTest.fail((String)"Exception expected");
        }
        catch (Exception e) {
            if (e.getCause() instanceof NavigationModelFailure) {
                this.ok("Exception expected");
            }
            NavigationNodeTest.fail((String)"Unexpcted exception");
        }
    }

    public void testPrepare() {
        NavigationNodeId id = new NavigationNodeId("0815");
        NaviNode node = new NaviNode(id);
        NavigationNodeTest.assertTrue((boolean)node.isCreated());
        NavigationNodeTest.assertFalse((boolean)node.isPrepared());
        NavigationNodeTest.assertFalse((boolean)node.isPreparedCalled());
        node.prepare(null);
        NavigationNodeTest.assertTrue((boolean)node.isPrepared());
        NavigationNodeTest.assertFalse((boolean)node.isCreated());
        NavigationNodeTest.assertFalse((boolean)node.isActivated());
        NavigationNodeTest.assertTrue((boolean)node.isPreparedCalled());
    }

    public void testToString() {
        NaviNode node = new NaviNode(null);
        NavigationNodeTest.assertEquals((String)"NavigationNode [label=null, nodeId=null]", (String)node.toString());
        node = new NaviNode(null);
        node.setLabel("LabelOfNode");
        NavigationNodeTest.assertEquals((String)"NavigationNode [label=LabelOfNode, nodeId=null]", (String)node.toString());
        node = new NaviNode(new NavigationNodeId("4711"));
        NavigationNodeTest.assertEquals((String)"NavigationNode [label=null, nodeId=NavigationNodeId [typeId=4711, instanceId=null]]", (String)node.toString());
        node = new NaviNode(new NavigationNodeId("4711", "0815"));
        NavigationNodeTest.assertEquals((String)"NavigationNode [label=null, nodeId=NavigationNodeId [typeId=4711, instanceId=0815]]", (String)node.toString());
        node = new NaviNode(new NavigationNodeId("4711", "0815"));
        node.setLabel("LabelTwo");
        NavigationNodeTest.assertEquals((String)"NavigationNode [label=LabelTwo, nodeId=NavigationNodeId [typeId=4711, instanceId=0815]]", (String)node.toString());
    }

    public void testAddFilter() {
        NaviNode node = new NaviNode(null);
        UIFilter filter1 = new UIFilter("filterOne");
        node.addFilter((IUIFilter)filter1);
        NavigationNodeTest.assertEquals((int)1, (int)node.getFilters().size());
        NavigationNodeTest.assertSame((Object)filter1, node.getFilters().iterator().next());
        NavigationNodeTest.assertTrue((boolean)node.isFilterAddedCalled());
    }

    public void testRemoveFilter() {
        NaviNode node = new NaviNode(null);
        UIFilter filter1 = new UIFilter("filterOne");
        node.addFilter((IUIFilter)filter1);
        UIFilter filter2 = new UIFilter("filterTwo");
        node.addFilter((IUIFilter)filter2);
        NavigationNodeTest.assertEquals((int)2, (int)node.getFilters().size());
        node.removeFilter("filterTwo");
        NavigationNodeTest.assertEquals((int)1, (int)node.getFilters().size());
        NavigationNodeTest.assertSame((Object)filter1, node.getFilters().iterator().next());
        NavigationNodeTest.assertTrue((boolean)node.isFilterRemovedCalled());
        node.reset();
        node.removeFilter("filterOne");
        NavigationNodeTest.assertTrue((boolean)node.getFilters().isEmpty());
        NavigationNodeTest.assertTrue((boolean)node.isFilterRemovedCalled());
    }

    public void testRemoveAllFilters() {
        NaviNode node = new NaviNode(null);
        UIFilter filter1 = new UIFilter("filterOne");
        node.addFilter((IUIFilter)filter1);
        UIFilter filter2 = new UIFilter("filterTwo");
        node.addFilter((IUIFilter)filter2);
        NavigationNodeTest.assertEquals((int)2, (int)node.getFilters().size());
        node.removeAllFilters();
        NavigationNodeTest.assertTrue((boolean)node.getFilters().isEmpty());
        NavigationNodeTest.assertTrue((boolean)node.isFilterRemovedCalled());
    }

    public void testContext() {
        NaviNode node = new NaviNode(null);
        NavigationNodeTest.assertNull((Object)node.getContext("nothinghere"));
        node.setContext("context1", "value1");
        NavigationNodeTest.assertEquals((Object)"value1", (Object)node.getContext("context1"));
        node.setContext("context1", "value2");
        NavigationNodeTest.assertEquals((Object)"value2", (Object)node.getContext("context1"));
        node.setContext("context2", "value3");
        NavigationNodeTest.assertEquals((Object)"value3", (Object)node.getContext("context2"));
        node.removeContext("context2");
        NavigationNodeTest.assertNull((Object)node.getContext("context2"));
        NavigationNodeTest.assertEquals((Object)"value2", (Object)node.getContext("context1"));
    }

    private class NaviNode
    extends SubModuleNode
    implements ISimpleNavigationNodeListener {
        private boolean markersChangedCalled;
        private boolean childAddedCalled;
        private boolean childRemovedCalled;
        private boolean preparedCalled;
        private boolean filterRemovedCalled;
        private boolean filterAddedCalled;
        private boolean parentChangedCalled;
        private boolean parentChangedCalledAfterChildAddedCalled;
        private boolean nodeIdChangeCalled;

        public NaviNode(NavigationNodeId nodeId) {
            super(nodeId);
            this.addSimpleListener(this);
        }

        public void reset() {
            this.markersChangedCalled = false;
            this.childAddedCalled = false;
            this.childRemovedCalled = false;
            this.preparedCalled = false;
            this.filterRemovedCalled = false;
            this.filterAddedCalled = false;
            this.parentChangedCalled = false;
            this.parentChangedCalledAfterChildAddedCalled = false;
            this.nodeIdChangeCalled = false;
        }

        public void activated(INavigationNode<?> source) {
        }

        public void prepared(INavigationNode<?> source) {
            this.preparedCalled = true;
        }

        public void afterActivated(INavigationNode<?> source) {
        }

        public void afterDeactivated(INavigationNode<?> source) {
        }

        public void afterDisposed(INavigationNode<?> source) {
        }

        public void beforeActivated(INavigationNode<?> source) {
        }

        public void beforeDeactivated(INavigationNode<?> source) {
        }

        public void beforeDisposed(INavigationNode<?> source) {
        }

        public void block(INavigationNode<?> source, boolean block) {
        }

        public void childAdded(INavigationNode<?> source, INavigationNode<?> childAdded) {
            this.childAddedCalled = true;
            if (childAdded instanceof NaviNode) {
                NaviNode child = (NaviNode)childAdded;
                this.parentChangedCalledAfterChildAddedCalled = !child.isParentChangedCalled();
            }
        }

        public void childRemoved(INavigationNode<?> source, INavigationNode<?> childRemoved) {
            this.childRemovedCalled = true;
        }

        public void deactivated(INavigationNode<?> source) {
        }

        public void disposed(INavigationNode<?> source) {
        }

        public void expandedChanged(INavigationNode<?> source) {
        }

        public void filterAdded(INavigationNode<?> source, IUIFilter filter) {
            this.filterAddedCalled = true;
        }

        public void filterRemoved(INavigationNode<?> source, IUIFilter filter) {
            this.filterRemovedCalled = true;
        }

        public void iconChanged(INavigationNode<?> source) {
        }

        public void labelChanged(INavigationNode<?> source) {
        }

        public void markerChanged(INavigationNode<?> source, IMarker marker) {
            this.markersChangedCalled = true;
        }

        public void parentChanged(INavigationNode<?> source) {
            this.parentChangedCalled = true;
        }

        public void presentationChanged(INavigationNode<?> source) {
        }

        public void selectedChanged(INavigationNode<?> source) {
        }

        public void stateChanged(INavigationNode<?> source, INavigationNode.State oldState, INavigationNode.State newState) {
        }

        public boolean isMarkersChangedCalled() {
            return this.markersChangedCalled;
        }

        public boolean isChildAddedCalled() {
            return this.childAddedCalled;
        }

        public boolean isChildRemovedCalled() {
            return this.childRemovedCalled;
        }

        public boolean checkChildClass(Class<?> childClass) {
            return super.checkChildClass(childClass);
        }

        public boolean isPreparedCalled() {
            return this.preparedCalled;
        }

        public boolean isFilterRemovedCalled() {
            return this.filterRemovedCalled;
        }

        public boolean isFilterAddedCalled() {
            return this.filterAddedCalled;
        }

        public boolean isParentChangedCalled() {
            return this.parentChangedCalled;
        }

        public boolean isParentChangedCalledAfterChildAddedCalled() {
            return this.parentChangedCalledAfterChildAddedCalled;
        }

        public boolean isNodeIdChangeCalled() {
            return this.nodeIdChangeCalled;
        }

        public void nodeIdChange(INavigationNode<?> source, NavigationNodeId oldId, NavigationNodeId newId) {
            this.nodeIdChangeCalled = true;
        }
    }

    private class SetBlockCalledDetector
    extends SimpleNavigationNodeAdapter {
        private boolean blockedCalled;

        private SetBlockCalledDetector() {
        }

        public void block(INavigationNode<?> source, boolean block) {
            super.block(source, block);
            this.blockedCalled = true;
            System.out.println("NavigationNodeTest.SetBlockCalledDetector.block()");
        }
    }
}

