/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationAssembler;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.NavigationProcessorTest;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeProvider;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.model.TestSecondModuleGroupNodeAssembler;
import org.eclipse.riena.navigation.model.TestSecondSubApplicationNodeAssembler;

@NonUITestCase
public class NavigationProcessorTest2
extends RienaTestCase {
    private static final String TARGET_MODULE_GROUP = "org.eclipse.riena.navigation.model.test.moduleGroup.2";
    private NavigationProcessor navigationProcessor;
    private IApplicationNode applicationNode;
    private ISubApplicationNode subApplication;
    private IModuleGroupNode moduleGroup;
    private IModuleNode module;
    private ISubModuleNode subModule1;
    private ISubModuleNode subModule2;
    private ISubModuleNode subModule3;
    private NavigationProcessorTest.TestSubModuleNode subModule4;
    private NodeProviderMock nodeProviderMock;
    private ModuleGroupNode moduleGroup2;
    private ModuleNode module2;

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeProviderMock = new NodeProviderMock();
        this.initializeNavigationStructure();
    }

    private void initializeNavigationStructure() {
        this.applicationNode = new ApplicationNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.application"));
        this.navigationProcessor = new NavigationProcessor(){

            protected INavigationNodeProvider getNavigationNodeProvider() {
                return NavigationProcessorTest2.this.nodeProviderMock;
            }
        };
        this.applicationNode.setNavigationProcessor((INavigationProcessor)this.navigationProcessor);
        this.subApplication = new SubApplicationNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subApplication"));
        this.applicationNode.addChild((INavigationNode)this.subApplication);
        this.moduleGroup = new ModuleGroupNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.moduleGroup"));
        this.subApplication.addChild((INavigationNode)this.moduleGroup);
        this.moduleGroup2 = new ModuleGroupNode(new NavigationNodeId(TARGET_MODULE_GROUP));
        this.subApplication.addChild((INavigationNode)this.moduleGroup2);
        this.module = new ModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.module"));
        this.moduleGroup.addChild((INavigationNode)this.module);
        this.module2 = new ModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.module.2"));
        this.moduleGroup.addChild((INavigationNode)this.module2);
        this.subModule1 = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule"));
        this.module.addChild((INavigationNode)this.subModule1);
        this.subModule2 = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule2"));
        this.module.addChild((INavigationNode)this.subModule2);
        this.subModule3 = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule3"));
        this.module.addChild((INavigationNode)this.subModule3);
        this.subModule4 = new NavigationProcessorTest.TestSubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule4"));
        this.module2.addChild((INavigationNode)this.subModule4);
    }

    protected void tearDown() throws Exception {
        this.applicationNode = null;
        super.tearDown();
    }

    public void testNavigate() throws Exception {
        this.subModule1.activate();
        System.err.println("NODE: " + this.applicationNode);
        NavigationProcessorTest2.assertEquals((int)1, (int)this.applicationNode.getChildren().size());
        NavigationProcessorTest2.assertTrue((boolean)this.subApplication.isActivated());
        this.subModule1.navigate(new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"));
        NavigationProcessorTest2.assertEquals((int)2, (int)this.applicationNode.getChildren().size());
        NavigationProcessorTest2.assertFalse((boolean)this.subApplication.isActivated());
        ISubApplicationNode secondSubApplication = (ISubApplicationNode)this.applicationNode.getChild(1);
        NavigationProcessorTest2.assertEquals((Object)new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondSubApplication"), (Object)secondSubApplication.getNodeId());
        NavigationProcessorTest2.assertTrue((boolean)secondSubApplication.isActivated());
        NavigationProcessorTest2.assertEquals((int)1, (int)secondSubApplication.getChildren().size());
        IModuleGroupNode secondModuleGroup = (IModuleGroupNode)secondSubApplication.getChild(0);
        NavigationProcessorTest2.assertEquals((Object)new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"), (Object)secondModuleGroup.getNodeId());
        NavigationProcessorTest2.assertTrue((boolean)secondModuleGroup.isActivated());
        IModuleNode secondModule = (IModuleNode)secondModuleGroup.getChild(0);
        ISubModuleNode secondSubModule = (ISubModuleNode)secondModule.getChild(0);
        NavigationProcessorTest2.assertTrue((boolean)secondSubModule.isActivated());
        secondSubModule.navigateBack();
        NavigationProcessorTest2.assertFalse((boolean)secondSubApplication.isActivated());
        NavigationProcessorTest2.assertFalse((boolean)secondSubModule.isActivated());
        NavigationProcessorTest2.assertTrue((boolean)this.subApplication.isActivated());
        NavigationProcessorTest2.assertTrue((boolean)this.subModule1.isActivated());
        this.subModule1.navigate(new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"));
        NavigationProcessorTest2.assertFalse((boolean)this.subApplication.isActivated());
        NavigationProcessorTest2.assertFalse((boolean)this.subModule1.isActivated());
        NavigationProcessorTest2.assertEquals((int)2, (int)this.applicationNode.getChildren().size());
        NavigationProcessorTest2.assertSame((Object)secondSubApplication, (Object)this.applicationNode.getChild(1));
        NavigationProcessorTest2.assertTrue((boolean)secondSubApplication.isActivated());
        NavigationProcessorTest2.assertEquals((int)1, (int)secondSubApplication.getChildren().size());
        NavigationProcessorTest2.assertSame((Object)secondModuleGroup, (Object)secondSubApplication.getChild(0));
        NavigationProcessorTest2.assertTrue((boolean)secondModuleGroup.isActivated());
        NavigationProcessorTest2.assertTrue((boolean)secondSubModule.isActivated());
    }

    public void testCreate() throws Exception {
        INavigationNode targetNode = this.navigationProcessor.create((INavigationNode)this.module, new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule"), null);
        NavigationProcessorTest2.assertEquals((Object)this.subModule1, (Object)targetNode);
        targetNode = this.navigationProcessor.create((INavigationNode)this.applicationNode, new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"), null);
        NavigationProcessorTest2.assertEquals((String)"org.eclipse.riena.navigation.model.test.secondModuleGroup", (String)targetNode.getNodeId().getTypeId());
    }

    final class NodeProviderMock
    extends SimpleNavigationNodeProvider {
        private NodeProviderMock() {
            this.initAssemblers();
        }

        private void initAssemblers() {
            this.registerNavigationAssembler("1", (INavigationAssembler)new TestSecondSubApplicationNodeAssembler(){

                @Override
                public String getParentNodeId() {
                    return "org.eclipse.riena.navigation.model.test.application";
                }
            });
            this.registerNavigationAssembler("2", (INavigationAssembler)new TestSecondModuleGroupNodeAssembler(){

                public String getParentNodeId() {
                    return "org.eclipse.riena.navigation.model.test.secondSubApplication";
                }
            });
        }
    }
}

