/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import junit.framework.TestCase;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.ComboRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.EmbeddedTitleBarRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MultipleChoiceRidget;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@NonUITestCase
public class SubModuleControllerTest
extends TestCase {
    public void testRestoreFocusFromRidgetAfterBlock() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.pack();
        shell.setVisible(true);
        Realm realm = SWTObservables.getRealm((Display)display);
        SubModuleControllerTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        SubModuleNode node = new SubModuleNode();
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubModuleController controller = new SubModuleController((ISubModuleNode)node);
        LabelRidget labelRidget = new LabelRidget();
        labelRidget.setRetryRequestFocus(true);
        controller.addRidget("label", (IRidget)labelRidget);
        controller.setBlocked(true);
        labelRidget.setRetryRequestFocus(true);
        controller.setBlocked(false);
        SubModuleControllerTest.assertFalse((boolean)labelRidget.isRetryRequestFocus());
        SwtUtilities.dispose((Widget)shell);
    }

    public void testGetFullTitle() {
        ModuleNode module = new ModuleNode("m");
        new ModuleController((IModuleNode)module);
        SubModuleNode subModule1 = new SubModuleNode(new NavigationNodeId("sm", "sm1"), "sm1");
        subModule1.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule1);
        MySubModuleController smController1 = new MySubModuleController((ISubModuleNode)subModule1);
        SubModuleControllerTest.assertEquals((String)"m", (String)smController1.getFullTitle());
        module.setPresentSingleSubModule(true);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        SubModuleNode subModule2 = new SubModuleNode(new NavigationNodeId("sm", "sm2"), "sm2");
        MySubModuleController smController2 = new MySubModuleController((ISubModuleNode)subModule2);
        subModule2.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule2);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        SubModuleControllerTest.assertEquals((String)"m - sm2", (String)smController2.getFullTitle());
        module.setPresentSingleSubModule(false);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        SubModuleControllerTest.assertEquals((String)"m - sm2", (String)smController2.getFullTitle());
        SubModuleNode subModule3 = new SubModuleNode(new NavigationNodeId("sm", "sm3"), "sm3");
        MySubModuleController smController3 = new MySubModuleController((ISubModuleNode)subModule3);
        subModule3.setParent((INavigationNode)subModule1);
        subModule1.addChild((INavigationNode)subModule3);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        SubModuleControllerTest.assertEquals((String)"m - sm2", (String)smController2.getFullTitle());
        SubModuleControllerTest.assertEquals((String)"m - sm1 - sm3", (String)smController3.getFullTitle());
    }

    public void testUpdateIcon() {
        EmbeddedTitleBarRidget windowRidget = new EmbeddedTitleBarRidget();
        ModuleNode module = new ModuleNode("m");
        module.setIcon("mIcon");
        new ModuleController((IModuleNode)module);
        SubModuleNode subModule1 = new SubModuleNode(new NavigationNodeId("sm", "sm1"), "sm1");
        subModule1.setIcon("sm1Icon");
        subModule1.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule1);
        MySubModuleController smController1 = new MySubModuleController((ISubModuleNode)subModule1);
        smController1.updateIcon((IWindowRidget)windowRidget);
        SubModuleControllerTest.assertEquals((String)"mIcon", (String)windowRidget.getIcon());
        module.setPresentSingleSubModule(true);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        smController1.updateIcon((IWindowRidget)windowRidget);
        SubModuleControllerTest.assertEquals((String)"sm1Icon", (String)windowRidget.getIcon());
        SubModuleNode subModule2 = new SubModuleNode(new NavigationNodeId("sm", "sm2"), "sm2");
        subModule2.setIcon("sm2Icon");
        MySubModuleController smController2 = new MySubModuleController((ISubModuleNode)subModule2);
        subModule2.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule2);
        smController1.updateIcon((IWindowRidget)windowRidget);
        SubModuleControllerTest.assertEquals((String)"sm1Icon", (String)windowRidget.getIcon());
        smController2.updateIcon((IWindowRidget)windowRidget);
        SubModuleControllerTest.assertEquals((String)"sm2Icon", (String)windowRidget.getIcon());
    }

    public void testIsInvisibleInTree() {
        SubModuleNode subModule1 = new SubModuleNode(new NavigationNodeId("sm", "sm1"), "sm1");
        SubModuleController smController1 = new SubModuleController((ISubModuleNode)subModule1);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController1, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertFalse((boolean)ret);
        ModuleNode module = new ModuleNode("m");
        new ModuleController((IModuleNode)module);
        subModule1.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule1);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController1, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertTrue((boolean)ret);
        module.setPresentSingleSubModule(true);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController1, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertFalse((boolean)ret);
        module.setPresentSingleSubModule(false);
        SubModuleNode subModule2 = new SubModuleNode(new NavigationNodeId("sm", "sm2"), "sm2");
        subModule2.setIcon("sm2Icon");
        SubModuleController smController2 = new SubModuleController((ISubModuleNode)subModule2);
        subModule2.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule2);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController1, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertFalse((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController2, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertFalse((boolean)ret);
    }

    public void testUpdateAllRidgetsFromModel() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.pack();
        shell.setVisible(true);
        Realm realm = SWTObservables.getRealm((Display)display);
        SubModuleControllerTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        SubModuleNode node = new SubModuleNode();
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        SubModuleController controller = new SubModuleController((ISubModuleNode)node);
        LabelRidget labelRidget = new LabelRidget();
        controller.addRidget("label", (IRidget)labelRidget);
        SubModuleControllerTest.assertNotNull((Object)controller.getRidgets());
        SubModuleControllerTest.assertEquals((int)1, (int)controller.getRidgets().size());
        ComboRidget comboRidget = new ComboRidget();
        controller.addRidget("combo ridget", (IRidget)comboRidget);
        SubModuleControllerTest.assertNotNull((Object)controller.getRidgets());
        SubModuleControllerTest.assertEquals((int)2, (int)controller.getRidgets().size());
        try {
            controller.updateAllRidgetsFromModel();
        }
        catch (BindingException e) {
            SubModuleControllerTest.fail((String)("unexpected BindingException: " + e.getMessage()));
        }
        MultipleChoiceRidget multipleChoiceRidget = new MultipleChoiceRidget();
        controller.addRidget("multi choice ridget", (IRidget)multipleChoiceRidget);
        SubModuleControllerTest.assertNotNull((Object)controller.getRidgets());
        SubModuleControllerTest.assertEquals((int)3, (int)controller.getRidgets().size());
        multipleChoiceRidget.setIgnoreBindingError(false);
        try {
            controller.updateAllRidgetsFromModel();
            SubModuleControllerTest.fail((String)"BindingException expected!");
        }
        catch (BindingException bindingException) {
            Nop.reason((String)"BindingException is expected");
        }
        multipleChoiceRidget.setIgnoreBindingError(true);
        try {
            controller.updateAllRidgetsFromModel();
        }
        catch (BindingException e) {
            SubModuleControllerTest.fail((String)("unexpected BindingException: " + e.getMessage()));
        }
        SwtUtilities.dispose((Widget)shell);
    }

    private static class MySubModuleController
    extends SubModuleController {
        public MySubModuleController(ISubModuleNode navigationNode) {
            super(navigationNode);
        }

        public String getFullTitle() {
            return super.getFullTitle();
        }

        public void updateIcon(IWindowRidget windowRidget) {
            super.updateIcon(windowRidget);
        }
    }
}

