/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubModuleTreeItemMarkerRenderer;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.IIconizableMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class SubModuleTreeItemMarkerRendererTest
extends RienaTestCase {
    private Shell shell;
    private GC gc;
    private TreeItem item;
    private RienaDefaultLnf originalLnf;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        Tree tree = new Tree((Composite)this.shell, 0);
        this.item = new TreeItem(tree, 0);
        this.gc = new GC((Drawable)tree);
        this.originalLnf = LnfManager.getLnf();
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
        LnfManager.getLnf().initialize();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.gc.dispose();
        this.gc = null;
        SwtUtilities.dispose((Widget)this.shell);
        LnfManager.setLnf((RienaDefaultLnf)this.originalLnf);
    }

    public void testPaint() {
        MockRenderer renderer = new MockRenderer();
        renderer.setBounds(0, 0, 100, 100);
        try {
            renderer.paint(this.gc, null);
            SubModuleTreeItemMarkerRendererTest.fail((String)"AssertionFailedException expected");
        }
        catch (AssertionFailedException assertionFailedException) {
            this.ok("AssertionFailedException expected");
        }
        try {
            renderer.paint(this.gc, this.shell);
            SubModuleTreeItemMarkerRendererTest.fail((String)"AssertionFailedException expected");
        }
        catch (AssertionFailedException assertionFailedException) {
            this.ok("AssertionFailedException expected");
        }
        try {
            renderer.paint(null, this.item);
            SubModuleTreeItemMarkerRendererTest.fail((String)"AssertionFailedException expected");
        }
        catch (AssertionFailedException assertionFailedException) {
            this.ok("AssertionFailedException expected");
        }
        renderer.resetPaintMarkersCalled();
        renderer.paint(this.gc, this.item);
        SubModuleTreeItemMarkerRendererTest.assertFalse((boolean)renderer.isPaintMarkersCalled());
        SubModuleNode node = new SubModuleNode();
        node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        renderer.setMarkers(node.getMarkers());
        renderer.resetPaintMarkersCalled();
        renderer.paint(this.gc, this.item);
        SubModuleTreeItemMarkerRendererTest.assertFalse((boolean)renderer.isPaintMarkersCalled());
        node.addMarker((IMarker)new ErrorMarker());
        renderer.setMarkers(node.getMarkers());
        renderer.resetPaintMarkersCalled();
        renderer.paint(this.gc, this.item);
        SubModuleTreeItemMarkerRendererTest.assertTrue((boolean)renderer.isPaintMarkersCalled());
        node.removeAllMarkers();
        node.addMarker((IMarker)new NegativeMarker());
        renderer.setMarkers(node.getMarkers());
        renderer.resetPaintMarkersCalled();
        renderer.paint(this.gc, this.item);
        SubModuleTreeItemMarkerRendererTest.assertFalse((boolean)renderer.isPaintMarkersCalled());
        renderer.dispose();
    }

    public void testPaintMarkers() throws Exception {
        this.item.setImage(this.createItemImage());
        SubModuleTreeItemMarkerRenderer renderer = new SubModuleTreeItemMarkerRenderer();
        renderer.setBounds(0, 0, 100, 25);
        ArrayList<IIconizableMarker> markers = new ArrayList<IIconizableMarker>();
        byte[] noMarkersBytes = this.paintMarker(renderer, markers, this.item);
        byte[] paintBytes = this.paintMarker(renderer, markers, this.item);
        SubModuleTreeItemMarkerRendererTest.assertTrue((boolean)Arrays.equals(noMarkersBytes, paintBytes));
        markers.add((IIconizableMarker)new ErrorMarker());
        paintBytes = this.paintMarker(renderer, markers, this.item);
        SubModuleTreeItemMarkerRendererTest.assertFalse((boolean)Arrays.equals(noMarkersBytes, paintBytes));
        this.item.setImage(null);
        paintBytes = this.paintMarker(renderer, markers, this.item);
        SubModuleTreeItemMarkerRendererTest.assertTrue((boolean)Arrays.equals(noMarkersBytes, paintBytes));
        renderer.dispose();
    }

    public void testPaintMarkersHierarchically() throws Exception {
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf(){

            protected void initializeTheme() {
                super.initializeTheme();
                this.putLnfSetting("subModuleTreePaintMarkerInHierarchicOrder", IIconizableMarker.MarkerPosition.BOTTOM_RIGHT);
            }
        });
        this.item.setImage(this.createItemImage());
        SubModuleTreeItemMarkerRenderer renderer = new SubModuleTreeItemMarkerRenderer();
        renderer.setBounds(0, 0, 100, 25);
        ArrayList<IIconizableMarker> markers = new ArrayList<IIconizableMarker>();
        byte[] noMarkersBytes = this.paintMarker(renderer, markers, this.item);
        markers.add((IIconizableMarker)new ErrorMarker());
        byte[] errorMarkersBytes = this.paintMarker(renderer, markers, this.item);
        SubModuleTreeItemMarkerRendererTest.assertFalse((boolean)Arrays.equals(noMarkersBytes, errorMarkersBytes));
        markers.add((IIconizableMarker)new MandatoryMarker());
        byte[] paintBytes = this.paintMarker(renderer, markers, this.item);
        SubModuleTreeItemMarkerRendererTest.assertTrue((boolean)Arrays.equals(errorMarkersBytes, paintBytes));
        markers.clear();
        markers.add((IIconizableMarker)new MandatoryMarker());
        paintBytes = this.paintMarker(renderer, markers, this.item);
        SubModuleTreeItemMarkerRendererTest.assertFalse((boolean)Arrays.equals(noMarkersBytes, paintBytes));
        SubModuleTreeItemMarkerRendererTest.assertFalse((boolean)Arrays.equals(errorMarkersBytes, paintBytes));
        this.item.setImage(null);
        paintBytes = this.paintMarker(renderer, markers, this.item);
        SubModuleTreeItemMarkerRendererTest.assertTrue((boolean)Arrays.equals(noMarkersBytes, paintBytes));
        renderer.dispose();
    }

    private byte[] paintMarker(SubModuleTreeItemMarkerRenderer renderer, Collection<IIconizableMarker> markers, TreeItem item) {
        Image paintImage = new Image((Device)this.shell.getDisplay(), new Rectangle(0, 0, 10, 10));
        GC paintGC = new GC((Drawable)paintImage);
        ReflectionUtils.invokeHidden((Object)renderer, (String)"paintMarkers", (Object[])new Object[]{paintGC, markers, item});
        byte[] paintBytes = paintImage.getImageData().data;
        paintGC.dispose();
        SwtUtilities.dispose((Resource)paintImage);
        return paintBytes;
    }

    public void testCalcMarkerCoordinates() {
        SubModuleTreeItemMarkerRenderer renderer = new SubModuleTreeItemMarkerRenderer();
        renderer.setBounds(2, 3, 100, 25);
        Image itemImage = this.createItemImage();
        Image markerImage = this.createMarkerImage();
        Point pos = (Point)ReflectionUtils.invokeHidden((Object)renderer, (String)"calcMarkerCoordinates", (Object[])new Object[]{itemImage, markerImage, IIconizableMarker.MarkerPosition.TOP_LEFT});
        SubModuleTreeItemMarkerRendererTest.assertEquals((int)2, (int)pos.x);
        SubModuleTreeItemMarkerRendererTest.assertEquals((int)3, (int)pos.y);
        pos = (Point)ReflectionUtils.invokeHidden((Object)renderer, (String)"calcMarkerCoordinates", (Object[])new Object[]{itemImage, markerImage, IIconizableMarker.MarkerPosition.TOP_RIGHT});
        SubModuleTreeItemMarkerRendererTest.assertEquals((int)7, (int)pos.x);
        SubModuleTreeItemMarkerRendererTest.assertEquals((int)3, (int)pos.y);
        pos = (Point)ReflectionUtils.invokeHidden((Object)renderer, (String)"calcMarkerCoordinates", (Object[])new Object[]{itemImage, markerImage, IIconizableMarker.MarkerPosition.BOTTOM_LEFT});
        SubModuleTreeItemMarkerRendererTest.assertEquals((int)2, (int)pos.x);
        SubModuleTreeItemMarkerRendererTest.assertEquals((int)8, (int)pos.y);
        pos = (Point)ReflectionUtils.invokeHidden((Object)renderer, (String)"calcMarkerCoordinates", (Object[])new Object[]{itemImage, markerImage, IIconizableMarker.MarkerPosition.BOTTOM_RIGHT});
        SubModuleTreeItemMarkerRendererTest.assertEquals((int)7, (int)pos.x);
        SubModuleTreeItemMarkerRendererTest.assertEquals((int)8, (int)pos.y);
        SwtUtilities.dispose((Resource)itemImage);
        SwtUtilities.dispose((Resource)markerImage);
    }

    private Image createItemImage() {
        Image image = new Image((Device)this.shell.getDisplay(), new Rectangle(0, 0, 10, 10));
        GC imageGC = new GC((Drawable)image);
        imageGC.setForeground(LnfManager.getLnf().getColor("green"));
        imageGC.setBackground(LnfManager.getLnf().getColor("green"));
        imageGC.fillRectangle(0, 0, 5, 5);
        imageGC.dispose();
        return image;
    }

    private Image createMarkerImage() {
        Image image = new Image((Device)this.shell.getDisplay(), new Rectangle(0, 0, 5, 5));
        GC imageGC = new GC((Drawable)image);
        imageGC.setForeground(LnfManager.getLnf().getColor("red"));
        imageGC.setBackground(LnfManager.getLnf().getColor("red"));
        imageGC.fillRectangle(0, 0, 3, 3);
        imageGC.dispose();
        return image;
    }

    private Image createMandatoraMarkerImage() {
        Image image = new Image((Device)this.shell.getDisplay(), new Rectangle(0, 0, 5, 5));
        GC imageGC = new GC((Drawable)image);
        imageGC.setForeground(LnfManager.getLnf().getColor("green"));
        imageGC.setBackground(LnfManager.getLnf().getColor("green"));
        imageGC.fillRectangle(0, 0, 2, 2);
        imageGC.dispose();
        return image;
    }

    private static class MockRenderer
    extends SubModuleTreeItemMarkerRenderer {
        private boolean paintMarkersCalled;

        public MockRenderer() {
            this.resetPaintMarkersCalled();
        }

        public boolean isPaintMarkersCalled() {
            return this.paintMarkersCalled;
        }

        public void resetPaintMarkersCalled() {
            this.paintMarkersCalled = false;
        }

        protected void paintMarkers(GC gc, Collection<IIconizableMarker> markers, TreeItem item) {
            super.paintMarkers(gc, markers, item);
            this.paintMarkersCalled = true;
        }
    }

    private class MyLnf
    extends RienaDefaultLnf {
        private final Image errorImage;
        private final Image mandatoryImage;

        public MyLnf() {
            this.errorImage = SubModuleTreeItemMarkerRendererTest.this.createMarkerImage();
            this.mandatoryImage = SubModuleTreeItemMarkerRendererTest.this.createMandatoraMarkerImage();
        }

        public Image getImage(String key) {
            if (key.equals("ErrorMarker")) {
                return this.errorImage;
            }
            return this.mandatoryImage;
        }
    }
}

