/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemRidget;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.swt.component.IEntriesProvider;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.views.SubApplicationView;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractRidgetController;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPageLayout;

@UITestCase
public class SubApplicationViewTest
extends TestCase {
    private Shell shell;
    private TestSubApplicationView view;
    private SubApplicationNode node;

    protected void setUp() throws Exception {
        this.view = new TestSubApplicationView();
        this.shell = new Shell();
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        locator.setBindingProperty((Object)this.shell, "applicationWindow");
        this.node = new SubApplicationNode();
        this.node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        this.view.bind(this.node);
    }

    protected void tearDown() throws Exception {
        this.view = null;
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testGetItemId() {
        Menu menu = new Menu((Control)this.shell);
        MenuItem item = new MenuItem(menu, 0);
        String id = (String)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getItemId", (Object[])new Object[]{item});
        SubApplicationViewTest.assertNotNull((Object)id);
        SubApplicationViewTest.assertEquals((String)"1", (String)id);
        id = (String)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getItemId", (Object[])new Object[]{item});
        SubApplicationViewTest.assertNotNull((Object)id);
        SubApplicationViewTest.assertEquals((String)"2", (String)id);
        MyContributionItem contributionItem = new MyContributionItem();
        contributionItem.setId("4711");
        item.setData((Object)contributionItem);
        id = (String)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getItemId", (Object[])new Object[]{item});
        SubApplicationViewTest.assertNotNull((Object)id);
        SubApplicationViewTest.assertEquals((String)"menuAction.4711", (String)id);
        MenuItem item2 = new MenuItem(menu, 0);
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        locator.setBindingProperty((Object)item2, "0815");
        id = (String)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getItemId", (Object[])new Object[]{item2});
        SubApplicationViewTest.assertNotNull((Object)id);
        SubApplicationViewTest.assertEquals((String)"menuAction.0815", (String)id);
    }

    public void testGetMenuCoolBarComposites() {
        Composite comp1 = new Composite((Composite)this.shell, 0);
        List composites = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getMenuCoolBarComposites", (Object[])new Object[]{this.shell});
        SubApplicationViewTest.assertNotNull((Object)composites);
        SubApplicationViewTest.assertTrue((boolean)composites.isEmpty());
        IEntriesProvider entriesProvider = new IEntriesProvider(){

            public IContributionItem[] getTopLevelEntries() {
                return new IContributionItem[0];
            }
        };
        MenuCoolBarComposite menuComposite = new MenuCoolBarComposite(comp1, 0, entriesProvider);
        composites = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getMenuCoolBarComposites", (Object[])new Object[]{this.shell});
        SubApplicationViewTest.assertNotNull((Object)composites);
        SubApplicationViewTest.assertFalse((boolean)composites.isEmpty());
        SubApplicationViewTest.assertEquals((int)1, (int)composites.size());
        SubApplicationViewTest.assertSame((Object)menuComposite, composites.get(0));
    }

    public void testGetCoolBars() {
        Composite comp1 = new Composite((Composite)this.shell, 0);
        List coolBars = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getCoolBars", (Object[])new Object[]{this.shell});
        SubApplicationViewTest.assertNotNull((Object)coolBars);
        SubApplicationViewTest.assertTrue((boolean)coolBars.isEmpty());
        IEntriesProvider entriesProvider = new IEntriesProvider(){

            public IContributionItem[] getTopLevelEntries() {
                return new IContributionItem[0];
            }
        };
        new MenuCoolBarComposite(comp1, 0, entriesProvider);
        coolBars = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getCoolBars", (Object[])new Object[]{this.shell});
        SubApplicationViewTest.assertNotNull((Object)coolBars);
        SubApplicationViewTest.assertTrue((boolean)coolBars.isEmpty());
        CoolBar coolBar = new CoolBar(comp1, 0);
        coolBars = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getCoolBars", (Object[])new Object[]{this.shell});
        SubApplicationViewTest.assertNotNull((Object)coolBars);
        SubApplicationViewTest.assertFalse((boolean)coolBars.isEmpty());
        SubApplicationViewTest.assertEquals((int)1, (int)coolBars.size());
        SubApplicationViewTest.assertSame((Object)coolBar, coolBars.get(0));
    }

    public void testGetToolBars() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        List toolBars = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getToolBars", (Object[])new Object[]{coolBar});
        SubApplicationViewTest.assertNotNull((Object)toolBars);
        SubApplicationViewTest.assertTrue((boolean)toolBars.isEmpty());
        ToolBar toolBar = new ToolBar((Composite)coolBar, 0);
        ToolBar toolBar2 = new ToolBar((Composite)coolBar, 0);
        toolBars = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getToolBars", (Object[])new Object[]{coolBar});
        SubApplicationViewTest.assertNotNull((Object)toolBars);
        SubApplicationViewTest.assertFalse((boolean)toolBars.isEmpty());
        SubApplicationViewTest.assertEquals((int)2, (int)toolBars.size());
        SubApplicationViewTest.assertSame((Object)toolBar, toolBars.get(0));
        SubApplicationViewTest.assertSame((Object)toolBar2, toolBars.get(1));
    }

    public void testGetAllToolItems() {
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        ToolBar toolBar = new ToolBar((Composite)coolBar, 0);
        ToolBar toolBar2 = new ToolBar((Composite)coolBar, 0);
        List items = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getAllToolItems", (Object[])new Object[0]);
        SubApplicationViewTest.assertNotNull((Object)items);
        SubApplicationViewTest.assertTrue((boolean)items.isEmpty());
        ToolItem item = new ToolItem(toolBar, 0);
        ToolItem item2 = new ToolItem(toolBar2, 0);
        items = (List)ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"getAllToolItems", (Object[])new Object[0]);
        SubApplicationViewTest.assertNotNull((Object)items);
        SubApplicationViewTest.assertFalse((boolean)items.isEmpty());
        SubApplicationViewTest.assertEquals((int)2, (int)items.size());
        SubApplicationViewTest.assertSame((Object)item, items.get(0));
        SubApplicationViewTest.assertSame((Object)item2, items.get(1));
    }

    public void testCreateRidgetItem() {
        Controller controller = new Controller();
        Menu menu = new Menu((Control)this.shell);
        MenuItem menuItem = new MenuItem(menu, 0);
        MyContributionItem contributionItem = new MyContributionItem();
        contributionItem.setId("4711");
        menuItem.setData((Object)contributionItem);
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"createRidget", (Object[])new Object[]{controller, menuItem});
        SubApplicationViewTest.assertFalse((boolean)controller.getRidgets().isEmpty());
        SubApplicationViewTest.assertEquals((int)1, (int)controller.getRidgets().size());
        IRidget ridget = controller.getRidget("menuAction.4711");
        SubApplicationViewTest.assertNotNull((Object)ridget);
        SubApplicationViewTest.assertTrue((boolean)(ridget instanceof MenuItemRidget));
        SubApplicationViewTest.assertEquals((String)"menuAction.4711", (String)SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)menuItem));
        CoolBar coolBar = new CoolBar((Composite)this.shell, 0);
        ToolBar toolBar = new ToolBar((Composite)coolBar, 0);
        ToolItem toolItem = new ToolItem(toolBar, 0);
        contributionItem = new MyContributionItem();
        contributionItem.setId("0815");
        toolItem.setData((Object)contributionItem);
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"createRidget", (Object[])new Object[]{controller, toolItem});
        SubApplicationViewTest.assertFalse((boolean)controller.getRidgets().isEmpty());
        SubApplicationViewTest.assertEquals((int)2, (int)controller.getRidgets().size());
        ridget = controller.getRidget("toolbarAction.0815");
        SubApplicationViewTest.assertNotNull((Object)ridget);
        SubApplicationViewTest.assertTrue((boolean)(ridget instanceof ToolItemRidget));
        SubApplicationViewTest.assertEquals((String)"toolbarAction.0815", (String)SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)toolItem));
    }

    public void testCreateRidgetMenu() {
        Controller controller = new Controller();
        Menu menu = new Menu((Control)this.shell);
        MenuItem item = new MenuItem(menu, 0);
        MyContributionItem contributionItem = new MyContributionItem();
        contributionItem.setId("4711");
        item.setData((Object)contributionItem);
        ReflectionUtils.invokeHidden((Object)((Object)this.view), (String)"createRidget", (Object[])new Object[]{controller, menu});
        SubApplicationViewTest.assertFalse((boolean)controller.getRidgets().isEmpty());
        SubApplicationViewTest.assertEquals((int)1, (int)controller.getRidgets().size());
        IRidget ridget = controller.getRidget("menuAction.4711");
        SubApplicationViewTest.assertNotNull((Object)ridget);
        SubApplicationViewTest.assertTrue((boolean)(ridget instanceof MenuItemRidget));
        SubApplicationViewTest.assertEquals((String)"menuAction.4711", (String)SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)item));
    }

    public void testUnbind() throws Exception {
        List listeners = (List)ReflectionUtils.getHidden((Object)this.node, (String)"listeners");
        SubApplicationViewTest.assertEquals((int)1, (int)listeners.size());
        this.node.dispose();
        SubApplicationViewTest.assertTrue((boolean)listeners.isEmpty());
    }

    public void testDisposeHandling() throws Exception {
        this.node.setNavigationNodeController((INavigationNodeController)new SubApplicationController((ISubApplicationNode)this.node));
        ModuleGroupNode mg = new ModuleGroupNode();
        this.node.addChild((INavigationNode)mg);
        ModuleNode m = new ModuleNode();
        mg.addChild((INavigationNode)m);
        this.view.createInitialLayout(null);
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("x"));
        m.addChild((INavigationNode)sm1);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("y"));
        m.addChild((INavigationNode)sm2);
        SubModuleNode sm3 = new SubModuleNode(new NavigationNodeId("z"));
        m.addChild((INavigationNode)sm3);
        this.view.viewUserCount = 1;
        this.view.providedId = new SwtViewId("test:test");
        this.view.hiddenId = null;
        sm1.dispose();
        SubApplicationViewTest.assertSame((Object)this.view.providedId, (Object)this.view.hiddenId);
        this.view.viewUserCount = 0;
        this.view.providedId = new SwtViewId("test:SHARED");
        this.view.hiddenId = null;
        sm2.dispose();
        SubApplicationViewTest.assertSame((Object)this.view.providedId, (Object)this.view.hiddenId);
        this.view.viewUserCount = 1;
        this.view.providedId = new SwtViewId("test:SHARED");
        this.view.hiddenId = null;
        sm2.dispose();
        SubApplicationViewTest.assertSame(null, (Object)this.view.hiddenId);
    }

    private static class Controller
    extends AbstractRidgetController {
        private Controller() {
        }

        public void configureRidgets() {
        }
    }

    private static class MyContributionItem
    extends ContributionItem {
        private MyContributionItem() {
        }
    }

    private class TestSubApplicationView
    extends SubApplicationView {
        int viewUserCount = 0;
        SwtViewId hiddenId = null;
        SwtViewId providedId = null;

        private TestSubApplicationView() {
        }

        public SubApplicationNode getNavigationNode() {
            return SubApplicationViewTest.this.node;
        }

        protected int getViewUserCount(SwtViewId id) {
            return this.viewUserCount;
        }

        protected void hideView(SwtViewId id) {
            this.hiddenId = id;
        }

        protected void doBaseLayout(IPageLayout layout) {
        }

        protected ISubApplicationNode locateSubApplication(IPageLayout layout) {
            return SubApplicationViewTest.this.node;
        }

        protected SwtViewId getViewId(ISubModuleNode node) {
            return this.providedId;
        }
    }
}

