/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;
import org.eclipse.riena.ui.ridgets.databinding.GregorianCalendarToStringConverter;
import org.eclipse.riena.ui.ridgets.databinding.RidgetUpdateValueStrategy;
import org.eclipse.riena.ui.ridgets.databinding.StringToGregorianCalendarConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToNumberAllowingNullConverter;

@NonUITestCase
public class RidgetUpdateValueStrategyTest
extends TestCase {
    public void testCreateConverter() throws Exception {
        RidgetUpdateValueStrategy strategy = new RidgetUpdateValueStrategy(new ValueBindingSupport((IObservableValue)EasyMock.createNiceMock(IObservableValue.class)));
        IConverter converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, Double.TYPE});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToNumberAllowingNullConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, Float.TYPE});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToNumberAllowingNullConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, Long.TYPE});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToNumberAllowingNullConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, Integer.TYPE});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToNumberAllowingNullConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, GregorianCalendar.class});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToGregorianCalendarConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{GregorianCalendar.class, String.class});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof GregorianCalendarToStringConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{Integer.class, String.class});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof NumberToStringConverter));
    }

    public void testConstructors() throws Exception {
        try {
            new RidgetUpdateValueStrategy(null);
            RidgetUpdateValueStrategyTest.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new RidgetUpdateValueStrategy(null, UpdateValueStrategy.POLICY_UPDATE);
            RidgetUpdateValueStrategyTest.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new RidgetUpdateValueStrategy(null, true, UpdateValueStrategy.POLICY_UPDATE);
            RidgetUpdateValueStrategyTest.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testValidateAfterSetWithSetError() throws Exception {
        IObservableValue mock = (IObservableValue)EasyMock.createNiceMock(IObservableValue.class);
        mock.setValue(EasyMock.anyObject());
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Something went wrong"));
        EasyMock.replay((Object[])new Object[]{mock});
        RidgetUpdateValueStrategy strategy = new RidgetUpdateValueStrategy(new ValueBindingSupport(mock)){

            protected IStatus validateAfterSet() {
                RidgetUpdateValueStrategyTest.fail((String)"This method should not be called when doSet() returns an error status.");
                return null;
            }
        };
        ReflectionUtils.invokeHidden((Object)strategy, (String)"doSet", (Object[])new Object[]{mock, "one two"});
    }

    public void testValidateAfterSetWithSetOk() throws Exception {
        final boolean[] validateAfterSetCalled = new boolean[1];
        RidgetUpdateValueStrategy strategy = new RidgetUpdateValueStrategy(new ValueBindingSupport((IObservableValue)EasyMock.createNiceMock(IObservableValue.class))){

            protected IStatus validateAfterSet() {
                validateAfterSetCalled[0] = true;
                return super.validateAfterSet();
            }
        };
        ReflectionUtils.invokeHidden((Object)strategy, (String)"doSet", (Object[])new Object[]{EasyMock.createNiceMock(IObservableValue.class), "one two"});
        RidgetUpdateValueStrategyTest.assertTrue((String)"validateAfterSet() must be called if doSet() returned an OK status.", (boolean)validateAfterSetCalled[0]);
    }
}

