/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ICustomMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IControlDecoration;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MarkerSupportTest
extends RienaTestCase {
    private static final String HIDE_DISABLED_RIDGET_CONTENT = "HIDE_DISABLED_RIDGET_CONTENT";
    private Display display;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
    }

    protected void tearDown() {
        SwtUtilities.dispose((Widget)this.shell);
        this.display = null;
    }

    public void testUpdateControlDecorationOnUpdateControl() throws Exception {
        DefaultRealm realm = new DefaultRealm();
        try {
            Text control1 = new Text((Composite)this.shell, 0);
            Text control2 = new Text((Composite)this.shell, 0);
            TextRidget ridget = new TextRidget();
            ridget.setUIControl((Object)control1);
            ridget.setErrorMarked(true);
            MarkerSupport support = (MarkerSupport)ReflectionUtils.getHidden((Object)ridget, (String)"markerSupport");
            IControlDecoration ed1 = (IControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"getOrCreateErrorDecorationForControl", (Object[])new Object[]{control1});
            ridget.setUIControl((Object)control2);
            MarkerSupportTest.assertNotSame((Object)ed1, (Object)ReflectionUtils.invokeHidden((Object)support, (String)"getOrCreateErrorDecorationForControl", (Object[])new Object[]{control2}));
        }
        finally {
            realm.dispose();
        }
    }

    public void testHideDisabledRidgetContentSystemProperty() throws IOException {
        System.clearProperty(HIDE_DISABLED_RIDGET_CONTENT);
        MarkerSupportTest.assertFalse((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
        System.setProperty(HIDE_DISABLED_RIDGET_CONTENT, Boolean.FALSE.toString());
        MarkerSupportTest.assertFalse((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
        System.setProperty(HIDE_DISABLED_RIDGET_CONTENT, Boolean.TRUE.toString());
        MarkerSupportTest.assertTrue((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
    }

    public void testCreateErrorDecoration() throws Exception {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        DefaultRealm realm = new DefaultRealm();
        try {
            Text text = new Text((Composite)this.shell, 0);
            TextRidget ridget = new TextRidget();
            ridget.setUIControl((Object)text);
            MarkerSupport support = new MarkerSupport((IBasicMarkableRidget)ridget, null);
            LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
            ControlDecoration deco = (ControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"createErrorDecoration", (Object[])new Object[]{text});
            MarkerSupportTest.assertEquals((int)100, (int)deco.getMarginWidth());
            MarkerSupportTest.assertNotNull((Object)deco.getImage());
            LnfManager.setLnf((RienaDefaultLnf)new MyNonsenseLnf());
            deco = (ControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"createErrorDecoration", (Object[])new Object[]{text});
            MarkerSupportTest.assertEquals((int)1, (int)deco.getMarginWidth());
            MarkerSupportTest.assertNotNull((Object)deco.getImage());
            support = null;
            SwtUtilities.dispose((Widget)text);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
            realm.dispose();
        }
    }

    private static boolean getHideDisabledRidgetContent() throws IOException {
        MarkSupportClassLoader freshLoader = new MarkSupportClassLoader();
        Class<?> markerSupportClass = freshLoader.getFreshMarkSupportClass();
        return (Boolean)ReflectionUtils.getHidden(markerSupportClass, (String)HIDE_DISABLED_RIDGET_CONTENT);
    }

    public void testDisabledMarker() throws Exception {
        DefaultRealm realm = new DefaultRealm();
        try {
            Text control = new Text((Composite)this.shell, 0);
            TextRidget ridget = new TextRidget();
            ridget.setUIControl((Object)control);
            BasicMarkerSupport msup = (BasicMarkerSupport)ReflectionUtils.invokeHidden((Object)ridget, (String)"createMarkerSupport", (Object[])new Object[0]);
            Object visualizer = ReflectionUtils.invokeHidden((Object)msup, (String)"getDisabledMarkerVisualizer", null);
            MarkerSupportTest.assertNotNull((Object)visualizer);
            ridget.setEnabled(false);
            MarkerSupportTest.assertEquals((int)1, (int)control.getListeners(9).length);
            ridget.setEnabled(true);
            MarkerSupportTest.assertEquals((int)0, (int)control.getListeners(9).length);
        }
        finally {
            realm.dispose();
        }
    }

    public void testClearAllMarkes() {
        DefaultRealm realm = new DefaultRealm();
        try {
            Text control = new Text((Composite)this.shell, 0);
            this.shell.setVisible(true);
            Color background = control.getBackground();
            Color foreground = control.getForeground();
            final MyMarkerSupport markerSupport = new MyMarkerSupport();
            TextRidget ridget = new TextRidget(){

                protected AbstractMarkerSupport createMarkerSupport() {
                    return markerSupport;
                }
            };
            ridget.setUIControl((Object)control);
            markerSupport.init((IBasicMarkableRidget)ridget, new PropertyChangeSupport(new Object()));
            MarkerSupportTest.assertTrue((boolean)background.equals((Object)control.getBackground()));
            ridget.addMarker((IMarker)new MandatoryMarker());
            markerSupport.updateMarkers();
            MarkerSupportTest.assertFalse((boolean)background.equals((Object)control.getBackground()));
            markerSupport.clearAllMarkers((Control)control);
            MarkerSupportTest.assertEquals((Object)background, (Object)control.getBackground());
            ridget.addMarker((IMarker)new OutputMarker());
            markerSupport.updateMarkers();
            MarkerSupportTest.assertFalse((boolean)background.equals((Object)control.getBackground()));
            markerSupport.clearAllMarkers((Control)control);
            MarkerSupportTest.assertEquals((Object)background, (Object)control.getBackground());
            ridget.addMarker((IMarker)new NegativeMarker());
            markerSupport.updateMarkers();
            MarkerSupportTest.assertFalse((boolean)foreground.equals((Object)control.getForeground()));
            markerSupport.clearAllMarkers((Control)control);
            MarkerSupportTest.assertEquals((Object)foreground, (Object)control.getForeground());
            ridget.addMarker((IMarker)new ErrorMarker());
            markerSupport.updateMarkers();
            ControlDecoration errorDecoration = (ControlDecoration)ReflectionUtils.invokeHidden((Object)((Object)markerSupport), (String)"getErrorDecorationForControl", (Object[])new Object[]{control});
            MarkerSupportTest.assertNotNull((Object)errorDecoration);
            MarkerSupportTest.assertTrue((boolean)errorDecoration.isVisible());
            markerSupport.clearAllMarkers((Control)control);
            MarkerSupportTest.assertFalse((boolean)errorDecoration.isVisible());
        }
        finally {
            realm.dispose();
        }
    }

    public void testReflectionUtilsUsageInGetControlBackground() {
        CCombo combo = new CCombo((Composite)this.shell, 0);
        Control text = (Control)ReflectionUtils.getHidden((Object)combo, (String)"list");
        text.getBackground();
    }

    public void testGetCustomBackground() {
        DefaultRealm realm = new DefaultRealm();
        try {
            TextRidget ridget = new TextRidget();
            MarkerSupport support = new MarkerSupport((IBasicMarkableRidget)ridget, null);
            Color bg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomBackground", (Object[])new Object[]{OutputMarker.class});
            MarkerSupportTest.assertNull((Object)bg);
            ridget.addMarker((IMarker)new CustomOutputMarker());
            bg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomBackground", (Object[])new Object[]{OutputMarker.class});
            Color expected = this.display.getSystemColor(5);
            MarkerSupportTest.assertEquals((Object)expected, (Object)bg);
            ridget.addMarker((IMarker)new Custom2OutputMarker());
            bg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomBackground", (Object[])new Object[]{OutputMarker.class});
            expected = this.display.getSystemColor(9);
            MarkerSupportTest.assertEquals((Object)expected, (Object)bg);
            ridget.addMarker((IMarker)new CustomMandatoryMarker());
            bg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomBackground", (Object[])new Object[]{OutputMarker.class});
            expected = this.display.getSystemColor(9);
            MarkerSupportTest.assertEquals((Object)expected, (Object)bg);
            ridget.addMarker((IMarker)new CustomMandatoryMarker());
            bg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomBackground", (Object[])new Object[]{MandatoryMarker.class});
            expected = this.display.getSystemColor(7);
            MarkerSupportTest.assertEquals((Object)expected, (Object)bg);
        }
        finally {
            realm.dispose();
        }
    }

    public void testGetCustomForeground() {
        DefaultRealm realm = new DefaultRealm();
        try {
            TextRidget ridget = new TextRidget();
            MarkerSupport support = new MarkerSupport((IBasicMarkableRidget)ridget, null);
            Color fg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomForeground", (Object[])new Object[]{OutputMarker.class});
            MarkerSupportTest.assertNull((Object)fg);
            ridget.addMarker((IMarker)new CustomOutputMarker());
            fg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomForeground", (Object[])new Object[]{OutputMarker.class});
            Color expected = this.display.getSystemColor(6);
            MarkerSupportTest.assertEquals((Object)expected, (Object)fg);
            ridget.addMarker((IMarker)new Custom2OutputMarker());
            fg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomForeground", (Object[])new Object[]{OutputMarker.class});
            expected = this.display.getSystemColor(13);
            MarkerSupportTest.assertEquals((Object)expected, (Object)fg);
            ridget.addMarker((IMarker)new CustomMandatoryMarker());
            fg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomForeground", (Object[])new Object[]{OutputMarker.class});
            expected = this.display.getSystemColor(13);
            MarkerSupportTest.assertEquals((Object)expected, (Object)fg);
            ridget.addMarker((IMarker)new CustomMandatoryMarker());
            fg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getCustomForeground", (Object[])new Object[]{MandatoryMarker.class});
            MarkerSupportTest.assertNull((Object)fg);
        }
        finally {
            realm.dispose();
        }
    }

    public void testGetNegativeForeground() {
        DefaultRealm realm = new DefaultRealm();
        Text text = new Text((Composite)this.shell, 0);
        try {
            TextRidget ridget = new TextRidget();
            MarkerSupport support = new MarkerSupport((IBasicMarkableRidget)ridget, null);
            ridget.setUIControl((Object)text);
            Color fg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getNegativeForeground", (Object[])new Object[0]);
            Color expected = this.display.getSystemColor(3);
            MarkerSupportTest.assertEquals((Object)expected, (Object)fg);
            ridget.addMarker((IMarker)new CustomNegativeMarker());
            fg = (Color)ReflectionUtils.invokeHidden((Object)support, (String)"getNegativeForeground", (Object[])new Object[0]);
            expected = this.display.getSystemColor(4);
            MarkerSupportTest.assertEquals((Object)expected, (Object)fg);
        }
        finally {
            SwtUtilities.dispose((Widget)text);
            realm.dispose();
        }
    }

    private class Custom2OutputMarker
    extends OutputMarker
    implements ICustomMarker {
        private Custom2OutputMarker() {
        }

        public Object getBackground(IMarkable markable) {
            return MarkerSupportTest.this.display.getSystemColor(9);
        }

        public Object getForeground(IMarkable markable) {
            return MarkerSupportTest.this.display.getSystemColor(13);
        }
    }

    private class CustomMandatoryMarker
    extends MandatoryMarker
    implements ICustomMarker {
        private CustomMandatoryMarker() {
        }

        public Object getBackground(IMarkable markable) {
            return MarkerSupportTest.this.display.getSystemColor(7);
        }

        public Object getForeground(IMarkable markable) {
            return null;
        }
    }

    private class CustomNegativeMarker
    extends NegativeMarker
    implements ICustomMarker {
        private CustomNegativeMarker() {
        }

        public Object getBackground(IMarkable markable) {
            return null;
        }

        public Object getForeground(IMarkable markable) {
            return MarkerSupportTest.this.display.getSystemColor(4);
        }
    }

    private class CustomOutputMarker
    extends OutputMarker
    implements ICustomMarker {
        private CustomOutputMarker() {
        }

        public Object getBackground(IMarkable markable) {
            return MarkerSupportTest.this.display.getSystemColor(5);
        }

        public Object getForeground(IMarkable markable) {
            return MarkerSupportTest.this.display.getSystemColor(6);
        }
    }

    private static class MarkSupportClassLoader
    extends ClassLoader {
        public MarkSupportClassLoader() {
            super(MarkSupportClassLoader.class.getClassLoader());
        }

        public Class<?> getFreshMarkSupportClass() throws IOException {
            String resource = String.valueOf(MarkerSupport.class.getName().replace('.', '/')) + ".class";
            URL classURL = MarkerSupportTest.class.getClassLoader().getResource(resource);
            InputStream is = classURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int ch = -1;
            while ((ch = is.read()) != -1) {
                baos.write(ch);
            }
            byte[] bytes = baos.toByteArray();
            Class<?> cl = super.defineClass(MarkerSupport.class.getName(), bytes, 0, bytes.length);
            this.resolveClass(cl);
            return cl;
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        protected void initializeTheme() {
            super.initializeTheme();
            this.putLnfSetting("errorMarker.margin", 100);
            this.putLnfSetting("errorMarker.horizontalPosition", 131072);
            this.putLnfSetting("errorMarker.verticalPosition", 1024);
        }
    }

    private static class MyMarkerSupport
    extends MarkerSupport {
        private MyMarkerSupport() {
        }

        public void clearAllMarkers(Control control) {
            super.clearAllMarkers(control);
        }

        public void clearMandatory(Control control) {
            super.clearMandatory(control);
        }
    }

    private static class MyNonsenseLnf
    extends RienaDefaultLnf {
        private MyNonsenseLnf() {
        }

        protected void initializeTheme() {
            super.initializeTheme();
            Map resourceTable = (Map)ReflectionUtils.getHidden((Object)((Object)this), (String)"resourceTable");
            resourceTable.clear();
            Map settingTable = (Map)ReflectionUtils.getHidden((Object)((Object)this), (String)"settingTable");
            settingTable.clear();
        }
    }
}

