/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.swt.ImageButton;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MasterDetailsCompositeTest
extends TestCase {
    private Shell shell;
    private MasterDetailsComposite masterDetails;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.masterDetails = new MasterDetailsComposite((Composite)this.shell, 0);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testGetUIControlsWithBindingProperty() {
        Composite parent = this.masterDetails.getDetails();
        Text txtFirstName = UIControlsFactory.createText((Composite)parent, (int)2048, (String)"txtFirstName");
        Text txtLastName = UIControlsFactory.createText((Composite)parent, (int)2048, (String)"txtLastName");
        Text txtWithoutID = UIControlsFactory.createText((Composite)parent, (int)2048);
        List controls = this.masterDetails.getUIControls();
        MasterDetailsCompositeTest.assertEquals((int)6, (int)controls.size());
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(txtFirstName));
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(txtLastName));
        MasterDetailsCompositeTest.assertFalse((boolean)controls.contains(txtWithoutID));
        List controls2 = this.masterDetails.getUIControls();
        MasterDetailsCompositeTest.assertEquals((int)6, (int)controls2.size());
    }

    public void testGetUIControlsWithBindingPropertyFromComposite() {
        Composite parent = new Composite(this.masterDetails.getDetails(), 0);
        Text txtFirstName = UIControlsFactory.createText((Composite)parent, (int)2048, (String)"txtFirstName");
        Text txtLastName = UIControlsFactory.createText((Composite)parent, (int)2048, (String)"txtLastName");
        Text txtWithoutID = UIControlsFactory.createText((Composite)parent, (int)2048);
        List controls = this.masterDetails.getUIControls();
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(txtFirstName));
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(txtLastName));
        MasterDetailsCompositeTest.assertFalse((boolean)controls.contains(txtWithoutID));
    }

    public void testGetUIControlsThatAreComposites() {
        Composite parent = this.masterDetails.getDetails();
        Combo combo = UIControlsFactory.createCombo((Composite)parent, (String)"combo");
        CCombo ccombo = UIControlsFactory.createCCombo((Composite)parent, (String)"ccombo");
        DateTime datetime = UIControlsFactory.createDate((Composite)parent, (int)0, (String)"datetime");
        List controls = this.masterDetails.getUIControls();
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(combo));
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(ccombo));
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(datetime));
        Composite composite = new Composite(parent, 0);
        Combo combo2 = UIControlsFactory.createCombo((Composite)composite, (String)"combo2");
        controls = this.masterDetails.getUIControls();
        MasterDetailsCompositeTest.assertFalse((boolean)controls.contains(composite));
        MasterDetailsCompositeTest.assertTrue((boolean)controls.contains(combo2));
    }

    public void testSkipIComplexComponent() {
        MasterDetailsComposite widget = new MasterDetailsComposite((Composite)this.shell, 0){

            protected void createDetails(Composite details) {
                TestComplexComponent complex = new TestComplexComponent(details, 0);
                this.addUIControl((Object)complex, "complex");
            }
        };
        List controls = widget.getUIControls();
        System.out.println(Arrays.toString(controls.toArray()));
        MasterDetailsCompositeTest.assertEquals((int)5, (int)controls.size());
        MasterDetailsCompositeTest.assertTrue((boolean)(controls.get(0) instanceof Table));
        MasterDetailsCompositeTest.assertTrue((boolean)(controls.get(1) instanceof Button));
        MasterDetailsCompositeTest.assertTrue((boolean)(controls.get(2) instanceof Button));
        MasterDetailsCompositeTest.assertTrue((boolean)(controls.get(3) instanceof Button));
        MasterDetailsCompositeTest.assertTrue((boolean)(controls.get(4) instanceof TestComplexComponent));
    }

    public void testSetMargins() {
        MasterDetailsComposite widget = new MasterDetailsComposite((Composite)this.shell, 0);
        GridLayout layout = (GridLayout)widget.getLayout();
        MasterDetailsCompositeTest.assertEquals((int)0, (int)layout.marginHeight);
        MasterDetailsCompositeTest.assertEquals((int)0, (int)layout.marginWidth);
        widget.setMargins(4, 5);
        layout = (GridLayout)widget.getLayout();
        MasterDetailsCompositeTest.assertEquals((int)4, (int)layout.marginHeight);
        MasterDetailsCompositeTest.assertEquals((int)5, (int)layout.marginWidth);
    }

    public void testGetMargins() {
        MasterDetailsComposite widget = new MasterDetailsComposite((Composite)this.shell, 0);
        MasterDetailsCompositeTest.assertEquals((int)0, (int)widget.getMargins().x);
        MasterDetailsCompositeTest.assertEquals((int)0, (int)widget.getMargins().y);
        widget.setMargins(4, 5);
        MasterDetailsCompositeTest.assertEquals((int)4, (int)widget.getMargins().x);
        MasterDetailsCompositeTest.assertEquals((int)5, (int)widget.getMargins().y);
    }

    public void testGetSetSpacing() {
        MasterDetailsComposite widget = new MasterDetailsComposite((Composite)this.shell, 0);
        MasterDetailsCompositeTest.assertEquals((int)0, (int)widget.getSpacing().x);
        MasterDetailsCompositeTest.assertEquals((int)5, (int)widget.getSpacing().y);
        widget.setSpacing(3, 4);
        MasterDetailsCompositeTest.assertEquals((int)3, (int)widget.getSpacing().x);
        MasterDetailsCompositeTest.assertEquals((int)4, (int)widget.getSpacing().y);
    }

    public void testCheckButton() {
        MasterDetailsComposite widget = new MasterDetailsComposite((Composite)this.shell, 0);
        Button button = new Button((Composite)this.shell, 8);
        ImageButton imageButton = new ImageButton((Composite)this.shell, 0);
        ReflectionUtils.invokeHidden((Object)widget, (String)"checkButton", (Object[])new Object[]{button, true});
        ReflectionUtils.invokeHidden((Object)widget, (String)"checkButton", (Object[])new Object[]{button, false});
        ReflectionUtils.invokeHidden((Object)widget, (String)"checkButton", (Object[])new Object[]{imageButton, true});
        ReflectionUtils.invokeHidden((Object)widget, (String)"checkButton", (Object[])new Object[]{imageButton, false});
        try {
            ReflectionUtils.invokeHidden((Object)widget, (String)"checkButton", (Object[])new Object[]{new Object(), true});
            MasterDetailsCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {}
    }

    private static class TestComplexComponent
    extends Composite
    implements IComplexComponent {
        private final Label label = UIControlsFactory.createLabel((Composite)this, (String)"txt", (String)"label");

        public TestComplexComponent(Composite parent, int style) {
            super(parent, style);
        }

        public List<Object> getUIControls() {
            return Arrays.asList(this.label);
        }
    }
}

