/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizer;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerLocator;
import org.eclipse.riena.ui.core.uiprocess.UICallbackDispatcher;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;

public class ProgressProviderBridge
extends ProgressProvider {
    private static final SingletonProvider<ProgressProviderBridge> PPB = new SingletonProvider(ProgressProviderBridge.class);
    private IProgressVisualizerLocator visualizerLocator;
    private final Map<Job, IProgressVisualizer> jobToVisualizer = new HashMap<Job, IProgressVisualizer>();
    private final Map<Job, UIProcess> jobUiProcess = Collections.synchronizedMap(new HashMap());

    public ProgressProviderBridge() {
        this.registerJobChangeListener();
    }

    protected void registerJobChangeListener() {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobObserver());
    }

    public static ProgressProviderBridge instance() {
        return (ProgressProviderBridge)((Object)PPB.getInstance());
    }

    public void setVisualizerFactory(IProgressVisualizerLocator visualizerLocator) {
        this.visualizerLocator = visualizerLocator;
    }

    public IProgressMonitor createMonitor(Job job) {
        ProgressProvider provider = this.queryProgressProvider(job);
        return provider.createMonitor(job);
    }

    private ProgressProvider queryProgressProvider(Job job) {
        UIProcess uiprocess = this.jobUiProcess.get(job);
        Object context = this.getContext(job);
        if (uiprocess == null) {
            uiprocess = this.createDefaultUIProcess(job);
            this.registerMapping(job, uiprocess);
        }
        UICallbackDispatcher dispatcher = (UICallbackDispatcher)uiprocess.getAdapter(UICallbackDispatcher.class);
        IProgressVisualizer progressVisualizer = this.jobToVisualizer.get(job);
        if (progressVisualizer == null) {
            progressVisualizer = this.visualizerLocator.getProgressVisualizer(context);
            this.jobToVisualizer.put(job, progressVisualizer);
            dispatcher.addUIMonitor(progressVisualizer);
        }
        return dispatcher;
    }

    private Object getContext(Job job) {
        return job.getProperty(UIProcess.PROPERTY_CONTEXT);
    }

    private UIProcess createDefaultUIProcess(Job job) {
        return new UIProcess(job);
    }

    public synchronized void registerMapping(Job job, UIProcess process) {
        this.jobUiProcess.put(job, process);
    }

    public synchronized void unregisterMapping(Job job) {
        this.jobUiProcess.remove(job);
    }

    public List<UIProcess> getRegisteredUIProcesses() {
        return new ArrayList<UIProcess>(this.jobUiProcess.values());
    }

    private final class JobObserver
    extends JobChangeAdapter {
        private JobObserver() {
        }

        public void scheduled(IJobChangeEvent event) {
            Job job = event.getJob();
            if (ProgressProviderBridge.this.jobUiProcess.get(job) == null) {
                ProgressProviderBridge.this.createDefaultUIProcess(job);
            }
        }

        public void done(IJobChangeEvent event) {
            Job job = event.getJob();
            ProgressProviderBridge.this.jobToVisualizer.remove(job);
            ProgressProviderBridge.this.unregisterMapping(job);
        }
    }
}

