/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.riena.ui.core.uiprocess.IProcessInfoAware;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizer;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerObserver;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;

public class ProgressVisualizer
extends PlatformObject
implements IProgressVisualizer {
    private final Collection<IProgressVisualizerObserver> observers = new ArrayList<IProgressVisualizerObserver>();
    private ProcessInfo processInfo;

    @Override
    public void finalUpdateUI() {
        ArrayList<IProgressVisualizerObserver> currentObservers = new ArrayList<IProgressVisualizerObserver>(this.observers);
        if (currentObservers.size() > 0) {
            for (IProgressVisualizerObserver anObserver : currentObservers) {
                anObserver.finalUpdateUI(this);
                anObserver.removeProgressVisualizer(this);
            }
        }
    }

    @Override
    public void initialUpdateUI(int totalWork) {
        ArrayList<IProgressVisualizerObserver> currentObservers = new ArrayList<IProgressVisualizerObserver>(this.observers);
        for (IProgressVisualizerObserver anObserver : currentObservers) {
            anObserver.addProgressVisualizer(this);
            anObserver.initialUpdateUI(this, totalWork);
        }
    }

    @Override
    public void updateProgress(int progress) {
        ArrayList<IProgressVisualizerObserver> currentObservers = new ArrayList<IProgressVisualizerObserver>(this.observers);
        for (IProgressVisualizerObserver anObserver : currentObservers) {
            anObserver.updateProgress(this, progress);
        }
    }

    @Override
    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    @Override
    public void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    @Override
    public void addObserver(IProgressVisualizerObserver anObserver) {
        if (anObserver != null) {
            this.observers.add(anObserver);
        }
    }

    @Override
    public void removeObserver(IProgressVisualizerObserver anObserver) {
        this.observers.remove(anObserver);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IProcessInfoAware.class || adapter == IProgressVisualizer.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }
}

