/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.riena.ui.ridgets.IDateTimeRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractEditableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

public class DateTimeRidget
extends AbstractEditableRidget
implements IDateTimeRidget {
    private static final String PROPERTY_DATE_INTERNAL = "dateInternal";
    private Date date;
    private DataBindingContext dbc;
    private Binding controlBinding;

    @Override
    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, DateTime.class);
    }

    @Override
    protected void bindUIControl() {
        DateTime control = this.getUIControl();
        if (control != null) {
            ISWTObservableValue dateObservable;
            ISWTObservableValue timeObservable;
            this.dbc = new DataBindingContext();
            Date nonNullDate = this.getNonNullDate(this.getDate());
            if (this.isTimeControl(control)) {
                timeObservable = WidgetProperties.selection().observe((Widget)control);
                timeObservable.setValue((Object)nonNullDate);
                dateObservable = new WritableValue(timeObservable.getRealm(), (Object)nonNullDate, Date.class);
            } else {
                dateObservable = WidgetProperties.selection().observe((Widget)control);
                dateObservable.setValue((Object)nonNullDate);
                timeObservable = new WritableValue(dateObservable.getRealm(), (Object)nonNullDate, Date.class);
            }
            this.controlBinding = this.dbc.bindValue((IObservableValue)new DateAndTimeObservableWithNullConversion((IObservableValue)dateObservable, (IObservableValue)timeObservable), this.getRidgetObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new EditRulesValidator()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
    }

    @Override
    protected final IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)PROPERTY_DATE_INTERNAL);
    }

    public DateTime getUIControl() {
        return (DateTime)super.getUIControl();
    }

    @Override
    public void bindToModel(IObservableValue observableValue) {
        this.unbindUIControl();
        Assert.isNotNull((Object)observableValue);
        super.bindToModel(observableValue);
        this.bindUIControl();
    }

    @Override
    public void bindToModel(Object valueHolder, String valuePropertyName) {
        if (AbstractSWTRidget.isBean(valueHolder.getClass())) {
            this.bindToModel(BeansObservables.observeValue((Object)valueHolder, (String)valuePropertyName));
        } else {
            this.bindToModel(PojoObservables.observeValue((Object)valueHolder, (String)valuePropertyName));
        }
    }

    public Date getDate() {
        return this.date;
    }

    public final Date getDateInternal() {
        return this.getDate();
    }

    public String getText() {
        Date date = this.getDate();
        return date != null ? SimpleDateFormat.getInstance().format(date) : "";
    }

    public boolean isDirectWriting() {
        return true;
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && !this.isOutputOnly();
    }

    public boolean revalidate() {
        Date date = this.getDate();
        IStatus onUpdate = this.checkOnUpdateRules(date, new AbstractEditableRidget.ValidationCallback(this, false));
        if (onUpdate.isOK()) {
            this.getValueBindingSupport().updateFromTarget();
        }
        return !this.isErrorMarked();
    }

    public void setDate(Date date) {
        if (this.isChanged(this.date, date)) {
            IStatus status;
            Date oldDate = this.date;
            this.date = date == null ? null : new Date(date.getTime());
            Date newDate = date == null ? null : new Date(date.getTime());
            this.firePropertyChange(PROPERTY_DATE_INTERNAL, oldDate, newDate);
            this.firePropertyChange("date", oldDate, newDate);
            if (this.controlBinding != null) {
                this.controlBinding.updateModelToTarget();
            }
            if ((status = this.checkAllRules(date, new AbstractEditableRidget.ValidationCallback(this, false))).isOK()) {
                this.getValueBindingSupport().updateFromTarget();
            }
        }
    }

    public final void setDateInternal(Date date) {
        this.setDate(date);
    }

    public void setDirectWriting(boolean directWriting) {
        throw new UnsupportedOperationException();
    }

    public void setInputToUIControlConverter(IConverter converter) {
        throw new UnsupportedOperationException();
    }

    public void setText(String text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFromModel() {
        super.updateFromModel();
        if (this.controlBinding != null) {
            this.controlBinding.updateModelToTarget();
        }
        this.checkAllRules(this.getDate(), new AbstractEditableRidget.ValidationCallback(this, false));
    }

    private Date getNonNullDate(Date date) {
        return date != null ? date : new Date(0L);
    }

    private boolean isChanged(Date date1, Date date2) {
        if (date1 == date2) {
            return false;
        }
        return date1 != null ? !date1.equals(date2) : !date2.equals(date1);
    }

    private boolean isTimeControl(DateTime control) {
        return (control.getStyle() & 0x80) != 0;
    }

    private final class DateAndTimeObservableWithNullConversion
    extends DateAndTimeObservableValue {
        public DateAndTimeObservableWithNullConversion(IObservableValue dateObservable, IObservableValue timeObservable) {
            super(dateObservable, timeObservable);
        }

        protected void doSetValue(Object value) {
            super.doSetValue((Object)DateTimeRidget.this.getNonNullDate((Date)value));
        }
    }

    private final class EditRulesValidator
    implements IValidator {
        private EditRulesValidator() {
        }

        public IStatus validate(Object value) {
            return DateTimeRidget.this.checkOnEditRules(value, new AbstractEditableRidget.ValidationCallback(DateTimeRidget.this, true));
        }
    }
}

