/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import org.eclipse.riena.internal.ui.ridgets.swt.ActionObserver;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconManagerProvider;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractActionRidget
extends AbstractSWTRidget
implements IActionRidget {
    private static final String EMPTY_STRING = "";
    protected final ActionObserver actionObserver = new ActionObserver((IRidget)this);
    private String text;
    private String iconID;
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;

    @Override
    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected void initText() {
        Control control;
        if (this.text == null && !this.textAlreadyInitialized && (control = this.getUIControl()) != null && !control.isDisposed()) {
            this.text = this.getUIControlText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    public final void addListener(IActionListener listener) {
        this.actionObserver.addListener(listener);
    }

    public final void removeListener(IActionListener listener) {
        this.actionObserver.removeListener(listener);
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public final String getText() {
        return this.text;
    }

    public String getIcon() {
        return this.iconID;
    }

    public void setIcon(String icon) {
        this.setIcon(icon, IconSize.NONE);
    }

    public void setIcon(String icon, IconSize size) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIcon = this.iconID;
        IIconManager manager = IconManagerProvider.getInstance().getIconManager();
        this.iconID = manager.getIconID(icon, size);
        if (this.hasChanged(oldIcon, icon) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    public final void setText(String newText) {
        String oldText = this.text;
        this.text = newText;
        this.updateUIText();
        this.firePropertyChange("text", oldText, this.text);
    }

    protected void updateUIText() {
        if (this.getUIControl() != null) {
            this.setUIControlText(this.getText());
        }
    }

    protected abstract String getUIControlText();

    protected abstract void setUIControlText(String var1);

    protected void updateUIIcon() {
        if (this.getUIControl() != null) {
            Image image = null;
            if (this.getIcon() != null) {
                image = this.getManagedImage(this.getIcon());
            }
            if (image != null || this.useRidgetIcon) {
                this.setUIControlImage(image);
            }
        }
    }

    protected abstract void setUIControlImage(Image var1);

    public void fireAction() {
        if (this.isVisible() && this.isEnabled()) {
            this.actionObserver.widgetSelected(null);
        }
    }
}

