/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.ui.ridgets.IMenuItemRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.listener.FocusEvent;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;

public abstract class AbstractRidget
implements IRidget {
    public static final String COMMAND_UPDATE = "update";
    public static final String PROPERTY_RIDGET = "ridget";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected boolean savedVisibleState = true;
    private final ListenerList<IFocusListener> focusListeners = new ListenerList(IFocusListener.class);
    private IRidgetContainer controller;
    private boolean ignoreBindingError;
    private boolean retryRequestFocus;

    protected void checkType(Object uiControl, Class<?> type) {
        if (uiControl != null && !type.isAssignableFrom(uiControl.getClass())) {
            String expectedClassName = type.getSimpleName();
            String controlClassName = uiControl.getClass().getSimpleName();
            throw new BindingException("uiControl of  must be a " + expectedClassName + " but was a " + controlClassName);
        }
    }

    @Override
    public void addFocusListener(IFocusListener listener) {
        this.focusListeners.add((Object)listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(null, propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        Assert.isNotNull((Object)propertyChangeListener);
        if (!this.hasListener(propertyName, propertyChangeListener)) {
            if (propertyName == null) {
                this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
            } else {
                this.propertyChangeSupport.addPropertyChangeListener(propertyName, propertyChangeListener);
            }
        }
    }

    public final void fireFocusGained() {
        FocusEvent event = new FocusEvent(null, this);
        IFocusListener[] iFocusListenerArray = (IFocusListener[])this.focusListeners.getListeners();
        int n = iFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFocusListener focusListener = iFocusListenerArray[n2];
            focusListener.focusGained(event);
            ++n2;
        }
    }

    public final void fireFocusLost() {
        FocusEvent event = new FocusEvent(this, null);
        IFocusListener[] iFocusListenerArray = (IFocusListener[])this.focusListeners.getListeners();
        int n = iFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFocusListener focusListener = iFocusListenerArray[n2];
            focusListener.focusLost(event);
            ++n2;
        }
    }

    @Override
    public IRidgetContainer getController() {
        return this.controller;
    }

    @Override
    public void removeFocusListener(IFocusListener listener) {
        this.focusListeners.remove((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.removePropertyChangeListener(null, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        Assert.isNotNull((Object)propertyChangeListener);
        if (propertyName == null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        } else {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, propertyChangeListener);
        }
    }

    @Override
    public void setController(IRidgetContainer controller) {
        Assert.isNotNull((Object)controller);
        this.controller = controller;
    }

    @Override
    public void updateFromModel() {
    }

    public void forceMarkerUpdate() {
        this.firePropertyChange(COMMAND_UPDATE, false, true);
    }

    @Override
    public void setIgnoreBindingError(boolean ignore) {
        this.ignoreBindingError = ignore;
    }

    @Override
    public boolean isIgnoreBindingError() {
        return this.ignoreBindingError;
    }

    @Deprecated
    protected final void fireFocusGained(FocusEvent event) {
        IFocusListener[] iFocusListenerArray = (IFocusListener[])this.focusListeners.getListeners();
        int n = iFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFocusListener focusListener = iFocusListenerArray[n2];
            focusListener.focusGained(event);
            ++n2;
        }
    }

    @Deprecated
    protected final void fireFocusLost(FocusEvent event) {
        IFocusListener[] iFocusListenerArray = (IFocusListener[])this.focusListeners.getListeners();
        int n = iFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFocusListener focusListener = iFocusListenerArray[n2];
            focusListener.focusLost(event);
            ++n2;
        }
    }

    protected final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private boolean hasListener(String propertyName, Object listener) {
        boolean result = false;
        PropertyChangeListener[] listeners = this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
        int i = 0;
        while (!result && i < listeners.length) {
            result = listeners[i] == listener;
            ++i;
        }
        return result;
    }

    public boolean isRetryRequestFocus() {
        return this.retryRequestFocus;
    }

    public void setRetryRequestFocus(boolean retryRequestFocus) {
        this.retryRequestFocus = retryRequestFocus;
    }

    @Override
    public IMenuItemRidget addMenuItem(String itemText) {
        throw new UnsupportedOperationException("Context menu is unsupported for " + this.toString());
    }

    @Override
    public IMenuItemRidget addMenuItem(String itemText, String iconName) {
        throw new UnsupportedOperationException("Context menu is unsupported for " + this.toString());
    }

    @Override
    public void removeMenuItem(String menuItemText) {
        throw new UnsupportedOperationException("Context menu is unsupported for " + this.toString());
    }

    @Override
    public void removeMenuItem(IMenuItemRidget menuItemRidget) {
        throw new UnsupportedOperationException("Context menu is unsupported for " + this.toString());
    }

    @Override
    public IMenuItemRidget getMenuItem(int index) {
        throw new UnsupportedOperationException("Context menu is unsupported for " + this.toString());
    }

    @Override
    public int getMenuItemCount() {
        throw new UnsupportedOperationException("Context menu is unsupported for " + this.toString());
    }
}

