/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.MessageMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.databinding.RidgetUpdateValueStrategy;
import org.eclipse.riena.ui.ridgets.marker.ValidationMessageMarker;
import org.eclipse.riena.ui.ridgets.validation.ValidatorCollection;

public class ValueBindingSupport {
    private final IValidator noErrorsRule = new IValidator(){

        public IStatus validate(Object value) {
            boolean isOk = ValueBindingSupport.this.markable.getMarkersOfType(ErrorMarker.class).isEmpty();
            return isOk ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }

        public String toString() {
            return "NO_ERRORS_RULE";
        }
    };
    private final ValidatorCollection afterGetValidators;
    private final ValidatorCollection onEditValidators;
    private final ValidatorCollection afterSetValidators;
    private Map<IValidator, Set<ValidationMessageMarker>> rule2messages;
    private Map<IValidator, IStatus> rule2status;
    private Map<IValidator, ErrorMessageMarker> rule2error;
    private DataBindingContext context;
    private IObservableValue targetOV;
    private IObservableValue modelOV;
    private String valuePropertyName;
    private Object valueHolder;
    private Binding modelBinding;
    private IConverter uiControlToModelConverter;
    private IConverter modelToUIControlConverter;
    private AggregateValidationStatus validationStatus;
    private IMarkable markable;

    public ValueBindingSupport(IObservableValue target) {
        this.bindToTarget(target);
        this.afterGetValidators = new ValidatorCollection();
        this.onEditValidators = new ValidatorCollection();
        this.afterSetValidators = new ValidatorCollection();
    }

    public ValueBindingSupport(IObservableValue target, IObservableValue model) {
        this(target);
        this.bindToModel(model);
    }

    public IConverter getUIControlToModelConverter() {
        return this.uiControlToModelConverter;
    }

    public void setUIControlToModelConverter(IConverter uiControlToModelConverter) {
        this.uiControlToModelConverter = uiControlToModelConverter;
    }

    public IConverter getModelToUIControlConverter() {
        return this.modelToUIControlConverter;
    }

    public void setModelToUIControlConverter(IConverter modelToUIControlConverter) {
        this.modelToUIControlConverter = modelToUIControlConverter;
    }

    public Collection<IValidator> getValidationRules() {
        ArrayList<IValidator> allValidationRules = new ArrayList<IValidator>(this.onEditValidators.getValidators());
        allValidationRules.addAll(this.afterGetValidators.getValidators());
        allValidationRules.addAll(this.afterSetValidators.getValidators());
        return allValidationRules;
    }

    public ValidatorCollection getAllValidators() {
        ValidatorCollection result = new ValidatorCollection();
        this.addAll(this.onEditValidators, result);
        this.addAll(this.afterGetValidators, result);
        this.addAll(this.afterSetValidators, result);
        return result;
    }

    public ValidatorCollection getOnEditValidators() {
        return this.onEditValidators;
    }

    public ValidatorCollection getAfterGetValidators() {
        return this.afterGetValidators;
    }

    public ValidatorCollection getAfterSetValidators() {
        return this.afterSetValidators;
    }

    public boolean addValidationRule(IValidator validationRule, ValidationTime validationTime) {
        Assert.isNotNull((Object)validationRule);
        Assert.isNotNull((Object)validationTime);
        switch (validationTime) {
            case ON_UI_CONTROL_EDIT: {
                this.onEditValidators.add(validationRule);
                return true;
            }
            case ON_UPDATE_TO_MODEL: {
                this.afterGetValidators.add(validationRule);
                return false;
            }
            case AFTER_UPDATE_TO_MODEL: {
                this.afterSetValidators.add(validationRule);
                return false;
            }
        }
        throw new UnsupportedOperationException("Unknown validationTime: " + validationTime);
    }

    public boolean removeValidationRule(IValidator validationRule) {
        if (validationRule == null) {
            return false;
        }
        this.removeErrorMarker(validationRule);
        this.removeMessages(validationRule);
        this.clearStatus(validationRule);
        this.afterGetValidators.remove(validationRule);
        this.afterSetValidators.remove(validationRule);
        return this.onEditValidators.remove(validationRule);
    }

    public void bindToTarget(IObservableValue observableValue) {
        this.targetOV = observableValue;
        this.rebindToModel();
    }

    public void bindToModel(IObservableValue observableValue) {
        this.valuePropertyName = null;
        this.valueHolder = null;
        this.modelOV = observableValue;
        this.rebindToModel();
    }

    public void bindToModel(Object valueHolder, String valuePropertyName) {
        this.valueHolder = valueHolder;
        this.valuePropertyName = valuePropertyName;
        this.modelOV = this.isBean(valueHolder.getClass()) ? BeansObservables.observeValue((Object)valueHolder, (String)valuePropertyName) : PojoObservables.observeValue((Object)valueHolder, (String)valuePropertyName);
        this.rebindToModel();
    }

    public IObservableValue getTargetOV() {
        return this.targetOV;
    }

    public void rebindToModel() {
        if (this.modelOV == null || this.targetOV == null) {
            return;
        }
        RidgetUpdateValueStrategy uiControlToModelStrategy = new RidgetUpdateValueStrategy(this, UpdateValueStrategy.POLICY_UPDATE);
        RidgetUpdateValueStrategy modelToUIControlStrategy = new RidgetUpdateValueStrategy(this, UpdateValueStrategy.POLICY_ON_REQUEST);
        uiControlToModelStrategy.setAfterGetValidator(this.afterGetValidators);
        uiControlToModelStrategy.setAfterSetValidator(this.afterSetValidators);
        if (this.uiControlToModelConverter != null && this.targetOV.getValueType() == this.uiControlToModelConverter.getFromType() && this.modelOV.getValueType() == this.uiControlToModelConverter.getToType()) {
            uiControlToModelStrategy.setConverter(this.uiControlToModelConverter);
        }
        if (this.modelToUIControlConverter != null && this.targetOV.getValueType() == this.modelToUIControlConverter.getToType() && this.modelOV.getValueType() == this.modelToUIControlConverter.getFromType()) {
            modelToUIControlStrategy.setConverter(this.modelToUIControlConverter);
        }
        if (this.modelBinding != null) {
            this.modelBinding.dispose();
        }
        if (this.validationStatus != null) {
            this.validationStatus.dispose();
        }
        this.modelBinding = this.getContext().bindValue(this.targetOV, this.modelOV, (UpdateValueStrategy)uiControlToModelStrategy, (UpdateValueStrategy)modelToUIControlStrategy);
        this.validationStatus = new AggregateValidationStatus((IObservableCollection)this.getContext().getBindings(), 2);
        this.validationStatus.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                IStatus newStatus = (IStatus)((ComputedValue)event.getSource()).getValue();
                this.updateValidationMessages(newStatus);
            }

            private void updateValidationMessages(IStatus newStatus) {
                if (ValueBindingSupport.this.targetOV != null) {
                    Object value = ValueBindingSupport.this.targetOV.getValue();
                    ValueBindingSupport.this.updateValidationStatus(ValueBindingSupport.this.noErrorsRule, newStatus);
                    for (IValidator rule : ValueBindingSupport.this.getAfterGetValidators()) {
                        this.updateValidationStatusForRule(value, rule);
                    }
                    for (IValidator rule : ValueBindingSupport.this.getAfterSetValidators()) {
                        this.updateValidationStatusForRule(value, rule);
                    }
                }
            }

            protected void updateValidationStatusForRule(Object value, IValidator rule) {
                if (ValueBindingSupport.this.rule2status.containsKey(rule)) {
                    ValueBindingSupport.this.updateValidationStatus(rule, (IStatus)ValueBindingSupport.this.rule2status.get(rule));
                } else {
                    ValueBindingSupport.this.updateValidationStatus(rule, rule.validate(value));
                }
            }
        });
    }

    public IObservableValue getModelObservable() {
        return this.modelOV;
    }

    public Binding getModelBinding() {
        return this.modelBinding;
    }

    public String getValuePropertyName() {
        return this.valuePropertyName;
    }

    public void setMarkable(IMarkable markable) {
        this.markable = markable;
    }

    public void updateFromModel() {
        if (this.valueHolder != null && !this.isBean(this.valueHolder.getClass()) && this.isNestedProperty(this.valuePropertyName)) {
            this.bindToModel(this.valueHolder, this.valuePropertyName);
        }
        if (this.modelBinding != null) {
            this.modelBinding.updateModelToTarget();
        }
    }

    private boolean isNestedProperty(String propertyName) {
        return StringUtils.isGiven((CharSequence)propertyName) && propertyName.indexOf(46) != -1;
    }

    public void updateFromTarget() {
        if (this.modelBinding != null) {
            this.modelBinding.updateTargetToModel();
        }
    }

    public DataBindingContext getContext() {
        if (this.context == null) {
            this.context = new DataBindingContext();
        }
        return this.context;
    }

    public void addValidationMessage(String message) {
        this.addValidationMessage(message, this.noErrorsRule);
    }

    public void addValidationMessage(IMessageMarker messageMarker) {
        this.addValidationMessage(messageMarker, this.noErrorsRule);
    }

    public void addValidationMessage(String message, IValidator validationRule) {
        this.addValidationMessage((IMessageMarker)new MessageMarker(message), validationRule);
    }

    public void addValidationMessage(IMessageMarker messageMarker, IValidator validationRule) {
        Set<ValidationMessageMarker> messages;
        Assert.isNotNull((Object)messageMarker, (String)"messageMarker cannot be null");
        Assert.isNotNull((Object)validationRule, (String)"validationRule cannot be null");
        ValidationMessageMarker validationMessageMarker = new ValidationMessageMarker(messageMarker, validationRule);
        if (this.rule2messages == null) {
            this.rule2messages = new HashMap<IValidator, Set<ValidationMessageMarker>>();
        }
        if ((messages = this.rule2messages.get(validationRule)) == null) {
            messages = new HashSet<ValidationMessageMarker>();
            this.rule2messages.put(validationRule, messages);
        }
        messages.add(validationMessageMarker);
        this.updateValidationMessageMarker(validationRule);
    }

    public void removeValidationMessage(String message) {
        this.removeValidationMessage(message, this.noErrorsRule);
    }

    public void removeValidationMessage(IMessageMarker messageMarker) {
        this.removeValidationMessage(messageMarker, this.noErrorsRule);
    }

    public void removeValidationMessage(String message, IValidator validationRule) {
        this.removeValidationMessage((IMessageMarker)new MessageMarker(message), validationRule);
    }

    public void removeValidationMessage(IMessageMarker messageMarker, IValidator validationRule) {
        ValidationMessageMarker validationMessageMarker = new ValidationMessageMarker(messageMarker, validationRule);
        if (this.rule2messages != null) {
            Set<ValidationMessageMarker> messages = this.rule2messages.get(validationRule);
            messages.remove((Object)validationMessageMarker);
            this.markable.removeMarker((IMarker)validationMessageMarker);
            if (messages.isEmpty()) {
                this.rule2messages.remove(validationRule);
            }
        }
    }

    public void updateValidationStatus(IStatus status) {
        this.updateValidationStatus(this.noErrorsRule, status);
    }

    public void updateValidationStatus(IValidator validationRule, IStatus status) {
        this.storeStatus(validationRule, status);
        if (!status.isOK()) {
            this.addErrorMarker(validationRule, status);
            this.addMessages(validationRule);
        } else {
            this.removeErrorMarker(validationRule);
            this.removeMessages(validationRule);
        }
    }

    private void addAll(ValidatorCollection source, ValidatorCollection target) {
        for (IValidator validationRule : source) {
            target.add(validationRule);
        }
    }

    private void addErrorMarker(IValidator validationRule, IStatus status) {
        ErrorMessageMarker errorMarker;
        if (this.isBlocked(validationRule, status) || validationRule == this.noErrorsRule) {
            return;
        }
        if (this.rule2error == null) {
            this.rule2error = new HashMap<IValidator, ErrorMessageMarker>();
        }
        if ((errorMarker = this.rule2error.get(validationRule)) == null) {
            errorMarker = new ErrorMessageMarker(status.getMessage());
            this.rule2error.put(validationRule, errorMarker);
        } else {
            errorMarker.setMessage(status.getMessage());
        }
        this.markable.addMarker((IMarker)errorMarker);
    }

    private void addMessages(IValidator validationRule) {
        if (this.rule2messages != null && this.rule2messages.containsKey(validationRule)) {
            Set<ValidationMessageMarker> messages = this.rule2messages.get(validationRule);
            for (ValidationMessageMarker message : messages) {
                this.markable.addMarker((IMarker)message);
            }
        }
    }

    private void clearStatus(IValidator validationRule) {
        if (this.rule2status != null) {
            this.rule2status.remove(validationRule);
        }
    }

    private IStatus getStatus(IValidator validationRule) {
        return this.rule2status != null ? this.rule2status.get(validationRule) : null;
    }

    private boolean isBean(Class<?> clazz) {
        boolean result;
        try {
            clazz.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            result = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            result = false;
        }
        return result;
    }

    private boolean isBlocked(IValidator validationRule, IStatus status) {
        return status.getCode() == 1024 && this.onEditValidators.contains(validationRule);
    }

    private void storeStatus(IValidator validationRule, IStatus status) {
        if (this.rule2status == null) {
            this.rule2status = new HashMap<IValidator, IStatus>();
        }
        this.rule2status.put(validationRule, status);
    }

    private void removeErrorMarker(IValidator validationRule) {
        ErrorMessageMarker errorMarker;
        if (this.rule2error != null && (errorMarker = this.rule2error.remove(validationRule)) != null) {
            this.markable.removeMarker((IMarker)errorMarker);
        }
    }

    private void removeMessages(IValidator validationRule) {
        if (this.rule2messages != null && this.rule2messages.containsKey(validationRule)) {
            Set<ValidationMessageMarker> messages = this.rule2messages.get(validationRule);
            for (ValidationMessageMarker message : messages) {
                this.markable.removeMarker((IMarker)message);
            }
        }
    }

    private void updateValidationMessageMarker(IValidator validationRule) {
        IStatus status = this.getStatus(validationRule);
        if (status != null) {
            this.updateValidationStatus(validationRule, status);
        }
    }
}

