/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.util.GregorianCalendar;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;
import org.eclipse.riena.ui.ridgets.databinding.GregorianCalendarToStringConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToGregorianCalendarConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToNumberAllowingNullConverter;
import org.eclipse.riena.ui.ridgets.validation.IValidationCallback;
import org.eclipse.riena.ui.ridgets.validation.ValidatorCollection;

public class RidgetUpdateValueStrategy
extends UpdateValueStrategy {
    private IValidator afterSetValidator;
    private final ValueBindingSupport valueBindingSupport;

    public RidgetUpdateValueStrategy(ValueBindingSupport valueBindingSupport) {
        Assert.isNotNull((Object)valueBindingSupport);
        this.valueBindingSupport = valueBindingSupport;
    }

    public RidgetUpdateValueStrategy(ValueBindingSupport valueBindingSupport, int updatePolicy) {
        super(updatePolicy);
        Assert.isNotNull((Object)valueBindingSupport);
        this.valueBindingSupport = valueBindingSupport;
    }

    public RidgetUpdateValueStrategy(ValueBindingSupport valueBindingSupport, boolean provideDefaults, int updatePolicy) {
        super(provideDefaults, updatePolicy);
        Assert.isNotNull((Object)valueBindingSupport);
        this.valueBindingSupport = valueBindingSupport;
    }

    protected IConverter createConverter(Object fromType, Object toType) {
        if (fromType == String.class) {
            if (toType == Double.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveDouble();
            }
            if (toType == Float.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveFloat();
            }
            if (toType == Long.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveLong();
            }
            if (toType == Integer.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveInteger();
            }
            if (toType == GregorianCalendar.class) {
                return new StringToGregorianCalendarConverter();
            }
        }
        if (fromType == GregorianCalendar.class && toType == String.class) {
            return new GregorianCalendarToStringConverter();
        }
        return super.createConverter(fromType, toType);
    }

    public void setAfterSetValidator(IValidator validator) {
        this.afterSetValidator = validator;
    }

    protected IStatus doSet(IObservableValue destination, Object convertedValue) {
        IStatus status = super.doSet(destination, convertedValue);
        return status.isOK() ? this.validateAfterSet() : status;
    }

    protected IStatus validateAfterSet() {
        Object value = this.valueBindingSupport.getTargetOV().getValue();
        return this.performValidation(value, this.afterSetValidator);
    }

    public IStatus validateAfterGet(Object value) {
        return this.performValidation(value, this.afterGetValidator);
    }

    private IStatus performValidation(Object value, IValidator validator) {
        if (validator instanceof ValidatorCollection) {
            return ((ValidatorCollection)validator).validate(value, new IValidationCallback(){

                @Override
                public void validationRuleChecked(IValidator validationRule, IStatus status) {
                    RidgetUpdateValueStrategy.this.valueBindingSupport.updateValidationStatus(validationRule, status);
                }

                @Override
                public void validationResult(IStatus status) {
                }
            });
        }
        if (validator != null) {
            return validator.validate(value);
        }
        return Status.OK_STATUS;
    }
}

