/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.util.Arrays;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.nls.Messages;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class ValidCharacters
implements IValidator,
IExecutableExtension {
    public static final String VALID_NUMBERS = "0123456789";
    public static final String VALID_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String VALID_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String VALID_LETTER = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String VALID_ALPHANUMERIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private String allowedChars;
    private char[] allowedCharsSorted = new char[0];

    public ValidCharacters() {
        this.setAllowedChars(null);
    }

    public ValidCharacters(String allowedChars) {
        this.setAllowedChars(allowedChars);
    }

    public IStatus validate(Object value) {
        if (value != null) {
            if (!(value instanceof String)) {
                throw new ValidationFailure("ValidCharacters can only validate objects of type String.");
            }
            String string = (String)value;
            if (this.allowedChars != null) {
                int t = 0;
                while (t < string.length()) {
                    char currentChar = string.charAt(t);
                    if (Arrays.binarySearch(this.allowedCharsSorted, currentChar) < 0) {
                        String message = NLS.bind((String)Messages.ValidCharacters_error_invalidChar, (Object)Character.valueOf(currentChar), (Object)string);
                        return ValidationRuleStatus.error(true, message);
                    }
                    ++t;
                }
            }
        }
        return ValidationRuleStatus.ok();
    }

    public String getAllowedChars() {
        return this.allowedChars;
    }

    public void setAllowedChars(String allowedChars) {
        this.allowedChars = allowedChars;
        this.allowedCharsSorted = allowedChars == null ? new char[]{} : allowedChars.toCharArray();
        Arrays.sort(this.allowedCharsSorted);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] args = PropertiesUtils.asArray((Object)data);
            this.setAllowedChars(args[0]);
        }
    }
}

