/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.RichString;

public final class PropertiesUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private PropertiesUtils() {
    }

    public static String accessProperty(Object propValue, String returnIfNoString) {
        if (propValue instanceof String) {
            return (String)propValue;
        }
        if (propValue instanceof String[]) {
            return ((String[])propValue)[0];
        }
        return returnIfNoString;
    }

    public static Map<String, String> asMap(Object data, String ... expectedKeys) {
        return PropertiesUtils.asMap(data, null, expectedKeys);
    }

    public static Map<String, String> asMap(Object data, Map<String, String> defaults, String ... expectedKeys) {
        Map<Object, Object> result = null;
        if (data == null) {
            result = new HashMap();
        } else if (data instanceof Hashtable) {
            result = (Hashtable)data;
        } else if (data instanceof String) {
            result = new RichString((String)data).toMap();
        } else {
            Assert.isLegal((boolean)false, (String)("Can not deal with data type: " + data.getClass().getName()));
        }
        if (defaults != null) {
            for (Map.Entry<String, String> entry : defaults.entrySet()) {
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        String[] stringArray = expectedKeys;
        int n = expectedKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedKey = stringArray[n2];
            Assert.isLegal((boolean)result.containsKey(expectedKey), (String)("data " + data + " does not contain expected key " + expectedKey + "."));
            ++n2;
        }
        return Collections.unmodifiableMap(result);
    }

    public static String[] asArray(Object data) {
        if (data == null) {
            return EMPTY_STRING_ARRAY;
        }
        Assert.isLegal((boolean)(data instanceof String), (String)"data must be of type String.");
        return new RichString((String)data).toArray();
    }
}

