/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;

public class RichString
implements CharSequence {
    private final String poorString;
    private static final String PAIR_DELIM = ";";
    private static final char LIST_DELIM = ',';
    private static final char ESCAPE_CHAR = '\\';
    private static final int STATE_CHAR = 0;
    private static final int STATE_BACK_SLASH = 1;
    private static final String EMPTY_STRING = "";

    public RichString(String poorString) {
        this.poorString = poorString == null ? EMPTY_STRING : poorString;
    }

    @Override
    public boolean isEmpty() {
        return this.poorString.length() == 0;
    }

    public List<String> toList() {
        if (this.isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder value = new StringBuilder();
        char ch = '\u0000';
        int state = 0;
        int i = 0;
        while (i < this.poorString.length()) {
            ch = this.poorString.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '\\') {
                        state = 1;
                        break;
                    }
                    if (ch == ',') {
                        result.add(value.toString());
                        value.setLength(0);
                        break;
                    }
                    value.append(ch);
                    break;
                }
                case 1: {
                    if (ch == '\\' || ch == ',') {
                        value.append(ch);
                    } else {
                        Assert.isLegal((boolean)false, (String)("Unknown escaped character: " + ch + "."));
                    }
                    state = 0;
                    break;
                }
            }
            ++i;
        }
        if (value.length() != 0 || ch == ',') {
            result.add(value.toString());
        }
        return result;
    }

    public Set<String> toSet() {
        if (this.isEmpty()) {
            return new HashSet<String>(0);
        }
        return new HashSet<String>(this.toList());
    }

    public String[] toArray() {
        List<String> list = this.toList();
        return list.toArray(new String[list.size()]);
    }

    public Map<String, String> toMap() {
        if (this.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer parts = new StringTokenizer(this.poorString, PAIR_DELIM);
        while (parts.hasMoreTokens()) {
            String part = parts.nextToken();
            int equal = part.indexOf(61);
            Assert.isLegal((equal > 0 ? 1 : 0) != 0, (String)"Error within definition. Expecting a string of the form:  [ <key> \"=\" <value> ] { [ \";\" <key> \"=\" <value> ] }");
            result.put(part.substring(0, equal).trim(), part.substring(equal + 1).trim());
        }
        return result;
    }

    @Override
    public int length() {
        return this.poorString.length();
    }

    @Override
    public char charAt(int index) {
        return this.poorString.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.poorString.subSequence(start, end);
    }
}

