/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.controllers;

import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.annotation.OnNavigationNodeEvent;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.filter.IUIFilterProvider;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.annotation.OnActionCallback;

public class CustomerOverviewController
extends SubModuleController {
    private final IUIFilter assistent = ((IUIFilterProvider)Service.get(IUIFilterProvider.class)).provideFilter("demo.assistent").getFilter();
    private final IUIFilter mandatory = ((IUIFilterProvider)Service.get(IUIFilterProvider.class)).provideFilter("demo.mandatory").getFilter();
    private Customer customer;

    public void configureRidgets() {
        this.customer = (Customer)((ISubModuleNode)this.getNavigationNode()).getParent().getContext("demo.customer");
        if (this.customer == null) {
            NavigationArgument navigationArgument = ((ISubModuleNode)this.getNavigationNode()).getNavigationArgument();
            if (navigationArgument != null) {
                this.customer = (Customer)navigationArgument.getParameter();
            } else {
                this.customer = new Customer();
                ((ISubModuleNode)this.getNavigationNode()).getParent().setLabel("new Customer");
            }
            ((ISubModuleNode)this.getNavigationNode()).getParent().setContext("demo.customer", (Object)this.customer);
        }
        ITextRidget firstName = (ITextRidget)this.getRidget("firstname");
        firstName.bindToModel((Object)this.customer, "firstName");
        firstName.setMandatory(true);
        ITextRidget lastName = (ITextRidget)this.getRidget("lastname");
        lastName.setMandatory(true);
        lastName.bindToModel((Object)this.customer, "lastName");
        ((ITextRidget)this.getRidget(ITextRidget.class, "zipcode")).bindToModel((Object)this.customer.getAddress(), "zipCode");
        ((ITextRidget)this.getRidget(ITextRidget.class, "street")).bindToModel((Object)this.customer.getAddress(), "street");
        ((ITextRidget)this.getRidget(ITextRidget.class, "city")).bindToModel((Object)this.customer.getAddress(), "city");
        ((ITextRidget)this.getRidget(ITextRidget.class, "emailaddress")).bindToModel((Object)this.customer, "emailAddress");
        ((IDateTextRidget)this.getRidget(IDateTextRidget.class, "birthdate")).bindToModel((Object)this.customer, "birthDate");
        ((ITextRidget)this.getRidget(ITextRidget.class, "salary")).bindToModel((Object)this.customer, "salary");
        ((IDecimalTextRidget)this.getRidget(IDecimalTextRidget.class, "salary")).setPrecision(2);
        this.updateAllRidgetsFromModel();
    }

    @OnActionCallback(ridgetId="openEmailsAction")
    protected void openEmails() {
        String emailAddress = this.customer.getEmailAddress();
        ((ISubModuleNode)this.getNavigationNode()).jump(new NavigationNodeId("riena.demo.client.customermailfolders.mails", emailAddress), new NavigationArgument((Object)this.customer));
    }

    @OnActionCallback(ridgetId="assistent")
    protected void assistentAction() {
        IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        if (((IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "assistent")).isSelected()) {
            applNode.addFilter(this.assistent);
        } else {
            applNode.removeFilter(this.assistent);
        }
    }

    @OnActionCallback(ridgetId="mandatory")
    protected void mandatoryAction() {
        IApplicationNode applNode = (IApplicationNode)((ISubModuleNode)this.getNavigationNode()).getParentOfType(IApplicationNode.class);
        if (((IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "mandatory")).isSelected()) {
            applNode.addFilter(this.mandatory);
        } else {
            applNode.removeFilter(this.mandatory);
        }
    }

    @OnNavigationNodeEvent(event=OnNavigationNodeEvent.Event.ACTIVATED)
    protected void activated() {
        this.updateAllRidgetsFromModel();
    }
}

