package org.eclipse.riena.e4.launcher.listener;

import javax.inject.Inject;

import org.eclipse.swt.widgets.Display;

import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.ui.swt.application.LoginNonActivityTimer;
import org.eclipse.riena.navigation.ui.swt.application.LoginNonActivityTimer.ILoginExecutor;

/**
 * This listener starts the LoginNonActivityTimer after the application was activated.
 */
public class NonActivityApplicationNodeListener extends ApplicationNodeListener {

	@Inject
	private ILoginExecutor<Integer> loginExecutor;

	@Override
	public void afterActivated(final IApplicationNode source) {
		if (loginExecutor != null && loginExecutor.getNonActivityDuration() > 0) {
			startNonActivityTimer();
		}
	}

	private void startNonActivityTimer() {
		new LoginNonActivityTimer(Display.getCurrent(), loginExecutor, loginExecutor.getNonActivityDuration()).schedule();
	}

}
