/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.listener;

import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.riena.e4.launcher.listener.PrepareNodeDelegate;
import org.eclipse.riena.e4.launcher.part.MainMenuPart;
import org.eclipse.riena.e4.launcher.part.MainToolBarPart;
import org.eclipse.riena.e4.launcher.part.RienaPartHelper;
import org.eclipse.riena.e4.launcher.part.uielements.CoolBarComposite;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.NavigationSourceProvider;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.views.RienaMenuHelper;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.swt.widgets.Composite;

public class ShowPartSubModuleNodeListener
extends SubModuleNodeListener {
    private final NavigationSourceProvider navigationSourceProvider = new NavigationSourceProvider();
    private final PrepareNodeDelegate<ISubModuleNode> prepareNodeDelegate = new PrepareNodeDelegate();
    @Inject
    private IEclipseContext context;
    @Inject
    private RienaPartHelper partHelper;

    public void activated(ISubModuleNode source) {
        this.prepareNodeDelegate.prepare(source);
        this.partHelper.showPart(source);
        this.updateNavigationSourceProvider(source);
    }

    private void updateNavigationSourceProvider(ISubModuleNode source) {
        this.navigationSourceProvider.activeNodeChanged((INavigationNode)source);
        for (Map.Entry e : this.navigationSourceProvider.getCurrentState().entrySet()) {
            this.context.set((String)e.getKey(), e.getValue());
        }
    }

    public void parentChanged(ISubModuleNode source) {
        this.prepareNodeDelegate.prepare(source);
    }

    public void afterActivated(ISubModuleNode source) {
        CoolBarComposite coolBarComposite;
        MenuCoolBarComposite menuCoolBarComposite = this.getMenuCoolBarComposite();
        if (menuCoolBarComposite != null) {
            menuCoolBarComposite.updateMenuItems();
        }
        if ((coolBarComposite = this.getCoolBarComposite()) != null) {
            coolBarComposite.updateItems();
        }
        if (source.getNavigationNodeController() instanceof IController) {
            RienaMenuHelper bindHelper = new RienaMenuHelper();
            bindHelper.bindMenuAndToolItems((IController)source.getNavigationNodeController(), (Composite)menuCoolBarComposite, (Composite)coolBarComposite);
        }
    }

    private CoolBarComposite getCoolBarComposite() {
        MApplication mApplication;
        EModelService modelService = (EModelService)this.context.get(EModelService.class);
        MPart coolbarPart = (MPart)modelService.find("org.eclipse.riena.e4.launcher.mainToolBarPart", (MUIElement)(mApplication = (MApplication)this.context.get(MApplication.class)));
        Object c = coolbarPart.getTransientData().get(MainToolBarPart.COOLBAR_COMPOSITE_KEY);
        if (c instanceof CoolBarComposite) {
            return (CoolBarComposite)((Object)c);
        }
        return null;
    }

    private MenuCoolBarComposite getMenuCoolBarComposite() {
        MApplication mApplication;
        EModelService modelService = (EModelService)this.context.get(EModelService.class);
        MPart menuPart = (MPart)modelService.find("org.eclipse.riena.e4.launcher.mainMenuPart", (MUIElement)(mApplication = (MApplication)this.context.get(MApplication.class)));
        Object m = menuPart.getTransientData().get(MainMenuPart.MENU_COMPOSITE_KEY);
        if (m instanceof MenuCoolBarComposite) {
            return (MenuCoolBarComposite)m;
        }
        return null;
    }

    public void disposed(ISubModuleNode source) {
        this.partHelper.disposeNode(source);
    }
}

