/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.rendering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.PartServiceSaveHandler;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.CSSEngineHelper;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.e4.launcher.rendering.ApplicationView;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.ui.swt.component.SwitcherComposite;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.DialogBorderRenderer;
import org.eclipse.riena.ui.swt.separator.Separator;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.EventHandler;

public class RienaWBWRenderer
extends SWTPartRenderer {
    public static final String SHELL_CREATED = "shellCreated";
    private static String ShellMinimizedTag = "shellMinimized";
    private static String ShellMaximizedTag = "shellMaximized";
    WindowSizeUpdateJob boundsJob;
    boolean ignoreSizeChanges = false;
    @Inject
    Logger logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IPresentationEngine engine;
    private EventHandler shellUpdater;
    private EventHandler visibilityHandler;
    private EventHandler sizeHandler;
    private EventHandler childHandler;
    private final ApplicationView applicationView = new ApplicationView();
    MPart activePart = null;
    private Composite header;
    private Composite mainMenu;
    private Composite mainToolBar;
    private Composite statusLine;
    private Composite perspectiveStack;
    @Inject
    private IEclipseContext context;

    void clearSizeUpdate() {
        this.boundsJob = null;
    }

    @Inject
    void trackActivePart(@Optional @Named(value="e4ActivePart") MPart p) {
        MPlaceholder ph;
        MElementContainer parent;
        if (this.activePart == p) {
            return;
        }
        if (this.activePart != null) {
            this.activePart.getTags().remove("active");
            parent = this.activePart.getParent();
            if (parent == null && this.activePart.getCurSharedRef() != null) {
                ph = this.activePart.getCurSharedRef();
                parent = ph.getParent();
            }
            if (parent instanceof MPartStack) {
                this.styleStack((MPartStack)parent, false);
            } else if (this.activePart.getWidget() != null) {
                this.setCSSInfo((MUIElement)this.activePart, this.activePart.getWidget());
            }
        }
        this.activePart = p;
        if (this.activePart != null) {
            this.activePart.getTags().add("active");
            parent = this.activePart.getParent();
            if (parent == null && this.activePart.getCurSharedRef() != null) {
                ph = this.activePart.getCurSharedRef();
                parent = ph.getParent();
            }
            if (parent instanceof MPartStack && parent.getWidget() != null) {
                this.styleStack((MPartStack)parent, true);
            } else if (this.activePart.getWidget() != null) {
                this.setCSSInfo((MUIElement)this.activePart, this.activePart.getWidget());
            }
        }
    }

    private void styleStack(MPartStack stack, boolean active) {
        if (!active) {
            stack.getTags().remove("active");
        } else {
            stack.getTags().add("active");
        }
        if (stack.getWidget() != null) {
            this.setCSSInfo((MUIElement)stack, stack.getWidget());
        }
    }

    private boolean closeDetachedWindow(MWindow window) {
        EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
        List parts = this.modelService.findElements((MUIElement)window, null, MPart.class, null);
        for (MPart part : parts) {
            if (partService.savePart(part, true)) continue;
            return false;
        }
        for (MPart part : parts) {
            partService.hidePart(part);
        }
        return true;
    }

    @PostConstruct
    public void init() {
        this.shellUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(event.getProperty("ChangedElement") instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != RienaWBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("label".equals(attName)) {
                    String newTitle = (String)event.getProperty("NewValue");
                    theShell.setText(newTitle);
                } else if ("iconURI".equals(attName)) {
                    theShell.setImage(RienaWBWRenderer.this.getImage((MUILabel)windowModel));
                } else if ("tooltip".equals(attName)) {
                    String newTTip = (String)event.getProperty("NewValue");
                    theShell.setToolTipText(newTTip);
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UILabel/*", this.shellUpdater);
        this.visibilityHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != RienaWBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("visible".equals(attName)) {
                    boolean isVisible = (Boolean)event.getProperty("NewValue");
                    theShell.setVisible(isVisible);
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", this.visibilityHandler);
        this.sizeHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                if (RienaWBWRenderer.this.ignoreSizeChanges) {
                    return;
                }
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != RienaWBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("x".equals(attName) || "y".equals(attName) || "width".equals(attName) || "height".equals(attName)) {
                    if (RienaWBWRenderer.this.boundsJob == null) {
                        RienaWBWRenderer.this.boundsJob = new WindowSizeUpdateJob();
                        RienaWBWRenderer.this.boundsJob.windowsToUpdate.add(windowModel);
                        theShell.getDisplay().asyncExec((Runnable)RienaWBWRenderer.this.boundsJob);
                    } else if (!RienaWBWRenderer.this.boundsJob.windowsToUpdate.contains(windowModel)) {
                        RienaWBWRenderer.this.boundsJob.windowsToUpdate.add(windowModel);
                    }
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/basic/Window/*", this.sizeHandler);
        this.childHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object changedObj = event.getProperty("ChangedElement");
                if (!(changedObj instanceof MPartStack)) {
                    return;
                }
                MPartStack stack = (MPartStack)changedObj;
                String eventType = (String)event.getProperty("EventType");
                if ("ADD".equals(eventType)) {
                    MUIElement added = (MUIElement)event.getProperty("NewValue");
                    if (added == RienaWBWRenderer.this.activePart) {
                        RienaWBWRenderer.this.styleStack(stack, true);
                    }
                } else if ("REMOVE".equals(eventType)) {
                    Activator.trace((String)"/trace/renderer", (String)"Child Removed", null);
                    MUIElement removed = (MUIElement)event.getProperty("OldValue");
                    if (removed == RienaWBWRenderer.this.activePart) {
                        RienaWBWRenderer.this.styleStack(stack, false);
                    }
                }
            }
        };
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.childHandler);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.shellUpdater);
        this.eventBroker.unsubscribe(this.visibilityHandler);
        this.eventBroker.unsubscribe(this.sizeHandler);
        this.eventBroker.unsubscribe(this.childHandler);
    }

    public Object createWidget(MUIElement element, Object parent) {
        Rectangle displayBounds;
        Shell wbwShell;
        Shell parentShell;
        if (!(element instanceof MWindow) || parent != null && !(parent instanceof Control)) {
            return null;
        }
        MWindow wbwModel = (MWindow)element;
        MApplication appModel = (MApplication)wbwModel.getContext().get(MApplication.class);
        Boolean rtlMode = (Boolean)appModel.getTransientData().get("dir");
        int rtlStyle = rtlMode != null && rtlMode != false ? 0x4000000 : 0;
        Shell shell = parentShell = parent == null ? null : ((Control)parent).getShell();
        if (parentShell == null) {
            wbwShell = this.rienaCreateShell(rtlStyle, wbwModel);
            wbwModel.getTags().add("topLevel");
        } else if (wbwModel.getTags().contains("dragHost")) {
            wbwShell = new Shell(parentShell, 0x800 | rtlStyle);
            wbwShell.setAlpha(110);
        } else {
            wbwShell = new Shell(parentShell, 0x34 | rtlStyle);
        }
        wbwShell.setBackgroundMode(1);
        Rectangle modelBounds = wbwShell.getBounds();
        if (wbwModel instanceof EObject) {
            EObject wbw = (EObject)wbwModel;
            EClass wbwclass = wbw.eClass();
            if (wbw.eIsSet(wbwclass.getEStructuralFeature("x"))) {
                modelBounds.x = wbwModel.getX();
            }
            if (wbw.eIsSet(wbwclass.getEStructuralFeature("y"))) {
                modelBounds.y = wbwModel.getY();
            }
            if (wbw.eIsSet(wbwclass.getEStructuralFeature("height"))) {
                modelBounds.height = wbwModel.getHeight();
            }
            if (wbw.eIsSet(wbwclass.getEStructuralFeature("width"))) {
                modelBounds.width = wbwModel.getWidth();
            }
        }
        if (!modelBounds.intersects(displayBounds = Display.getCurrent().getBounds())) {
            Rectangle clientArea = Display.getCurrent().getClientArea();
            modelBounds.x = clientArea.x;
            modelBounds.y = clientArea.y;
        }
        wbwShell.setBounds(modelBounds);
        this.setCSSInfo((MUIElement)wbwModel, wbwShell);
        IEclipseContext localContext = this.getContext((MUIElement)wbwModel);
        new CSSEngineHelper(localContext, (Control)wbwShell);
        this.rienaCreateContents((Composite)wbwShell);
        Shell newWidget = wbwShell;
        this.bindWidget(element, newWidget);
        localContext.set(Shell.class.getName(), (Object)wbwShell);
        localContext.set("localActiveShell", (Object)wbwShell);
        this.setCloseHandler(wbwModel);
        localContext.set(IShellProvider.class.getName(), (Object)new IShellProvider(){

            public Shell getShell() {
                return wbwShell;
            }
        });
        localContext.set(ISaveHandler.class, (Object)new PartServiceSaveHandler(){

            public ISaveHandler.Save promptToSave(MPart dirtyPart) {
                Shell shell = (Shell)RienaWBWRenderer.this.context.get("activeShell");
                Object[] elements = RienaWBWRenderer.this.promptForSave(shell, Collections.singleton(dirtyPart));
                if (elements == null) {
                    return ISaveHandler.Save.CANCEL;
                }
                return elements.length == 0 ? ISaveHandler.Save.NO : ISaveHandler.Save.YES;
            }

            public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
                ArrayList<MPart> parts = new ArrayList<MPart>(dirtyParts);
                Shell shell = (Shell)RienaWBWRenderer.this.context.get("activeShell");
                Object[] response = new ISaveHandler.Save[dirtyParts.size()];
                Object[] elements = RienaWBWRenderer.this.promptForSave(shell, parts);
                if (elements == null) {
                    Arrays.fill(response, ISaveHandler.Save.CANCEL);
                } else {
                    Arrays.fill(response, ISaveHandler.Save.NO);
                    int i = 0;
                    while (i < elements.length) {
                        response[parts.indexOf((Object)elements[i])] = ISaveHandler.Save.YES;
                        ++i;
                    }
                }
                return response;
            }
        });
        if (wbwModel.getLabel() != null) {
            wbwShell.setText(wbwModel.getLocalizedLabel());
        }
        wbwShell.setImage(this.getImage((MUILabel)wbwModel));
        wbwShell.setImages(Window.getDefaultImages());
        this.applicationView.doInitialBinding();
        return newWidget;
    }

    private Shell rienaCreateShell(int rtlStyle, MWindow modelElement) {
        int shellStyle = rtlStyle | 0x20000000;
        shellStyle = this.isHideOSBorder() != false ? rtlStyle | 8 : rtlStyle | 0x4F0;
        Shell shell = new Shell(Display.getCurrent(), shellStyle);
        RcpUtilities.setShell((Shell)shell);
        Rectangle shellBounds = this.applicationView.initShell(shell);
        modelElement.setX(shellBounds.x);
        modelElement.setY(shellBounds.y);
        modelElement.setWidth(shellBounds.width);
        modelElement.setHeight(shellBounds.height);
        this.eventBroker.send(SHELL_CREATED, (Object)shell);
        return shell;
    }

    private Boolean isHideOSBorder() {
        return LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder");
    }

    private void rienaCreateContents(Composite clientArea) {
        int headerPartHeight;
        GridLayout layout = new GridLayout();
        layout.marginWidth = RienaWBWRenderer.getShellBorderWidth();
        layout.marginHeight = RienaWBWRenderer.getShellBorderWidth();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        this.header = new Composite(clientArea, 0);
        GridData headerLayoutData = new GridData(768);
        headerLayoutData.heightHint = headerPartHeight = SwitcherComposite.getShellPadding() + SwitcherComposite.getSwitchterHeight() + SwitcherComposite.getSwitchterTopMargin();
        this.header.setLayoutData((Object)headerLayoutData);
        this.header.setLayout((Layout)new FillLayout());
        this.mainMenu = new Composite(clientArea, 0);
        GridData mainMenuLayoutData = new GridData(768);
        mainMenuLayoutData.verticalIndent = LnfManager.getLnf().getIntegerSetting("Menubar.topMargin");
        this.mainMenu.setLayoutData((Object)mainMenuLayoutData);
        FillLayout mainMenuLayout = new FillLayout();
        Integer shellPadding = this.isHideOSBorder() != false ? LnfManager.getLnf().getIntegerSetting("TitlelessShell.padding") : 0;
        mainMenuLayout.marginWidth = shellPadding;
        this.mainMenu.setLayout((Layout)mainMenuLayout);
        Separator separator = UIControlsFactory.createSeparator((Composite)clientArea, (int)256);
        GridData separatorLayoutData = new GridData(768);
        separatorLayoutData.heightHint = 2;
        separator.setLayoutData((Object)separatorLayoutData);
        this.mainToolBar = new Composite(clientArea, 0);
        GridData mainToolBarLayoutData = new GridData(768);
        mainToolBarLayoutData.verticalIndent = LnfManager.getLnf().getIntegerSetting("Toolbar.topMargin");
        this.mainToolBar.setLayoutData((Object)mainToolBarLayoutData);
        FillLayout mainToolBarLayout = new FillLayout();
        mainToolBarLayout.marginWidth = shellPadding;
        this.mainToolBar.setLayout((Layout)mainToolBarLayout);
        this.perspectiveStack = new Composite(clientArea, 0);
        this.perspectiveStack.setLayoutData((Object)new GridData(1808));
        FillLayout perspectiveStackLayout = new FillLayout();
        perspectiveStackLayout.marginWidth = shellPadding;
        this.perspectiveStack.setLayout((Layout)perspectiveStackLayout);
        this.applicationView.createInfoFlyout(this.perspectiveStack).setPositionCorrectionY(LnfManager.getLnf().getIntegerSetting("toolbar.workarea.vertical.gap").intValue());
        this.statusLine = new Composite(clientArea, 0);
        GridData statusLayoutData = new GridData(768);
        statusLayoutData.verticalIndent = shellPadding;
        statusLayoutData.heightHint = LnfManager.getLnf().getIntegerSetting("statusline.height") + 3;
        this.statusLine.setLayoutData((Object)statusLayoutData);
        this.statusLine.setLayout((Layout)new FillLayout());
    }

    private static int getShellBorderWidth() {
        DialogBorderRenderer borderRenderer = (DialogBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        return borderRenderer != null ? borderRenderer.getBorderWidth() : 0;
    }

    private void setCloseHandler(MWindow window) {
        IEclipseContext context = window.getContext();
        if (window.getParent() == null) {
            context.set(IWindowCloseHandler.class.getName(), (Object)new IWindowCloseHandler(){

                public boolean close(MWindow window) {
                    return RienaWBWRenderer.this.closeDetachedWindow(window);
                }
            });
        } else {
            context.set(IWindowCloseHandler.class.getName(), (Object)new IWindowCloseHandler(){

                public boolean close(MWindow window) {
                    EPartService partService = (EPartService)window.getContext().get(EPartService.class.getName());
                    return partService.saveAll(true);
                }
            });
        }
    }

    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        Widget widget = (Widget)me.getWidget();
        if (widget instanceof Shell && me instanceof MWindow) {
            final Shell shell = (Shell)widget;
            final MWindow w = (MWindow)me;
            shell.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    if (shell.getMaximized()) {
                        return;
                    }
                    try {
                        RienaWBWRenderer.this.ignoreSizeChanges = true;
                        w.setWidth(shell.getSize().x);
                        w.setHeight(shell.getSize().y);
                    }
                    finally {
                        RienaWBWRenderer.this.ignoreSizeChanges = false;
                    }
                }

                public void controlMoved(ControlEvent e) {
                    if (shell.getMaximized()) {
                        return;
                    }
                    try {
                        RienaWBWRenderer.this.ignoreSizeChanges = true;
                        w.setX(shell.getLocation().x);
                        w.setY(shell.getLocation().y);
                    }
                    finally {
                        RienaWBWRenderer.this.ignoreSizeChanges = false;
                    }
                }
            });
            shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    e.doit = false;
                    MWindow window = (MWindow)e.widget.getData("modelElement");
                    IWindowCloseHandler closeHandler = (IWindowCloseHandler)window.getContext().get(IWindowCloseHandler.class.getName());
                    if (closeHandler == null || closeHandler.close(window)) {
                        RienaWBWRenderer.this.cleanUp(window);
                    }
                }
            });
            shell.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    MElementContainer parentME = w.getParent();
                    if (parentME instanceof MApplication) {
                        MApplication app = (MApplication)parentME;
                        app.setSelectedElement((MUIElement)w);
                        w.getContext().activate();
                    } else if (parentME == null && (parentME = (MUIElement)((EObject)w).eContainer()) instanceof MContext) {
                        w.getContext().activate();
                    }
                }
            });
        }
    }

    private void cleanUp(MWindow window) {
        EObject parent = ((EObject)window).eContainer();
        if (parent instanceof MApplication) {
            MApplication application = (MApplication)parent;
            List children = application.getChildren();
            if (children.size() > 1) {
                window.setToBeRendered(false);
                children.remove(window);
            } else {
                this.engine.removeGui((MUIElement)window);
            }
        } else if (parent != null) {
            window.setToBeRendered(false);
            if (this.modelService.findElements((MUIElement)window, null, MPart.class, null).isEmpty()) {
                if (parent instanceof MWindow) {
                    ((MWindow)parent).getWindows().remove(window);
                } else if (parent instanceof MPerspective) {
                    ((MPerspective)parent).getWindows().remove(window);
                }
            }
        }
    }

    public void processContents(MElementContainer me) {
        Shell shell;
        if (!(me instanceof MWindow)) {
            return;
        }
        MWindow wbwModel = (MWindow)me;
        super.processContents(me);
        IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class.getName());
        if (wbwModel.getMainMenu() != null) {
            renderer.createGui((MUIElement)wbwModel.getMainMenu(), me.getWidget(), null);
            shell = (Shell)me.getWidget();
            shell.setMenuBar((Menu)wbwModel.getMainMenu().getWidget());
        }
        for (MWindow dw : wbwModel.getWindows()) {
            renderer.createGui((MUIElement)dw, me.getWidget(), wbwModel.getContext());
        }
        if (wbwModel instanceof MTrimmedWindow) {
            shell = (Shell)wbwModel.getWidget();
            MTrimmedWindow tWindow = (MTrimmedWindow)wbwModel;
            for (MTrimBar trimBar : tWindow.getTrimBars()) {
                renderer.createGui((MUIElement)trimBar, (Object)shell, wbwModel.getContext());
            }
        }
        this.rienaActivateApplicationNode();
    }

    private void rienaActivateApplicationNode() {
        Realm realm = SWTObservables.getRealm((Display)Display.getCurrent());
        Realm.runWithDefault((Realm)realm, (Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationNodeManager.getApplicationNode().activate();
            }
        });
    }

    public Object getUIContainer(MUIElement element) {
        MElementContainer parent = element.getParent();
        if (parent == null) {
            parent = (MUIElement)((EObject)element).eContainer();
            return parent == null ? null : parent.getWidget();
        }
        String elementId = element.getElementId();
        if ("org.eclipse.riena.e4.launcher.headerPart".equals(elementId)) {
            return this.header;
        }
        if ("org.eclipse.riena.e4.launcher.mainMenuPart".equals(elementId)) {
            return this.mainMenu;
        }
        if ("org.eclipse.riena.e4.launcher.mainToolBarPart".equals(elementId)) {
            return this.mainToolBar;
        }
        if ("org.eclipse.riena.e4.launcher.statusLinePart".equals(elementId)) {
            return this.statusLine;
        }
        if ("org.eclipse.riena.e4.launcher.perspectiveStack".equals(elementId)) {
            return this.perspectiveStack;
        }
        return null;
    }

    public void postProcess(MUIElement shellME) {
        super.postProcess(shellME);
        Shell shell = (Shell)shellME.getWidget();
        final MUIElement disposeME = shellME;
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Shell shell = (Shell)e.widget;
                if (disposeME != null) {
                    disposeME.getTags().remove(ShellMinimizedTag);
                    disposeME.getTags().remove(ShellMaximizedTag);
                    if (shell.getMinimized()) {
                        disposeME.getTags().add(ShellMinimizedTag);
                    }
                    if (shell.getMaximized()) {
                        disposeME.getTags().add(ShellMaximizedTag);
                    }
                }
            }
        });
        if (shellME.getTags().contains(ShellMaximizedTag)) {
            shell.setMaximized(true);
        } else if (shellME.getTags().contains(ShellMinimizedTag)) {
            shell.setMinimized(true);
        }
        shell.layout(true);
        if (shellME.isVisible()) {
            shell.open();
        } else {
            shell.setVisible(false);
        }
    }

    private Object[] promptForSave(Shell parentShell, Collection<MPart> saveableParts) {
        SaveablePartPromptDialog dialog = new SaveablePartPromptDialog(parentShell, saveableParts);
        if (dialog.open() == 1) {
            return null;
        }
        return dialog.getCheckedElements();
    }

    private void applyDialogStyles(Control control) {
        IStylingEngine engine = (IStylingEngine)this.context.get(IStylingEngine.SERVICE_NAME);
        if (engine != null) {
            Shell shell = control.getShell();
            if (shell.getBackgroundMode() == 0) {
                shell.setBackgroundMode(1);
            }
            engine.style((Object)shell);
        }
    }

    class SaveablePartPromptDialog
    extends Dialog {
        private final Collection<MPart> collection;
        private CheckboxTableViewer tableViewer;
        private Object[] checkedElements;

        SaveablePartPromptDialog(Shell shell, Collection<MPart> collection) {
            super(shell);
            this.checkedElements = new Object[0];
            this.collection = collection;
        }

        protected Control createDialogArea(Composite parent) {
            parent = (Composite)super.createDialogArea(parent);
            Label label = new Label(parent, 16384);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label.setText("Select the parts to save:");
            this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 250;
            data.widthHint = 300;
            this.tableViewer.getControl().setLayoutData((Object)data);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((MPart)element).getLocalizedLabel();
                }
            });
            this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.tableViewer.setInput(this.collection);
            this.tableViewer.setAllChecked(true);
            return parent;
        }

        public void create() {
            super.create();
            RienaWBWRenderer.this.applyDialogStyles((Control)this.getShell());
        }

        protected void okPressed() {
            this.checkedElements = this.tableViewer.getCheckedElements();
            super.okPressed();
        }

        public Object[] getCheckedElements() {
            return this.checkedElements;
        }
    }

    private class WindowSizeUpdateJob
    implements Runnable {
        public List<MWindow> windowsToUpdate = new ArrayList<MWindow>();

        private WindowSizeUpdateJob() {
        }

        @Override
        public void run() {
            RienaWBWRenderer.this.clearSizeUpdate();
            while (!this.windowsToUpdate.isEmpty()) {
                MWindow window = this.windowsToUpdate.remove(0);
                Shell shell = (Shell)window.getWidget();
                if (shell == null || shell.isDisposed()) continue;
                shell.setBounds(window.getX(), window.getY(), window.getWidth(), window.getHeight());
            }
        }
    }
}

