/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.services;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.riena.core.RienaActivator;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.security.authenticationservice.AuthenticationService;
import org.eclipse.riena.internal.security.authorizationservice.AuthorizationService;
import org.eclipse.riena.internal.security.sessionservice.SessionService;
import org.eclipse.riena.security.common.authentication.IAuthenticationService;
import org.eclipse.riena.security.common.authorization.IAuthorizationService;
import org.eclipse.riena.security.server.session.ISessionService;
import org.eclipse.riena.security.sessionservice.ISessionProvider;
import org.eclipse.riena.security.sessionservice.SessionProvider;
import org.osgi.framework.BundleContext;

public class Activator
extends RienaActivator {
    public static final String PLUGIN_ID = "org.eclipse.riena.security.services";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.createAuthenticationServiceAndWire();
        this.createAuthorizationServiceAndWire();
        this.createSessionServiceAndWire();
        this.createSessionProvider();
    }

    private void createAuthenticationServiceAndWire() {
        AuthenticationService authenticationService = new AuthenticationService();
        Wire.instance((Object)authenticationService).andStart();
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", "hessian");
        properties.put("riena.remote.path", "/AuthenticationService");
        this.getContext().registerService(IAuthenticationService.class.getName(), (Object)authenticationService, (Dictionary)properties);
    }

    private void createAuthorizationServiceAndWire() {
        AuthorizationService authorizationService = new AuthorizationService();
        Wire.instance((Object)authorizationService).andStart();
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", "hessian");
        properties.put("riena.remote.path", "/AuthorizationService");
        this.getContext().registerService(IAuthorizationService.class.getName(), (Object)authorizationService, (Dictionary)properties);
    }

    private void createSessionServiceAndWire() {
        SessionService sessionService = new SessionService();
        Wire.instance((Object)sessionService).andStart();
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", "hessian");
        properties.put("riena.remote.path", "/SessionService");
        this.getContext().registerService(ISessionService.class.getName(), (Object)sessionService, (Dictionary)properties);
    }

    private void createSessionProvider() {
        this.getContext().registerService(ISessionProvider.class.getName(), (Object)new SessionProvider(), (Dictionary)RienaConstants.newDefaultServiceProperties());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

