/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core;

import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.ManualTestCase;
import org.eclipse.riena.sample.app.common.BigIntegerContainer;
import org.eclipse.riena.sample.app.common.ITestcasesWS;

@ManualTestCase
public final class TestcasesWSITest
extends RienaTestCase {
    private ITestcasesWS testcasesService;
    private IRemoteServiceRegistration regTestcases;

    public void setUp() throws Exception {
        super.setUp();
        this.regTestcases = Register.remoteProxy(ITestcasesWS.class).usingUrl("http://localhost:8080/hessian/TestcasesWS").withProtocol("hessian").andStart(this.getContext());
        this.testcasesService = (ITestcasesWS)this.getContext().getService(this.getContext().getServiceReference(ITestcasesWS.class.getName()));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.regTestcases.unregister();
        this.testcasesService = null;
    }

    public void testBigInteger() {
        BigInteger bigInteger = new BigInteger(80, new Random());
        BigInteger result = this.testcasesService.echoBigInteger(bigInteger);
        TestcasesWSITest.assertNotNull((String)"result must not be null", (Object)result);
        TestcasesWSITest.assertEquals((String)"result and echo must be equal", (Object)result, (Object)bigInteger);
    }

    public void testXMLGregorianCalendarImpl() {
        XMLGregorianCalendarImpl xmlGregorianCalendarImpl = new XMLGregorianCalendarImpl(new GregorianCalendar());
        XMLGregorianCalendar result = this.testcasesService.echoXMLGregorianCalendar((XMLGregorianCalendar)xmlGregorianCalendarImpl);
        TestcasesWSITest.assertNotNull((String)"result must not be null", (Object)result);
        TestcasesWSITest.assertTrue((String)"result must be instance of XMLGregorianCalendarImpl", (boolean)(result instanceof XMLGregorianCalendarImpl));
        XMLGregorianCalendarImpl result2 = (XMLGregorianCalendarImpl)result;
        TestcasesWSITest.assertEquals((String)"result and echo must be equal", (Object)result2, (Object)xmlGregorianCalendarImpl);
    }

    public void testBigIntegerWithNullValue() {
        BigInteger bigInteger = null;
        BigInteger result = this.testcasesService.echoNullBigInteger(bigInteger);
        TestcasesWSITest.assertNull((String)"result must be null", (Object)result);
        TestcasesWSITest.assertNull((String)"result must be null", bigInteger);
    }

    public void testBigIntegerHashMap() {
        HashMap<String, BigInteger> hashMap = new HashMap<String, BigInteger>();
        Random random = new Random();
        int i = 0;
        while (i < 10) {
            BigInteger bigInteger = new BigInteger(80, random);
            hashMap.put(Integer.valueOf(random.nextInt()).toString(), bigInteger);
            ++i;
        }
        HashMap result = this.testcasesService.echoBigIntegerHashMap(hashMap);
        TestcasesWSITest.assertNotNull((String)"result must be not null", (Object)result);
        TestcasesWSITest.assertEquals((String)"hashmaps must be equal", (Object)result, hashMap);
    }

    public void testBigIntegerList() {
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        Random random = new Random();
        int i = 0;
        while (i < 10) {
            BigInteger bigInteger = new BigInteger(80, random);
            list.add(bigInteger);
            ++i;
        }
        List result = this.testcasesService.echoBigIntegerList(list);
        TestcasesWSITest.assertNotNull((String)"result must be not null", (Object)result);
        TestcasesWSITest.assertEquals((String)"lists must be equal", (Object)result, list);
    }

    public void testBigIntegerContainer() {
        Random random = new Random();
        BigIntegerContainer bigIntegerContainer = new BigIntegerContainer(new BigInteger(10, random), new BigInteger(30, random), "name4711");
        BigIntegerContainer result = this.testcasesService.echoBigIntegerContainer(bigIntegerContainer);
        TestcasesWSITest.assertNotNull((String)"result must not be null", (Object)result);
        TestcasesWSITest.assertEquals((String)"result and echo must be equal", (Object)result, (Object)bigIntegerContainer);
    }
}

