/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.ping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.riena.core.ping.IPingable;
import org.eclipse.riena.core.ping.PingFingerprint;
import org.eclipse.riena.core.ping.PingMethodAdapter;
import org.eclipse.riena.core.ping.PingResult;
import org.eclipse.riena.core.ping.PingVisitor;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class PingVisitorTest
extends RienaTestCase {
    private PingMock mock1;
    private PingMock mock2;
    private PingMock mock3;
    private PingMock mock4;
    private PingMock mock5;

    public PingVisitorTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testVisitWithFailureInPing() throws Exception {
        this.mock4 = new PingMock();
        this.mock5 = new PingMock();
        this.mock3 = new PingMockWithPingMethods(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            {
                this.pingable1 = PingVisitorTest.this.mock4;
                this.pingable2 = PingVisitorTest.this.mock5;
            }
        };
        this.mock2 = new PingMock();
        this.mock1 = new PingMock(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            {
                this.pingable1 = PingVisitorTest.this.mock2;
                this.pingable2 = PingVisitorTest.this.mock3;
            }
        };
        this.mock4.letPingFail();
        PingMethodAdapter mock3PingDB = new PingMethodAdapter((IPingable)this.mock3, PingMockWithPingMethods.class.getDeclaredMethod("pingDB", new Class[0]));
        PingVisitor visitor = new PingVisitor();
        visitor = visitor.ping((IPingable)this.mock1);
        PingVisitorTest.assertNotNull((Object)visitor);
        List pingResults = visitor.getPingResults();
        this.assertResultContainsAll(pingResults, this.mock1);
        PingResult mock1Result = this.getPingResultFor(this.mock1, pingResults);
        PingVisitorTest.assertNull((Object)mock1Result.getPingFailure());
        this.assertResultContainsAll(mock1Result.getNestedResults(), this.mock2, this.mock3);
        PingResult mock2Result = this.getPingResultFor(this.mock2, mock1Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock2Result.getPingFailure());
        this.assertResultContainsAll(mock2Result.getNestedResults(), new IPingable[0]);
        PingResult mock3Result = this.getPingResultFor(this.mock3, mock1Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock3Result.getPingFailure());
        this.assertResultContainsAll(mock3Result.getNestedResults(), new IPingable[]{this.mock4, this.mock5, mock3PingDB});
        PingResult mock4Result = this.getPingResultFor(this.mock4, mock3Result.getNestedResults());
        this.assertPingFailureContains(mock4Result, "RuntimeException", "ping");
        this.assertResultContainsAll(mock4Result.getNestedResults(), new IPingable[0]);
        PingResult mock5Result = this.getPingResultFor(this.mock5, mock3Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock5Result.getPingFailure());
        this.assertResultContainsAll(mock5Result.getNestedResults(), new IPingable[0]);
        PingResult mock3PingDBResult = this.getPingResultFor((IPingable)mock3PingDB, mock3Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock3PingDBResult.getPingFailure());
        this.assertResultContainsAll(mock3PingDBResult.getNestedResults(), new IPingable[0]);
    }

    public void testVisitWithFailureInPingMethod() throws Exception {
        this.mock4 = new PingMock();
        this.mock5 = new PingMock();
        this.mock3 = new PingMockWithPingMethods(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            {
                this.pingable1 = PingVisitorTest.this.mock4;
                this.pingable2 = PingVisitorTest.this.mock5;
            }
        };
        this.mock2 = new PingMock();
        this.mock1 = new PingMock(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            {
                this.pingable1 = PingVisitorTest.this.mock2;
                this.pingable2 = PingVisitorTest.this.mock3;
            }
        };
        ((PingMockWithPingMethods)this.mock3).letPingDBFail();
        PingMethodAdapter mock3PingDB = new PingMethodAdapter((IPingable)this.mock3, PingMockWithPingMethods.class.getDeclaredMethod("pingDB", new Class[0]));
        PingVisitor visitor = new PingVisitor();
        visitor = visitor.ping((IPingable)this.mock1);
        PingVisitorTest.assertNotNull((Object)visitor);
        List pingResults = visitor.getPingResults();
        this.assertResultContainsAll(pingResults, this.mock1);
        PingResult mock1Result = this.getPingResultFor(this.mock1, pingResults);
        PingVisitorTest.assertNull((Object)mock1Result.getPingFailure());
        this.assertResultContainsAll(mock1Result.getNestedResults(), this.mock2, this.mock3);
        PingResult mock2Result = this.getPingResultFor(this.mock2, mock1Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock2Result.getPingFailure());
        this.assertResultContainsAll(mock2Result.getNestedResults(), new IPingable[0]);
        PingResult mock3Result = this.getPingResultFor(this.mock3, mock1Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock3Result.getPingFailure());
        this.assertResultContainsAll(mock3Result.getNestedResults(), new IPingable[]{this.mock4, this.mock5, mock3PingDB});
        PingResult mock4Result = this.getPingResultFor(this.mock4, mock3Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock4Result.getPingFailure());
        this.assertResultContainsAll(mock4Result.getNestedResults(), new IPingable[0]);
        PingResult mock5Result = this.getPingResultFor(this.mock5, mock3Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock5Result.getPingFailure());
        this.assertResultContainsAll(mock5Result.getNestedResults(), new IPingable[0]);
        PingResult mock3PingDBResult = this.getPingResultFor((IPingable)mock3PingDB, mock3Result.getNestedResults());
        this.assertPingFailureContains(mock3PingDBResult, "RuntimeException", "pingDB");
        this.assertResultContainsAll(mock3PingDBResult.getNestedResults(), new IPingable[0]);
    }

    public void testVisitWithCycle() {
        this.mock4 = new PingMock();
        this.mock5 = new PingMock(){
            private final IPingable pingable1 = this;
        };
        this.mock3 = new PingMockWithPingMethods(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            {
                this.pingable1 = PingVisitorTest.this.mock4;
                this.pingable2 = PingVisitorTest.this.mock5;
            }
        };
        this.mock2 = new PingMock(){
            private final IPingable pingable1 = this;
        };
        this.mock1 = new PingMock(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            {
                this.pingable1 = PingVisitorTest.this.mock2;
                this.pingable2 = PingVisitorTest.this.mock3;
            }
        };
        PingVisitor visitor = new PingVisitor();
        this.mock1.ping(visitor);
        this.mock1.verify();
        this.mock2.verify();
        this.mock3.verify();
        this.mock4.verify();
        this.mock5.verify();
    }

    public void testVisit() {
        this.mock4 = new PingMock();
        this.mock5 = new PingMock();
        this.mock3 = new PingMockWithPingMethods(){
            private final IPingable pingable1;
            {
                this.pingable1 = PingVisitorTest.this.mock4;
            }

            private Iterable<IPingable> getAdditionalPingables() {
                return Arrays.asList(PingVisitorTest.this.mock5);
            }
        };
        this.mock2 = new PingMock();
        this.mock1 = new PingMock(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            {
                this.pingable1 = PingVisitorTest.this.mock2;
                this.pingable2 = PingVisitorTest.this.mock3;
            }
        };
        PingVisitor visitor = new PingVisitor();
        this.mock1.ping(visitor);
        this.mock1.verify();
        this.mock2.verify();
        this.mock3.verify();
        this.mock4.verify();
        this.mock5.verify();
    }

    public void testVisitorReturnsThis() {
        this.mock1 = new PingMock();
        PingVisitor visitor = new PingVisitor();
        PingVisitor result = this.mock1.ping(visitor);
        PingVisitorTest.assertSame((Object)visitor, (Object)result);
        this.mock1.verify();
    }

    public void testGetChildPingablesOf() {
        this.mock4 = new PingMock();
        this.mock5 = new PingMock();
        this.mock3 = new PingMock();
        this.mock2 = new PingMock();
        this.mock1 = new PingMockWithPingMethods(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            {
                this.pingable1 = PingVisitorTest.this.mock2;
                this.pingable2 = PingVisitorTest.this.mock3;
            }

            private Iterable<IPingable> getAdditionalPingables() {
                return Arrays.asList(PingVisitorTest.this.mock4, PingVisitorTest.this.mock5);
            }
        };
        PingVisitor visitor = new PingVisitor();
        Collection set = visitor.getChildPingablesOf((IPingable)this.mock1);
        PingVisitorTest.assertEquals((int)5, (int)set.size());
        PingVisitorTest.assertTrue((boolean)set.remove(this.mock2));
        PingVisitorTest.assertTrue((boolean)set.remove(this.mock3));
        PingVisitorTest.assertTrue((boolean)set.remove(this.mock4));
        PingVisitorTest.assertTrue((boolean)set.remove(this.mock5));
        IPingable pingable = (IPingable)set.iterator().next();
        PingVisitorTest.assertTrue((boolean)(pingable instanceof PingMethodAdapter));
        pingable.ping(visitor);
        PingVisitorTest.assertTrue((boolean)((PingMockWithPingMethods)this.mock1).isPingDBCalled());
    }

    public void testCollectPingMethods() {
        PingVisitor visitor = new PingVisitor();
        PingMockWithPingMethods mock = new PingMockWithPingMethods();
        HashSet set = new HashSet();
        visitor.collectPingMethods((IPingable)mock, set);
        PingVisitorTest.assertEquals((int)1, (int)set.size());
        ((IPingable)set.iterator().next()).ping(visitor);
        PingVisitorTest.assertEquals((boolean)true, (boolean)mock.isPingDBCalled());
    }

    public void testCollectPingableMembers() {
        this.mock3 = new PingMock();
        this.mock2 = new PingMock();
        PingMock mock1 = new PingMock(){
            private final IPingable pingable1;
            private final IPingable pingable2;
            private final IPingable pingable3;
            {
                this.pingable1 = PingVisitorTest.this.mock2;
                this.pingable2 = PingVisitorTest.this.mock3;
                this.pingable3 = null;
            }
        };
        HashSet set = new HashSet();
        PingVisitor visitor = new PingVisitor();
        visitor.collectPingableMembers((IPingable)mock1, set);
        PingVisitorTest.assertEquals((int)2, (int)set.size());
        PingVisitorTest.assertTrue((boolean)set.contains(this.mock2));
        PingVisitorTest.assertTrue((boolean)set.contains(this.mock3));
    }

    public void testCollectAdditionalPingables() {
        this.mock3 = new PingMock();
        this.mock2 = new PingMock();
        PingMock mock1 = new PingMock(){

            private Iterable<IPingable> getAdditionalPingables() {
                return Arrays.asList(PingVisitorTest.this.mock2, PingVisitorTest.this.mock3);
            }
        };
        HashSet set = new HashSet();
        PingVisitor visitor = new PingVisitor();
        visitor.collectAdditionalPingables((IPingable)mock1, set);
        PingVisitorTest.assertEquals((int)2, (int)set.size());
        PingVisitorTest.assertTrue((boolean)set.contains(this.mock2));
        PingVisitorTest.assertTrue((boolean)set.contains(this.mock3));
    }

    public void testCollectAdditionalPingablesWithWildcards() {
        this.mock3 = new PingMock();
        this.mock2 = new PingMock();
        PingMock mock1 = new PingMock(){

            private Iterable<? extends IPingable> getAdditionalPingables() {
                return Arrays.asList(PingVisitorTest.this.mock2, PingVisitorTest.this.mock3);
            }
        };
        HashSet set = new HashSet();
        PingVisitor visitor = new PingVisitor();
        visitor.collectAdditionalPingables((IPingable)mock1, set);
        PingVisitorTest.assertEquals((int)2, (int)set.size());
        PingVisitorTest.assertTrue((boolean)set.contains(this.mock2));
        PingVisitorTest.assertTrue((boolean)set.contains(this.mock3));
    }

    public void testGetGetPingResults() throws Exception {
        this.mock4 = new PingMock();
        this.mock5 = new PingMock();
        this.mock3 = new PingMockWithPingMethods(){
            private final IPingable pingable1;
            {
                this.pingable1 = PingVisitorTest.this.mock4;
            }

            private Iterable<IPingable> getAdditionalPingables() {
                return Arrays.asList(PingVisitorTest.this.mock5);
            }
        };
        this.mock2 = new PingMock();
        this.mock1 = new PingMock(){
            private final IPingable pingable2;
            private final IPingable pingable1;
            {
                this.pingable2 = PingVisitorTest.this.mock3;
                this.pingable1 = PingVisitorTest.this.mock2;
            }
        };
        PingMethodAdapter mock3PingDB = new PingMethodAdapter((IPingable)this.mock3, PingMockWithPingMethods.class.getDeclaredMethod("pingDB", new Class[0]));
        PingVisitor visitor = new PingVisitor();
        visitor = visitor.ping((IPingable)this.mock1);
        PingVisitorTest.assertNotNull((Object)visitor);
        List pingResults = visitor.getPingResults();
        this.assertResultContainsAll(pingResults, this.mock1);
        PingResult mock1Result = this.getPingResultFor(this.mock1, pingResults);
        PingVisitorTest.assertNull((Object)mock1Result.getPingFailure());
        this.assertResultContainsAll(mock1Result.getNestedResults(), this.mock2, this.mock3);
        PingResult mock2Result = this.getPingResultFor(this.mock2, mock1Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock2Result.getPingFailure());
        this.assertResultContainsAll(mock2Result.getNestedResults(), new IPingable[0]);
        PingResult mock3Result = this.getPingResultFor(this.mock3, mock1Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock3Result.getPingFailure());
        this.assertResultContainsAll(mock3Result.getNestedResults(), new IPingable[]{this.mock4, this.mock5, mock3PingDB});
        PingResult mock4Result = this.getPingResultFor(this.mock4, mock3Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock4Result.getPingFailure());
        this.assertResultContainsAll(mock4Result.getNestedResults(), new IPingable[0]);
        PingResult mock5Result = this.getPingResultFor(this.mock5, mock3Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock5Result.getPingFailure());
        this.assertResultContainsAll(mock5Result.getNestedResults(), new IPingable[0]);
        PingResult mock3PingDBResult = this.getPingResultFor((IPingable)mock3PingDB, mock3Result.getNestedResults());
        PingVisitorTest.assertNull((Object)mock3PingDBResult.getPingFailure());
        this.assertResultContainsAll(mock3PingDBResult.getNestedResults(), new IPingable[0]);
    }

    private void assertResultContainsAll(Iterable<PingResult> resultList, IPingable ... expected) {
        PingVisitorTest.assertNotNull(resultList);
        int size = 0;
        IPingable[] iPingableArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            IPingable pingable = iPingableArray[n2];
            ++size;
            this.assertResultContains(resultList, pingable);
            ++n2;
        }
        PingVisitorTest.assertEquals((int)expected.length, (int)size);
    }

    private PingResult assertResultContains(Iterable<PingResult> resultList, IPingable expected) {
        PingResult pingResult = this.getPingResultFor(expected, resultList);
        if (pingResult == null) {
            PingVisitorTest.fail((String)("Pingable " + expected + " not contained in " + resultList));
        }
        return pingResult;
    }

    private PingResult getPingResultFor(IPingable pingable, Iterable<PingResult> resultList) {
        for (PingResult pingResult : resultList) {
            if (!pingResult.getPingableName().equals(pingable.getPingFingerprint().getName())) continue;
            return pingResult;
        }
        return null;
    }

    private void assertPingFailureContains(PingResult pingResult, String ... failureParts) {
        PingVisitorTest.assertNotNull((String)("expected failures '" + failureParts + "' but is <null>"), (Object)pingResult.getPingFailure());
        String[] stringArray = failureParts;
        int n = failureParts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            PingVisitorTest.assertTrue((String)(String.valueOf(part) + " not contained in failure message '" + pingResult.getPingFailure() + "'"), (boolean)pingResult.getPingFailure().contains(part));
            ++n2;
        }
    }

    private List<String> getFingerprintNames(List<PingResult> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (PingResult pingResult : list) {
            result.add(pingResult.getPingableName());
        }
        return result;
    }

    protected static class PingMock
    implements IPingable {
        private boolean pingCalled;
        private boolean expectPingCalled = true;
        private boolean fail;

        protected PingMock() {
        }

        public void setExpectPingCalled(boolean expectation) {
            this.expectPingCalled = expectation;
        }

        public void letPingFail() {
            this.fail = true;
        }

        public void reset() {
            this.pingCalled = false;
            this.expectPingCalled = true;
            this.fail = false;
        }

        public void verify() {
            PingVisitorTest.assertEquals((boolean)this.expectPingCalled, (boolean)this.pingCalled);
        }

        public PingVisitor ping(PingVisitor visitor) {
            this.pingCalled = true;
            if (this.fail) {
                throw PingMock.newException();
            }
            return visitor.visit((IPingable)this);
        }

        public static RuntimeException newException() {
            return new RuntimeException("ping");
        }

        public PingFingerprint getPingFingerprint() {
            return new PingFingerprint((IPingable)this, false);
        }
    }

    protected static class PingMockWithPingMethods
    extends PingMock {
        private boolean pingdbCalled;
        private boolean expectPingDBCalled = true;
        private boolean pingDBFail;

        protected PingMockWithPingMethods() {
        }

        public void setExpectPingDBCalled(boolean expectation) {
            this.expectPingDBCalled = expectation;
        }

        protected void pingDB() {
            if (this.pingdbCalled) {
                throw new AssertionError((Object)("pingDB() already called on " + this.getPingFingerprint()));
            }
            this.pingdbCalled = true;
            if (this.pingDBFail) {
                throw new RuntimeException("pingDB");
            }
        }

        public void letPingDBFail() {
            this.pingDBFail = true;
        }

        protected boolean isPingDBCalled() {
            return this.pingdbCalled;
        }

        @Override
        public void reset() {
            super.reset();
            this.pingdbCalled = false;
            this.expectPingDBCalled = true;
            this.pingDBFail = false;
        }

        @Override
        public void verify() {
            super.verify();
            PingVisitorTest.assertEquals((boolean)this.expectPingDBCalled, (boolean)this.pingdbCalled);
        }

        protected void pingarassabum() {
            throw new AssertionError((Object)"Not allowed");
        }
    }
}

