/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.CloseModuleGroup;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.ISubApplicationNode;

@NonUITestCase
public class CloseModuleGroupTest
extends RienaTestCase {
    private CloseModuleGroup handler;
    private IApplicationNode appNode;
    private ISubApplicationNode subApp1;
    private IModuleGroupNode a1ModuleGroup1;
    private IModuleGroupNode a1ModuleGroup2;
    private ISubApplicationNode subApp2;
    private IModuleGroupNode a2ModuleGroup1;

    protected void setUp() throws Exception {
        super.setUp();
        this.handler = new CloseModuleGroup();
        this.appNode = (IApplicationNode)EasyMock.createMock(IApplicationNode.class);
        this.subApp1 = (ISubApplicationNode)EasyMock.createMock(ISubApplicationNode.class);
        this.subApp2 = (ISubApplicationNode)EasyMock.createMock(ISubApplicationNode.class);
        this.a1ModuleGroup1 = (IModuleGroupNode)EasyMock.createMock(IModuleGroupNode.class);
        this.a1ModuleGroup2 = (IModuleGroupNode)EasyMock.createMock(IModuleGroupNode.class);
        this.a2ModuleGroup1 = (IModuleGroupNode)EasyMock.createMock(IModuleGroupNode.class);
    }

    public void testFindModuleGroup() {
        EasyMock.expect((Object)this.appNode.getChildren()).andReturn(Arrays.asList(this.subApp1, this.subApp2));
        EasyMock.expect((Object)this.subApp1.isActivated()).andReturn((Object)false);
        EasyMock.expect((Object)this.subApp2.isActivated()).andReturn((Object)true);
        EasyMock.expect((Object)this.subApp2.getChildren()).andReturn(Arrays.asList(this.a2ModuleGroup1));
        EasyMock.expect((Object)this.a2ModuleGroup1.isActivated()).andReturn((Object)true);
        this.enableReplay();
        CloseModuleGroupTest.assertSame((Object)this.a2ModuleGroup1, (Object)this.handler.findModuleGroup(this.appNode));
    }

    public void testFindModuleGroup_NoSubApps() {
        EasyMock.expect((Object)this.appNode.getChildren()).andReturn(new ArrayList());
        this.enableReplay();
        CloseModuleGroupTest.assertNull((Object)this.handler.findModuleGroup(this.appNode));
    }

    public void testFindModuleGroup_NoGroups() {
        EasyMock.expect((Object)this.appNode.getChildren()).andReturn(Arrays.asList(this.subApp1, this.subApp2));
        EasyMock.expect((Object)this.subApp1.isActivated()).andReturn((Object)true);
        EasyMock.expect((Object)this.subApp1.getChildren()).andReturn(new ArrayList());
        this.enableReplay();
        CloseModuleGroupTest.assertNull((Object)this.handler.findModuleGroup(this.appNode));
    }

    public void testFindModuleGroup_NoActiveGroups() {
        EasyMock.expect((Object)this.appNode.getChildren()).andReturn(Arrays.asList(this.subApp1, this.subApp2));
        EasyMock.expect((Object)this.subApp1.isActivated()).andReturn((Object)true);
        EasyMock.expect((Object)this.subApp1.getChildren()).andReturn(Arrays.asList(this.a1ModuleGroup1, this.a1ModuleGroup2));
        EasyMock.expect((Object)this.a1ModuleGroup1.isActivated()).andReturn((Object)false);
        EasyMock.expect((Object)this.a1ModuleGroup2.isActivated()).andReturn((Object)false);
        this.enableReplay();
        CloseModuleGroupTest.assertNull((Object)this.handler.findModuleGroup(this.appNode));
    }

    private void enableReplay() {
        EasyMock.replay((Object[])new Object[]{this.appNode, this.subApp1, this.subApp2, this.a1ModuleGroup1, this.a1ModuleGroup2, this.a2ModuleGroup1});
    }
}

