/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import junit.framework.TestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubModuleNode;

@NonUITestCase
public class ModuleNodeTest
extends TestCase {
    public void testCalcDepthNoChild() {
        ModuleNode module = new ModuleNode();
        ModuleNodeTest.assertEquals((int)0, (int)module.calcDepth());
    }

    public void testCalcDepthOneChild() {
        ModuleNode module = new ModuleNode();
        SubModuleNode sm = new SubModuleNode(new NavigationNodeId("module1"));
        module.addChild((INavigationNode)sm);
        ModuleNodeTest.assertEquals((int)0, (int)module.calcDepth());
    }

    public void testCalcDepthTwoChilds() {
        ModuleNode module = new ModuleNode();
        SubModuleNode sm = new SubModuleNode(new NavigationNodeId("subModule1"));
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("subModule2"));
        module.addChild((INavigationNode)sm);
        module.addChild((INavigationNode)sm2);
        ModuleNodeTest.assertEquals((int)2, (int)module.calcDepth());
    }

    public void testCalcDepthTwoChildsAndExpanded() {
        ModuleNode module = new ModuleNode();
        SubModuleNode sm = new SubModuleNode(new NavigationNodeId("subModule1"));
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("subModule2"));
        module.addChild((INavigationNode)sm);
        module.addChild((INavigationNode)sm2);
        ModuleNodeTest.assertEquals((int)2, (int)module.calcDepth());
        SubModuleNode sm21 = new SubModuleNode(new NavigationNodeId("module21"));
        sm21.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        sm2.addChild((INavigationNode)sm21);
        ModuleNodeTest.assertEquals((int)2, (int)module.calcDepth());
        sm2.setExpanded(true);
        ModuleNodeTest.assertEquals((int)3, (int)module.calcDepth());
    }

    public void testCalcDepthTwoChildsAndSetVisible() {
        ModuleNode module = new ModuleNode();
        NavigationProcessor navigationProcessor = new NavigationProcessor();
        SubModuleNode sm = new SubModuleNode(new NavigationNodeId("subModule1"));
        sm.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("subModule2"));
        sm2.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        SubModuleNode sm3 = new SubModuleNode(new NavigationNodeId("subModule3"));
        sm3.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        module.addChild((INavigationNode)sm);
        module.addChild((INavigationNode)sm2);
        module.addChild((INavigationNode)sm3);
        ModuleNodeTest.assertEquals((int)3, (int)module.calcDepth());
        sm3.setVisible(false);
        ModuleNodeTest.assertEquals((int)2, (int)module.calcDepth());
    }

    public void testCalcDepthTwoChildsAndInvisibleWithSubChilds() {
        ModuleNode module = new ModuleNode();
        NavigationProcessor navigationProcessor = new NavigationProcessor();
        SubModuleNode sm = new SubModuleNode(new NavigationNodeId("subModule1"));
        sm.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        sm.setVisible(false);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("subModule2"));
        sm2.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        sm2.setExpanded(true);
        SubModuleNode sm21 = new SubModuleNode(new NavigationNodeId("subModule2.1"));
        sm21.setNavigationProcessor((INavigationProcessor)navigationProcessor);
        module.addChild((INavigationNode)sm);
        module.addChild((INavigationNode)sm2);
        sm2.addChild((INavigationNode)sm21);
        ModuleNodeTest.assertEquals((int)2, (int)module.calcDepth());
    }

    public void testIsPresentSubModules() throws Exception {
        SubModuleNode childOne = new SubModuleNode(new NavigationNodeId("nodeOne"));
        childOne.setVisible(false);
        SubModuleNode childTwo = new SubModuleNode(new NavigationNodeId("nodeTwo"));
        ModuleNode module = new ModuleNode();
        module.addChild((INavigationNode)childOne);
        module.addChild((INavigationNode)childTwo);
        ModuleNodeTest.assertFalse((boolean)module.isPresentSubModules());
    }
}

