/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.ILnfRendererExtension;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ModuleGroupViewTest
extends TestCase {
    private ModuleGroupView view;
    private ModuleGroupNode node;
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.view = new ModuleGroupView((Composite)this.shell, 0);
        this.node = new ModuleGroupNode();
        this.node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        this.view.bind(this.node);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.view);
        SwtUtilities.dispose((Widget)this.shell);
        this.node = null;
    }

    public void testCalculateHeight() {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        try {
            LnfManager.setLnf((RienaDefaultLnf)new MyLnF());
            int y = this.view.calculateHeight(-1, 10);
            ModuleGroupViewTest.assertEquals((int)10, (int)y);
            ModuleView moduleView = new ModuleView((Composite)this.shell);
            moduleView.setModuleGroupNode(this.node);
            ModuleNode moduleNode = new ModuleNode();
            this.node.addChild((INavigationNode)moduleNode);
            moduleView.bind(moduleNode);
            this.view.registerModuleView(moduleView);
            y = this.view.calculateHeight(-1, 10);
            ModuleGroupViewTest.assertTrue((y > 10 ? 1 : 0) != 0);
            FormData data = (FormData)this.view.getLayoutData();
            ModuleGroupViewTest.assertEquals((int)10, (int)data.top.offset);
            ModuleGroupViewTest.assertTrue((data.bottom.offset > 10 && data.bottom.offset < y ? 1 : 0) != 0);
            this.node.setVisible(false);
            y = this.view.calculateHeight(-1, 10);
            ModuleGroupViewTest.assertEquals((int)10, (int)y);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
        }
    }

    public void testUnbind() throws Exception {
        List listeners = (List)ReflectionUtils.getHidden((Object)this.node, (String)"listeners");
        ModuleGroupViewTest.assertEquals((int)1, (int)listeners.size());
        this.node.dispose();
        ModuleGroupViewTest.assertTrue((boolean)listeners.isEmpty());
    }

    public void testEqualsFormDatat() {
        FormData fd1 = new FormData();
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd1});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        FormData fd2 = new FormData();
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fd1.width = 25;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fd2.width = 25;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fd1.height = 25;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fd2.height = 25;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        FormAttachment fa1 = new FormAttachment(1, 2);
        FormAttachment fa2 = new FormAttachment(11, 22);
        FormAttachment fa3 = new FormAttachment(1, 2);
        fd1.bottom = fa1;
        fd2.bottom = fa2;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fd2.bottom = fa3;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fd1.left = fa1;
        fd2.left = fa2;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fd2.left = fa3;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fd1.right = fa1;
        fd2.right = fa2;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fd2.right = fa3;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fd1.top = fa1;
        fd2.top = fa2;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fd2.top = fa3;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fd1, fd2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
    }

    public void testEqualsFormAttachment() {
        FormAttachment fa1 = new FormAttachment();
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa1});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        FormAttachment fa2 = new FormAttachment();
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fa1.alignment = 131072;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fa2.alignment = 131072;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fa1.denominator = 50;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fa2.denominator = 50;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fa1.numerator = 11;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fa2.numerator = 11;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
        fa1.offset = 12;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertFalse((boolean)ret);
        fa2.offset = 12;
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.view, (String)"equals", (Object[])new Object[]{fa1, fa2});
        ModuleGroupViewTest.assertTrue((boolean)ret);
    }

    private static class MyLnF
    extends RienaDefaultLnf {
        private MyLnF() {
            this.update(new ILnfRendererExtension[]{new ILnfRendererExtension(){

                public String getLnfKey() {
                    return "ModuleGroup.renderer";
                }

                public String getLnfId() {
                    return "";
                }

                public ILnfRenderer createRenderer() {
                    return new ModuleGroupRenderer();
                }
            }});
        }
    }
}

