/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.views.SubApplicationView;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPageLayout;

@UITestCase
public class SubApplicationViewTest
extends TestCase {
    private Shell shell;
    private TestSubApplicationView view;
    private SubApplicationNode node;

    protected void setUp() throws Exception {
        this.view = new TestSubApplicationView();
        this.shell = new Shell();
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        locator.setBindingProperty((Object)this.shell, "applicationWindow");
        this.node = new SubApplicationNode();
        this.node.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        this.view.bind(this.node);
    }

    protected void tearDown() throws Exception {
        this.view = null;
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testUnbind() throws Exception {
        List listeners = (List)ReflectionUtils.getHidden((Object)this.node, (String)"listeners");
        SubApplicationViewTest.assertEquals((int)1, (int)listeners.size());
        this.node.dispose();
        SubApplicationViewTest.assertTrue((boolean)listeners.isEmpty());
    }

    public void testDisposeHandling() throws Exception {
        this.node.setNavigationNodeController((INavigationNodeController)new SubApplicationController((ISubApplicationNode)this.node));
        ModuleGroupNode mg = new ModuleGroupNode();
        this.node.addChild((INavigationNode)mg);
        ModuleNode m = new ModuleNode();
        mg.addChild((INavigationNode)m);
        this.view.createInitialLayout(null);
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("x"));
        m.addChild((INavigationNode)sm1);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("y"));
        m.addChild((INavigationNode)sm2);
        SubModuleNode sm3 = new SubModuleNode(new NavigationNodeId("z"));
        m.addChild((INavigationNode)sm3);
        this.view.viewUserCount = 1;
        this.view.providedId = new SwtViewId("test:test");
        this.view.hiddenId = null;
        sm1.dispose();
        SubApplicationViewTest.assertSame((Object)this.view.providedId, (Object)this.view.hiddenId);
        this.view.viewUserCount = 0;
        this.view.providedId = new SwtViewId("test:SHARED");
        this.view.hiddenId = null;
        sm2.dispose();
        SubApplicationViewTest.assertSame((Object)this.view.providedId, (Object)this.view.hiddenId);
        this.view.viewUserCount = 1;
        this.view.providedId = new SwtViewId("test:SHARED");
        this.view.hiddenId = null;
        sm2.dispose();
        SubApplicationViewTest.assertSame(null, (Object)this.view.hiddenId);
    }

    private class TestSubApplicationView
    extends SubApplicationView {
        private int viewUserCount = 0;
        private SwtViewId hiddenId = null;
        private SwtViewId providedId = null;

        private TestSubApplicationView() {
        }

        public SubApplicationNode getNavigationNode() {
            return SubApplicationViewTest.this.node;
        }

        protected int getViewUserCount(SwtViewId id) {
            return this.viewUserCount;
        }

        protected void hideView(SwtViewId id) {
            this.hiddenId = id;
        }

        protected void doBaseLayout(IPageLayout layout) {
        }

        protected ISubApplicationNode locateSubApplication(IPageLayout layout) {
            return SubApplicationViewTest.this.node;
        }

        protected SwtViewId getViewId(ISubModuleNode node) {
            return this.providedId;
        }
    }
}

