/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.StatuslineRidget;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.RidgetToStatuslineSubscriber;
import org.eclipse.riena.ui.ridgets.marker.StatuslineMessageMarkerViewer;

@NonUITestCase
public class RidgetToStatuslineSubscriberTest
extends TestCase {
    public void testSetStatuslineToShowMarkerMessages() throws Exception {
        IRidget r1 = (IRidget)EasyMock.createMock(IRidget.class);
        IComplexRidget r2 = (IComplexRidget)EasyMock.createMock(IComplexRidget.class);
        IBasicMarkableRidget r3 = (IBasicMarkableRidget)EasyMock.createMock(IBasicMarkableRidget.class);
        List<IRidget> ridgets = Arrays.asList(r1, r2, r3);
        final int[] addRidgetInvocationsCount = new int[1];
        final int[] removeRidgetInvocationsCount = new int[1];
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber(){

            protected StatuslineMessageMarkerViewer createMessageViewer(IStatuslineRidget statuslineToShowMarkerMessages) {
                return statuslineToShowMarkerMessages == null ? null : new StatuslineMessageMarkerViewer(statuslineToShowMarkerMessages){

                    public void addRidget(IBasicMarkableRidget markableRidget) {
                        addRidgetInvocationsCount[0] = addRidgetInvocationsCount[0] + 1;
                    }

                    public void removeRidget(IBasicMarkableRidget markableRidget) {
                        removeRidgetInvocationsCount[0] = removeRidgetInvocationsCount[0] + 1;
                    }
                };
            }
        };
        StatuslineRidget statuslineToShowMarkerMessages = new StatuslineRidget();
        r2.setStatuslineToShowMarkerMessages((IStatuslineRidget)statuslineToShowMarkerMessages);
        EasyMock.replay((Object[])new Object[]{r1, r2, r3});
        s.setStatuslineToShowMarkerMessages((IStatuslineRidget)statuslineToShowMarkerMessages, ridgets);
        EasyMock.verify((Object[])new Object[]{r1, r2, r3});
        RidgetToStatuslineSubscriberTest.assertEquals((int)1, (int)addRidgetInvocationsCount[0]);
        RidgetToStatuslineSubscriberTest.assertEquals((int)0, (int)removeRidgetInvocationsCount[0]);
        EasyMock.reset((Object[])new Object[]{r1, r2, r3});
        r2.setStatuslineToShowMarkerMessages(null);
        EasyMock.replay((Object[])new Object[]{r1, r2, r3});
        s.setStatuslineToShowMarkerMessages(null, ridgets);
        EasyMock.verify((Object[])new Object[]{r1, r2, r3});
        RidgetToStatuslineSubscriberTest.assertEquals((int)1, (int)addRidgetInvocationsCount[0]);
        RidgetToStatuslineSubscriberTest.assertEquals((int)1, (int)removeRidgetInvocationsCount[0]);
    }

    public void testAddRemoveRidgetBasicMarkableNoStatusline() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        IBasicMarkableRidget ridget = (IBasicMarkableRidget)EasyMock.createMock(IBasicMarkableRidget.class);
        EasyMock.replay((Object[])new Object[]{ridget});
        s.addRidget((IRidget)ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
        EasyMock.reset((Object[])new Object[]{ridget});
        EasyMock.replay((Object[])new Object[]{ridget});
        s.removeRidget((IRidget)ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
    }

    public void testAddRemoveRidgetBasicMarkable() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        IBasicMarkableRidget ridget = (IBasicMarkableRidget)EasyMock.createMock(IBasicMarkableRidget.class);
        final int[] addRidgetInvocationsCount = new int[1];
        final int[] removeRidgetInvocationsCount = new int[1];
        ReflectionUtils.setHidden((Object)s, (String)"messageViewer", (Object)new StatuslineMessageMarkerViewer((IStatuslineRidget)new StatuslineRidget()){

            public void addRidget(IBasicMarkableRidget markableRidget) {
                addRidgetInvocationsCount[0] = addRidgetInvocationsCount[0] + 1;
            }

            public void removeRidget(IBasicMarkableRidget markableRidget) {
                removeRidgetInvocationsCount[0] = removeRidgetInvocationsCount[0] + 1;
            }
        });
        EasyMock.replay((Object[])new Object[]{ridget});
        s.addRidget((IRidget)ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
        RidgetToStatuslineSubscriberTest.assertEquals((int)1, (int)addRidgetInvocationsCount[0]);
        RidgetToStatuslineSubscriberTest.assertEquals((int)0, (int)removeRidgetInvocationsCount[0]);
        EasyMock.reset((Object[])new Object[]{ridget});
        EasyMock.replay((Object[])new Object[]{ridget});
        s.removeRidget((IRidget)ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
        RidgetToStatuslineSubscriberTest.assertEquals((int)1, (int)addRidgetInvocationsCount[0]);
        RidgetToStatuslineSubscriberTest.assertEquals((int)1, (int)removeRidgetInvocationsCount[0]);
    }

    public void testAddRemoveRidgetNoBasicMarkable() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        IRidget ridget = (IRidget)EasyMock.createMock(IRidget.class);
        ReflectionUtils.setHidden((Object)s, (String)"messageViewer", (Object)new StatuslineMessageMarkerViewer((IStatuslineRidget)new StatuslineRidget()){

            public void addRidget(IBasicMarkableRidget markableRidget) {
                RidgetToStatuslineSubscriberTest.fail((String)"Invocation of this method is not expected in this case.");
            }

            public void removeRidget(IBasicMarkableRidget markableRidget) {
                RidgetToStatuslineSubscriberTest.fail((String)"Invocation of this method is not expected in this case.");
            }
        });
        EasyMock.replay((Object[])new Object[]{ridget});
        s.addRidget(ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
        EasyMock.reset((Object[])new Object[]{ridget});
        EasyMock.replay((Object[])new Object[]{ridget});
        s.removeRidget(ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
    }

    public void testAddRemoveRidgetContainer() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        IComplexRidget ridget = (IComplexRidget)EasyMock.createMock(IComplexRidget.class);
        StatuslineRidget r = new StatuslineRidget();
        ReflectionUtils.setHidden((Object)s, (String)"messageViewer", (Object)new StatuslineMessageMarkerViewer((IStatuslineRidget)r){

            public void addRidget(IBasicMarkableRidget markableRidget) {
                RidgetToStatuslineSubscriberTest.fail((String)"Invocation of this method is not expected in this case.");
            }

            public void removeRidget(IBasicMarkableRidget markableRidget) {
                RidgetToStatuslineSubscriberTest.fail((String)"Invocation of this method is not expected in this case.");
            }
        });
        ridget.setStatuslineToShowMarkerMessages((IStatuslineRidget)r);
        EasyMock.replay((Object[])new Object[]{ridget});
        s.addRidget((IRidget)ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
        EasyMock.reset((Object[])new Object[]{ridget});
        ridget.setStatuslineToShowMarkerMessages(null);
        EasyMock.replay((Object[])new Object[]{ridget});
        s.removeRidget((IRidget)ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
    }

    public void testAddRemoveRidgetContainerNoStatusline() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        IComplexRidget ridget = (IComplexRidget)EasyMock.createMock(IComplexRidget.class);
        EasyMock.replay((Object[])new Object[]{ridget});
        s.addRidget((IRidget)ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
        EasyMock.reset((Object[])new Object[]{ridget});
        EasyMock.replay((Object[])new Object[]{ridget});
        s.removeRidget((IRidget)ridget);
        EasyMock.verify((Object[])new Object[]{ridget});
    }

    public void testIsDifferentStatuslineNullNull() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        RidgetToStatuslineSubscriberTest.assertFalse((boolean)s.isDifferentStatusline(null));
    }

    public void testIsDifferentStatuslineNullNotNull() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        RidgetToStatuslineSubscriberTest.assertTrue((boolean)s.isDifferentStatusline((IStatuslineRidget)new StatuslineRidget()));
    }

    public void testIsDifferentStatuslineNotNullNull() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        ReflectionUtils.setHidden((Object)s, (String)"messageViewer", (Object)new StatuslineMessageMarkerViewer((IStatuslineRidget)new StatuslineRidget()));
        RidgetToStatuslineSubscriberTest.assertTrue((boolean)s.isDifferentStatusline(null));
    }

    public void testIsDifferentStatuslineNotNullNotNull() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        ReflectionUtils.setHidden((Object)s, (String)"messageViewer", (Object)new StatuslineMessageMarkerViewer((IStatuslineRidget)new StatuslineRidget()));
        RidgetToStatuslineSubscriberTest.assertTrue((boolean)s.isDifferentStatusline((IStatuslineRidget)new StatuslineRidget()));
    }

    public void testIsDifferentStatuslineSame() throws Exception {
        RidgetToStatuslineSubscriber s = new RidgetToStatuslineSubscriber();
        StatuslineRidget r = new StatuslineRidget();
        ReflectionUtils.setHidden((Object)s, (String)"messageViewer", (Object)new StatuslineMessageMarkerViewer((IStatuslineRidget)r));
        RidgetToStatuslineSubscriberTest.assertFalse((boolean)s.isDifferentStatusline((IStatuslineRidget)r));
    }
}

